/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.param.FormulaParam;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParamUtil;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.server.MessageThread;
import quadbase.common.server.OrganizerUtil;
import quadbase.common.server.Server;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.PageReport;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class CreateViewPagesSlave {
    FileOutputStream fstream = null;
    String urlfile = null;
    String rootFile = null;
    byte[] reportData;
    String basefile = null;
    Object[] params = null;
    Report rpt;
    ReportUI reportUI;
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    String[] columnNames;
    boolean[] isAsc;
    boolean popupParamDialog = false;
    private static final int SENDDATA = 0;
    private static final int SHOWPARAMDIALOG = 1;
    static final int EXPORTFILE = 2;
    static final int GETFILENAME = 4;
    static final int GETNEXTPARAMORDERVALUES = 5;
    boolean[] isMultiValue;
    boolean[] useComboBox;
    String[] dateFormat;
    Object[] defaultVal;
    boolean[] isSecParamMapped;
    int[] sqlType;
    boolean[] isAllOptionEnabled;
    String[] allOptionLabel;
    int maxOrder;
    Vector queryParams;
    int jobRequest;
    String exportfile;
    int exportType;
    boolean isMultiPageUsed;
    boolean paginatedSinglePage = false;
    boolean doSorting;
    boolean redrawReport = false;
    long bufferTime = 3600000L;
    boolean isdrilldown;
    boolean debug = false;
    String securityLevel = null;
    String[] columnName = null;
    int order = -1;
    int[] mapping;
    static Hashtable distinctTable;

    public CreateViewPagesSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.urlfile = messageThread.infile;
        this.rootFile = messageThread.getRootFile();
        this.reportData = messageThread.reportData;
        this.basefile = messageThread.outfile;
        this.params = messageThread.param;
        this.columnNames = messageThread.columnNames;
        this.isAsc = messageThread.isAsc;
        this.jobRequest = messageThread.jobRequest;
        this.exportfile = messageThread.exportfile;
        this.exportType = messageThread.exportType;
        this.isMultiPageUsed = messageThread.isMultiPageUsed;
        this.paginatedSinglePage = messageThread.paginatedSinglePage;
        this.doSorting = messageThread.doSorting;
        this.bufferTime = messageThread.bufferTime;
        this.securityLevel = messageThread.username;
        this.order = messageThread.order;
        this.mapping = messageThread.mapping;
    }

    /*
     * WARNING - void declaration
     */
    private Report loadReportFromFile(String urlname, byte[] reportData, Object[] param, FileInMemTable subFilesTable, boolean useBackupData) {
        try {
            Report newreport = null;
            LoadReport lr = new LoadReport();
            lr.setBackupDataUsed(useBackupData);
            if (subFilesTable != null) {
                lr.setSubFilesTable(subFilesTable);
            }
            lr.readOnly = true;
            lr.setSecurityLevel(this.securityLevel);
            if (reportData != null) {
                newreport = lr.loadReportFromByteArray(reportData);
            } else if (ServerMessage.isLoadBalancer) {
                newreport = lr.loadReportFromFile(urlname, null, null, true, false);
            } else {
                String reportURL = "http://" + ServerMessage.serverHost + ":" + ServerMessage.portNumber + this.getServletContext() + "/FileInfoServlet";
                URL servletURL = new URL(reportURL);
                URLConnection servletConnection = servletURL.openConnection();
                servletConnection.setDoOutput(true);
                ObjectOutputStream servletOut = new ObjectOutputStream(servletConnection.getOutputStream());
                servletOut.writeInt(this.getReadFileID());
                servletOut.writeObject(urlname);
                servletOut.flush();
                servletOut.close();
                ObjectInputStream servletIn = new ObjectInputStream(servletConnection.getInputStream());
                boolean success = servletIn.readBoolean();
                if (success) {
                    int count = servletIn.readInt();
                    byte[] byArray = new byte[count];
                    servletIn.readFully(byArray);
                    newreport = lr.loadReportFromByteArray(byArray);
                }
            }
            OrderedParameterSet allPromptParams = newreport.getParametersInSequence();
            boolean bl = this.isdrilldown = lr.getDrillDownNode() == null;
            if (param == null) {
                boolean bl2 = this.popupParamDialog = allPromptParams.size() > 0 && !useBackupData;
                if (this.popupParamDialog) {
                    return newreport;
                }
            } else {
                int ct = 0;
                if (this.isdrilldown) {
                    if (this.mapping == null || this.mapping.length == 0) {
                        this.mapping = new int[param.length];
                        for (int i = 0; i < param.length; ++i) {
                            if (param[i] != null && !param[i].equals("UnMapped")) continue;
                            this.mapping[i] = -1;
                        }
                    }
                    newreport.currentNode.setColumnMapping(this.mapping);
                    allPromptParams = newreport.getParametersInSequence(newreport.currentNode);
                    if (newreport.dbInfo instanceof QueryFileInfo) {
                        QueryFileInfo queryFileInfo = (QueryFileInfo)newreport.dbInfo;
                        QueryInParamSet inSet = queryFileInfo.getInSet();
                        QueryInParam[] inParam = inSet.getParameter();
                        QueryInParam[][] paramInPromptSequence = new QueryInParam[param.length][param.length];
                        int unMappedCt = 0;
                        for (Object element : param) {
                            if (element != null && !element.equals("UnMapped")) continue;
                            ++unMappedCt;
                        }
                        if (unMappedCt > 0) {
                            void var15_28;
                            unMappedCt = 0;
                            boolean bl3 = false;
                            while (var15_28 < param.length) {
                                if (param[var15_28] != null && !param[var15_28].equals("UnMapped")) {
                                    inParam[var15_28].setValue(param[var15_28]);
                                }
                                ++var15_28;
                            }
                            new ParamUtil().setupParamInPromptSequence(inParam, allPromptParams, paramInPromptSequence);
                            inSet.setParameterInPromptSequence(paramInPromptSequence);
                            this.popupParamDialog = true;
                            return newreport;
                        }
                    }
                }
                this.maxOrder = newreport.getMaxParameterOrder();
                Vector[] choice = this.getParamChoices(newreport, this.maxOrder);
                OrderedParameterSet ops = newreport.getParametersInSequence();
                for (int i = 0; i < ops.getOrderCount(); ++i) {
                    Parameters allParams = ops.getParamsAt(i);
                    for (int j = 0; j < allParams.size(); ++j) {
                        Param param2 = allParams.get(j);
                        Parameters ps = allParams.get(param2.name());
                        if (ps == null || ps.size() <= 0) continue;
                        if (!param2.isFormulaParam() && ct < param.length) {
                            int index = ct++;
                            if (param2.multiValue() && param2.isMapToColumn()) {
                                if (choice[j] != null && param[index] instanceof Vector && choice[j].size() == ((Vector)param[index]).size()) {
                                    param2.setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                                } else {
                                    param2.setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                                }
                            }
                            this.makeQueryParam(param2, param[index]);
                            newreport.setSubReportParamValues(param2);
                        }
                        if (!param2.isFormulaParam() || ct >= param.length) continue;
                        this.makeFormulaParam(param2, param[ct++]);
                        newreport.setSubReportParamValues(param2);
                    }
                }
                newreport = ReloadReport.reloadData(newreport, true, null, 0, -1);
                if (this.popupParamDialog) {
                    return newreport;
                }
            }
            if (this.columnNames == null || this.columnNames.length <= 0) {
                boolean doPreCal = newreport.isPreCalculationRequired();
                this.reportUI = new ReportUI(newreport, IOUtil.getOffScreenGraphics(), doPreCal, true);
                if (!doPreCal) {
                    this.reportUI.preCalcTotalSections();
                }
                return newreport;
            }
            newreport.formatTable();
            ReportTable table = newreport.getReportTables().elementAt(0);
            block8: for (int j = 0; j < this.columnNames.length; ++j) {
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    ReportColumn reportColumn = table.getColumn(i);
                    if (!this.columnNames[j].equals(reportColumn.getText()) && !this.columnNames[j].equals(newreport.colInfo[i].getName())) continue;
                    table.createIndexArray(i, this.isAsc[j], newreport, 0);
                    this.redrawReport = true;
                    if (newreport.getReportType() == 0) continue block8;
                    newreport.formatTable();
                    continue block8;
                }
            }
            boolean doPreCal = newreport.isPreCalculationRequired();
            this.reportUI = new ReportUI(newreport, IOUtil.getOffScreenGraphics(), doPreCal, true);
            if (!doPreCal) {
                this.reportUI.preCalcTotalSections();
            }
            return newreport;
        }
        catch (Exception ex) {
            this.cleanup(3, ex.toString() + "\n", true);
            ex.printStackTrace();
        }
        catch (Error err) {
            this.cleanup(3, err.toString() + "\n", true);
        }
        return null;
    }

    private byte[] readData() throws Exception {
        if (this.rpt == null) {
            throw new Exception("Cannot create report object");
        }
        try {
            if (!this.redrawReport && new File(this.server.getPath(this.basefile + "_FIRST.page")).exists()) {
                long createTime = this.server.getPageFileCreateTime(this.basefile);
                long curTime = System.currentTimeMillis();
                if (curTime - createTime <= this.bufferTime) {
                    if (this.debug) {
                        System.out.println("REUSE BUFFER");
                    }
                    return this.server.toByteArray(this.basefile + "_FIRST.page");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PageReport pageReport = new PageReport(this.rpt);
        pageReport.isPageViewer = true;
        return pageReport.exportPages(this.reportUI, this.server.getPath(this.basefile));
    }

    void getNextParamOrderValues(String urlname, byte[] reportData, Object[] param, int[] mapping) {
        try {
            Report newreport = null;
            LoadReport lc = new LoadReport();
            lc.readOnly = true;
            lc.setSecurityLevel(this.securityLevel);
            if (reportData != null) {
                newreport = lc.loadReportFromByteArray(reportData);
            } else if (ServerMessage.isLoadBalancer) {
                newreport = this.loadReportFromFile(urlname, null, param, null, false);
            } else {
                String reportURL = "http://" + ServerMessage.serverHost + ":" + ServerMessage.portNumber + this.getServletContext() + "/FileInfoServlet";
                URL servletURL = new URL(reportURL);
                URLConnection servletConnection = servletURL.openConnection();
                servletConnection.setDoOutput(true);
                ObjectOutputStream servletOut = new ObjectOutputStream(servletConnection.getOutputStream());
                servletOut.writeInt(this.getReadFileID());
                servletOut.writeObject(urlname);
                servletOut.flush();
                servletOut.close();
                ObjectInputStream servletIn = new ObjectInputStream(servletConnection.getInputStream());
                boolean success = servletIn.readBoolean();
                if (success) {
                    int count = servletIn.readInt();
                    byte[] barray = new byte[count];
                    servletIn.readFully(barray);
                    newreport = lc.loadReportFromByteArray(barray);
                }
            }
            int ct = 0;
            DrillDownNode node = new DrillDownNode();
            node.setColumnMapping(mapping);
            newreport.currentNode = node;
            OrderedParameterSet allPromptParams = newreport.getParametersInSequence(node);
            QueryFileInfo queryFileInfo = (QueryFileInfo)newreport.dbInfo;
            QueryInParamSet inSet = queryFileInfo.getInSet();
            QueryInParam[] inParam = inSet.getParameter();
            QueryInParam[][] paramInPromptSequence = new QueryInParam[inParam.length][inParam.length];
            new ParamUtil().setupParamInPromptSequence(inParam, allPromptParams, paramInPromptSequence);
            inSet.setParameterInPromptSequence(paramInPromptSequence);
            for (int i = 0; i < this.order; ++i) {
                Parameters allParams = newreport.getParametersInSequence().getParamsAt(i);
                for (int j = 0; j < allParams.size(); ++j) {
                    Param p = allParams.get(j);
                    if (!p.isFormulaParam() && ct < param.length) {
                        this.makeQueryParam(p, param[ct++]);
                    } else if (p.isFormulaParam() && ct < param.length) {
                        this.makeFormulaParam(p, param[ct++]);
                    }
                    newreport.setSubReportParamValues(p);
                }
            }
            Vector[] choice = this.getParamChoices(newreport, this.order);
            DataOutputStream outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            outstream.writeInt(choice.length);
            for (Vector vector : choice) {
                outstream.writeInt(vector.size());
                for (int j = 0; j < vector.size(); ++j) {
                    IOUtil.writeString(outstream, DataType.write(vector.elementAt(j)));
                }
            }
            for (Object object : this.defaultVal) {
                if (object instanceof Vector) {
                    Vector e = (Vector)object;
                    outstream.writeInt(e.size());
                    for (Object def : e) {
                        IOUtil.writeString(outstream, DataType.write(def));
                    }
                    continue;
                }
                outstream.writeInt(1);
                IOUtil.writeString(outstream, DataType.write(object));
            }
            this.cleanup(0, "Finish\n", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, ex.toString() + "\n", false);
        }
        catch (Error err) {
            this.cleanup(3, err.toString() + "\n", false);
        }
    }

    public void run() {
        if (this.authenticate(20881)) {
            if (this.jobRequest == 4) {
                this.getFileName();
                return;
            }
            if (this.jobRequest == 5) {
                this.getNextParamOrderValues(this.urlfile, this.reportData, this.params, this.mapping);
                return;
            }
            if (this.reportData == null) {
                this.reportData = this.loadReportFromDatabase(this.urlfile);
            }
            if (this.rootFile != null && !this.rootFile.equals("")) {
                Report rootReport = this.loadReportFromFile(this.rootFile, null, null, null, true);
                this.rpt = this.loadReportFromFile(this.urlfile, this.reportData, this.params, rootReport.getSubFilesTable(), false);
            } else {
                this.rpt = this.loadReportFromFile(this.urlfile, this.reportData, this.params, null, false);
            }
            if (this.rpt == null) {
                this.cleanup(3, "Report is null\n", true);
                return;
            }
            if (this.jobRequest == 2) {
                this.export();
            } else if (this.popupParamDialog) {
                this.writeParamDialog();
            } else {
                this.writeOutput();
            }
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    void writeOutput() {
        try {
            byte[] indata = this.readData();
            if (indata == null) {
                this.cleanup(3, "byte array is empty\n", true);
                return;
            }
            DataOutputStream outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            outstream.writeInt(0);
            outstream.writeInt(this.rpt.getPWidth());
            outstream.writeInt(this.rpt.getPHeight());
            outstream.writeInt(this.reportUI.getTotalSections());
            outstream.writeInt(this.rpt.getOrientation());
            Vector<ReportTable> vector = this.rpt.getReportTables();
            Vector<String> list = new Vector<String>();
            if (this.rpt.getReportType() != 2) {
                for (int k = 0; k < vector.size(); ++k) {
                    ReportTable reporttable = vector.elementAt(k);
                    for (int i1 = 0; i1 < reporttable.getColumnCount(); ++i1) {
                        if (!reporttable.getColumn(i1).isVisible() && (this.rpt.getReportType() != 3 || !this.rpt.colInfo[i1].isMaster())) continue;
                        ReportTable tbl = reporttable;
                        while (tbl instanceof ReportTreeTable && ((ReportTreeTable)tbl).getSubTable() != null && ((ReportTreeTable)tbl).getSubTable().size() > 0) {
                            tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(0);
                        }
                        if (tbl.getColumn(i1).getDataCount() <= 0 || tbl.getColumn(i1).getData(0) instanceof ReportImage || tbl.getColumn(i1).getData(0) instanceof ReportDocument) continue;
                        list.addElement(reporttable.getColumn(i1).getText());
                    }
                }
            } else {
                ColInfo[] colInfo = this.rpt.colInfo;
                for (ColInfo element : colInfo) {
                    if (!element.isVisible() || !element.isRowBreak()) continue;
                    list.addElement(element.getName());
                }
            }
            outstream.writeInt(list.size());
            for (int i = 0; i < list.size(); ++i) {
                IOUtil.writeString(outstream, (String)list.elementAt(i));
            }
            boolean isMultiDrillDownValues = this.isMultiDrillDownValues();
            outstream.writeBoolean(isMultiDrillDownValues);
            if (isMultiDrillDownValues) {
                DrillDownNode child = (DrillDownNode)this.rpt.currentNode.children().nextElement();
                IOUtil.writeString(outstream, child.getFileName());
                int[] mapping = child.getColumnMapping();
                outstream.writeInt(mapping.length);
                for (int element : mapping) {
                    int mapIdx = this.rpt.colInfo[element].getMapping();
                    IOUtil.writeString(outstream, this.rpt.colData[mapIdx].getName());
                    outstream.writeInt(this.rpt.colData[mapIdx].getOriginalDataType());
                    Vector<Object> listData = this.rpt.colData[mapIdx].getDistinctValue();
                    outstream.writeInt(listData.size());
                    for (int j = 0; j < listData.size(); ++j) {
                        IOUtil.writeString(outstream, DataType.write(listData.elementAt(j)));
                    }
                }
            }
            outstream.writeBoolean(this.rpt.getReportType() == 0);
            outstream.writeInt(indata.length);
            outstream.write(indata, 0, indata.length);
            outstream.close();
            this.cleanup(0, "Finish\n", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, ex.toString() + "\n", false);
        }
        catch (Error err) {
            this.cleanup(3, err.toString() + "\n", false);
        }
    }

    private void cleanup(int code, String err, boolean ack) {
        this.rpt = null;
        System.gc();
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.urlfile + " -- ";
    }

    private boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    Object[] parseObject(String param) {
        if (param == null || param.trim().equals("")) {
            return null;
        }
        int idx = param.indexOf("&PARAM");
        Vector<Object> vec = new Vector<Object>();
        String token = null;
        for (int k = 0; idx >= 0 && k < 5; ++k) {
            int nextIdx = (param = param.substring(param.indexOf(61) + 1)).indexOf("&PARAM");
            token = nextIdx >= 0 ? param.substring(0, nextIdx) : param;
            idx = nextIdx;
            try {
                token = QbUtil.urlDecode(token);
                Object obj = DataType.read(token);
                vec.addElement(obj);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Object[] objs = new Object[vec.size()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = vec.elementAt(i);
        }
        return objs;
    }

    private void export() {
        try {
            this.rpt.setExportToMultiPages(this.isMultiPageUsed);
            this.rpt.setExportToSingleWPagination(this.paginatedSinglePage);
            this.rpt.setDynamicExport(this.messageThread.isDynamicExport, this.messageThread.serverName, this.messageThread.serverPort);
            this.rpt.setServletDirectory(this.messageThread.servletDirectory);
            int key = -1;
            if (this.messageThread.exportTarget) {
                this.export(this.rpt, this.exportType, this.exportfile);
            } else {
                key = this.export(this.rpt, this.exportType, new URL(this.messageThread.exportServlet));
            }
            DataOutputStream outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            outstream.writeInt(key);
            this.cleanup(0, "Finish\n", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, ex.toString() + "\n", false);
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(3, err.toString() + "\n", false);
        }
    }

    private void export(Report report, int format, String fileName) throws Exception {
        report.export(format, this.server.getPath(fileName), report.currentNode);
    }

    private int export(Report report, int format, URL servlet) throws Exception {
        URLConnection con = servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/octet-stream");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        report.export(format, bao, report.currentNode);
        byte[] bytes = bao.toByteArray();
        ObjectOutputStream out = new ObjectOutputStream(con.getOutputStream());
        out.writeInt(bytes.length);
        Properties info = new Properties();
        info.setProperty("format", String.valueOf(format));
        out.writeObject(info);
        out.write(bytes, 0, bytes.length);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(con.getInputStream()));
        in.readBoolean();
        int key = in.readInt();
        return key;
    }

    void getFileName() {
        String str = this.doSorting ? this.server.getPageFileName() : this.server.getPageFileName(this.basefile);
        try {
            DataOutputStream outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            IOUtil.writeString(outstream, str);
            this.cleanup(0, "Finish\n", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, ex.toString() + "\n", false);
        }
        catch (Error err) {
            this.cleanup(3, err.toString() + "\n", false);
        }
    }

    int[] getParameterSequence(int startIndex) {
        OrderedParameterSet params = this.rpt.getParametersInSequence();
        int[] seq = new int[params.getOrderCount() - startIndex];
        for (int i = 0; i < params.getOrderCount() - startIndex; ++i) {
            seq[i] = params.getParamsAt(i + startIndex).size();
        }
        return seq;
    }

    private void writeParamDialog() {
        try {
            DataOutputStream outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            outstream.writeInt(1);
            int temp_order = this.order;
            if (this.order == 0) {
                temp_order = -1;
            }
            if (this.columnName == null) {
                this.columnName = this.getParamName(this.rpt, temp_order);
            }
            Vector[] choice = this.getParamChoices(this.rpt, temp_order);
            outstream.writeInt(this.maxOrder);
            outstream.writeInt(this.order);
            int[] seq = this.getParameterSequence(0);
            outstream.writeInt(seq.length);
            for (int element : seq) {
                outstream.writeInt(element);
            }
            outstream.writeInt(this.columnName.length);
            for (int i = 0; i < this.columnName.length; ++i) {
                IOUtil.writeString(outstream, this.columnName[i]);
                outstream.writeBoolean(this.isMultiValue[i]);
                if (this.isMultiValue[i]) {
                    outstream.writeInt(((Vector)this.defaultVal[i]).size());
                    for (Object v : (Vector)this.defaultVal[i]) {
                        IOUtil.writeString(outstream, DataType.write(v));
                    }
                } else {
                    IOUtil.writeString(outstream, DataType.write(this.defaultVal[i]));
                }
                outstream.writeBoolean(this.useComboBox[i]);
                outstream.writeBoolean(false);
                IOUtil.writeStr(outstream, this.dateFormat[i]);
                outstream.writeInt(this.sqlType[i]);
                outstream.writeInt(choice[i].size());
                for (int j = 0; j < choice[i].size(); ++j) {
                    IOUtil.writeString(outstream, DataType.write(choice[i].elementAt(j)));
                }
                outstream.writeBoolean(this.isAllOptionEnabled[i]);
                IOUtil.writeStr(outstream, this.allOptionLabel[i]);
            }
            if (this.mapping == null) {
                outstream.writeInt(0);
            } else {
                outstream.writeInt(this.mapping.length);
                for (int element : this.mapping) {
                    outstream.writeInt(element);
                }
            }
            int[] reorderedMapping = this.getReorderedMapping(this.rpt, temp_order);
            if (reorderedMapping == null) {
                outstream.writeInt(0);
            } else {
                outstream.writeInt(reorderedMapping.length);
                for (int element : reorderedMapping) {
                    outstream.writeInt(element);
                }
            }
            this.cleanup(0, "Finish\n", false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, ex.toString() + "\n", false);
        }
        catch (Error err) {
            this.cleanup(3, err.toString() + "\n", false);
        }
    }

    private int[] getReorderedMapping(Report report, int order) {
        IQueryInParam[] qip = null;
        if (this.rpt.dbInfo instanceof QueryFileInfo) {
            qip = ((QueryFileInfo)this.rpt.dbInfo).getInParam();
        }
        if (this.mapping == null || qip == null || this.mapping.length != qip.length) {
            return null;
        }
        Parameters allPromptParams = order == -1 ? report.getParametersInSequence() : report.getParametersInSequence().getParamsAt(order);
        int[] newMapping = new int[allPromptParams.size()];
        for (int i = 0; i < allPromptParams.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < qip.length; ++j) {
                if (!allPromptParams.get(i).parent().equalsIgnoreCase("MAIN_REPORT") || !allPromptParams.get(i).name().equals(qip[j].getParamName()) || this.mapping[j] <= -1) continue;
                found = true;
                newMapping[i] = j;
            }
            if (found) continue;
            newMapping[i] = -1;
        }
        return newMapping;
    }

    String[] getParamName(Report report, int order) {
        Parameters allPromptParams = order == -1 ? report.getParametersInSequence() : report.getParametersInSequence().getParamsAt(order);
        String[] params = new String[allPromptParams.size()];
        for (int i = 0; i < allPromptParams.size(); ++i) {
            params[i] = allPromptParams.get(i).name();
        }
        return params;
    }

    Vector[] getParamChoices(Report report, int order) {
        Parameters allPromptParams = null;
        allPromptParams = order > -1 && report.getParametersInSequence().getOrderCount() > order ? report.getParametersInSequence().getParamsAt(order) : report.getParametersInSequence();
        Vector[] distinctVals = new Vector[allPromptParams.size()];
        this.defaultVal = new Object[allPromptParams.size()];
        this.useComboBox = new boolean[allPromptParams.size()];
        this.isMultiValue = new boolean[allPromptParams.size()];
        this.dateFormat = new String[allPromptParams.size()];
        this.sqlType = new int[allPromptParams.size()];
        this.isAllOptionEnabled = new boolean[allPromptParams.size()];
        this.allOptionLabel = new String[allPromptParams.size()];
        for (int i = 0; i < allPromptParams.size(); ++i) {
            int j;
            Param param = allPromptParams.get(i);
            OrderedParameterSet ops = param.getReport().getParametersInSequence(true);
            int reportOrder = 0;
            boolean found = false;
            while (!found && reportOrder < ops.getOrderCount()) {
                Parameters ps = ops.getParamsAt(reportOrder);
                for (j = 0; j < ps.size(); ++j) {
                    if (!ps.get(j).name().equals(param.name())) continue;
                    found = true;
                }
                if (found) continue;
                ++reportOrder;
            }
            if (!param.isFormulaParam()) {
                this.isMultiValue[i] = param.multiValue();
                this.defaultVal[i] = param.getDefaultValue();
                this.dateFormat[i] = param.getDateFormat();
                if (param.getSelectionChoices() != null) {
                    distinctVals[i] = param.getSelectionChoices();
                    this.useComboBox[i] = true;
                }
                if (param instanceof QueryParam) {
                    QueryInParam qip = ((QueryParam)param).findParam();
                    this.isAllOptionEnabled[i] = qip.isAllOptionEnabled();
                    this.allOptionLabel[i] = qip.getAllOptionLabel();
                }
                if (distinctVals[i] != null) continue;
                if (param.getSqlSelect() != null) {
                    try {
                        Vector result = new Vector();
                        result = QueryParser.executeSQLSelect((IDatabaseInfo)param.getQueryFileInfo(), param.getSqlSelect(), (Parameters)ops, false);
                        distinctVals[i] = (Vector)result.elementAt(0);
                        if (result.size() > 1) {
                            if (distinctTable == null) {
                                distinctTable = new Hashtable();
                            }
                            Hashtable table = new Hashtable();
                            for (int j2 = 0; j2 < distinctVals[i].size(); ++j2) {
                                String key = distinctVals[i].elementAt(j2).toString();
                                Object object = ((Vector)result.elementAt(1)).elementAt(j2);
                                table.put(key, object);
                            }
                            distinctTable.put(param.getSqlSelect(), table);
                        }
                        this.useComboBox[i] = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (param.isMapToColumn()) {
                    if (param.getQueryFileInfo() instanceof QueryXMLFileInfo) {
                        distinctVals[i] = QueryParser.getDistinctValues(((QueryXMLFileInfo)param.getQueryFileInfo()).getXMLFileQueryInfo(), param.getColumnName(), reportOrder);
                    } else {
                        distinctVals[i] = QueryParser.getDistinctValues((DBInfoBasic)((Object)param.getQueryFileInfo()), param.getTableName(), param.getColumnName(), reportOrder);
                        if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null && param.getDateFormat().length() > 0) {
                            if (distinctTable == null) {
                                distinctTable = new Hashtable();
                            }
                            Hashtable<String, String> table = new Hashtable<String, String>();
                            for (j = 0; j < distinctVals[i].size(); ++j) {
                                String key = QbDateFormat.getFormattedDateTime((Date)distinctVals[i].elementAt(j), param.getDateFormat());
                                String object = distinctVals[i].elementAt(j).toString();
                                table.put(key, object);
                            }
                            distinctTable.put(param.name() + param.getDateFormat(), table);
                            QbDateFormat df = new QbDateFormat(distinctVals[i]);
                            try {
                                distinctVals[i] = df.getFormattedDate(param.getDateFormat(), this.allOptionLabel[i]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.useComboBox[i] = true;
                    continue;
                }
                distinctVals[i] = new Vector();
                this.sqlType[i] = param.getSqlType();
                this.useComboBox[i] = false;
                continue;
            }
            this.isMultiValue[i] = false;
            this.defaultVal[i] = param.getDefaultValue();
            this.dateFormat[i] = null;
            if (param.isMapToColumn()) {
                int idx = ((FormulaParam)param).getMapColIdx();
                distinctVals[i] = param.getReport().colData[idx].getDistinctValue();
                if (distinctVals[i] != null && distinctVals[i].size() == 0) {
                    distinctVals[i].addElement(param.getDefaultValue());
                }
                this.useComboBox[i] = true;
                continue;
            }
            distinctVals[i] = new Vector();
            this.sqlType[i] = param.getSqlType();
            this.useComboBox[i] = false;
        }
        return distinctVals;
    }

    private void makeFormulaParam(Param param, Object value) {
        param.setValue(value);
    }

    private void makeQueryParam(Param param, Object value) {
        if (value == null) {
            return;
        }
        Vector<Object> valueObject = null;
        Hashtable table = null;
        if (distinctTable != null && param.getSqlSelect() != null) {
            table = (Hashtable)distinctTable.get(param.getSqlSelect());
        } else if (distinctTable != null && param.getDateFormat() != null && param.getDateFormat().length() > 0 && distinctTable.get(param.name() + param.getDateFormat()) != null) {
            table = (Hashtable)distinctTable.get(param.name() + param.getDateFormat());
        }
        if (table != null) {
            if (param.multiValue()) {
                if (value instanceof Vector) {
                    valueObject = (Vector<Object>)value;
                    for (int i = 0; i < valueObject.size(); ++i) {
                        valueObject.setElementAt(table.get(valueObject.elementAt(i)), i);
                    }
                } else {
                    valueObject = new Vector<Object>();
                    valueObject.addElement(table.get(value));
                }
                if (valueObject.size() == 0) {
                    valueObject = null;
                }
                param.setValues(valueObject);
            } else {
                param.setValue(table.get(value));
            }
        } else if (param.multiValue()) {
            if (value instanceof Vector) {
                valueObject = (Vector)value;
            } else {
                valueObject = new Vector();
                valueObject.addElement(value);
            }
            if (valueObject.size() == 0) {
                valueObject = null;
            }
            param.setValues(valueObject);
        } else {
            param.setValue(value);
        }
    }

    private boolean isMultiDrillDownValues() {
        DrillDownNode node = this.rpt.currentNode;
        Enumeration<TreeNode> en = node.children();
        if (!en.hasMoreElements()) {
            return false;
        }
        if (!this.isMultiValueParameter()) {
            return false;
        }
        en.nextElement();
        return !en.hasMoreElements();
    }

    boolean isMultiValueParameter() {
        try {
            LoadReport lr = new LoadReport();
            lr.readOnly = true;
            String filename = ((DrillDownNode)this.rpt.currentNode.children().nextElement()).getFileName();
            Report nrpt = lr.loadReportFromFile(filename, null, null, true, false);
            IQueryInParam[] queryParamSet = null;
            if (nrpt.dbInfo != null && nrpt.dbInfo instanceof QueryFileInfo) {
                queryParamSet = ((QueryFileInfo)nrpt.dbInfo).getInSet().getParameter();
            } else if (nrpt.dbInfo != null && nrpt.dbInfo instanceof IQueryFileInfo) {
                queryParamSet = ReportUtil.getInParam(nrpt.dbInfo);
            }
            if (queryParamSet != null) {
                for (int i = 0; i < queryParamSet.length; ++i) {
                    if (queryParamSet[i] instanceof IQueryMultiValueInParam) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getServletContext() throws Exception {
        if (LCKey.isDashboard() || LCKey.isERES()) {
            return OrganizerUtil.getServletContext();
        }
        return "/ERES/servlet";
    }

    private int getReadFileID() {
        if (LCKey.isDashboard() || LCKey.isERES()) {
            return OrganizerUtil.getReadFileID();
        }
        return 58;
    }

    private byte[] loadReportFromDatabase(String fileName) {
        if (LCKey.isDashboard() || LCKey.isERES()) {
            return OrganizerUtil.loadReportFromDatabase(fileName);
        }
        return null;
    }
}

