/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.server.DBdistinctSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;

public class DBFirstValueSlave
extends ParamQuerySlave {
    DBInfoBasic dbInfo;
    String tableName;
    String columnName;
    int sqlType;
    Object value = null;

    public DBFirstValueSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dbInfo = messageThread.dbInfo;
        this.tableName = messageThread.tableName;
        this.columnName = messageThread.columnName;
    }

    @Override
    int getMessageType() {
        return 15765;
    }

    @Override
    void slaveBody() throws Exception {
        this.sqlType = this.getSqlType();
        this.value = QueryParser.getFirstValueFromLocal(this.dbInfo, this.tableName, this.columnName);
    }

    @Override
    String getArguments() {
        if (this.dbInfo.isUseJNDIDataSource()) {
            return this.dbInfo.getJNDIName();
        }
        return this.dbInfo.getDriverName() + " " + this.dbInfo.getURLString();
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.sqlType);
        DataType.write(dout, this.value);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSqlType() throws Exception {
        String query = "select distinct " + this.columnName + " from " + this.tableName;
        try (Connection con = this.dbInfo.openConnection();){
            int result;
            int n = result = DBdistinctSlave.getSqlType(con, query);
            return n;
        }
    }
}

