/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;

public class DBdistinctSlave
extends ParamQuerySlave {
    DBInfoBasic dbInfo;
    String tableName;
    String columnName;
    String sqlSelect;
    int nDistinctValue;
    int sqlType;
    int useDefaultValue;
    Vector distinctValue;
    Vector result;
    String status;
    boolean isDefaultValue;

    public DBdistinctSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dbInfo = messageThread.dbInfo;
        this.tableName = messageThread.tableName;
        this.columnName = messageThread.columnName;
        this.sqlSelect = QueryParser.removeComments(messageThread.query);
        this.useDefaultValue = messageThread.defaultValue;
        this.isDefaultValue = messageThread.isDefaultValue;
        this.distinctValue = new Vector();
    }

    @Override
    int getMessageType() {
        return 16789;
    }

    @Override
    void slaveBody() throws Exception {
        if (this.sqlSelect != null) {
            Connection con = this.dbInfo.openConnection();
            if (this.messageThread.slaveType == 16791) {
                this.status = QueryParser.testSqlSelectLocally(this.dbInfo, this.sqlSelect, this.isDefaultValue);
            } else {
                this.sqlType = DBdistinctSlave.getSqlType(con, this.sqlSelect);
                this.result = QueryParser.executeSqlSelectLocally(this.dbInfo, this.sqlSelect, this.useDefaultValue);
                this.distinctValue = (Vector)this.result.elementAt(0);
                if (this.useDefaultValue == 2) {
                    this.distinctValue.remove(this.distinctValue.size() - 1);
                }
                this.nDistinctValue = this.distinctValue.size();
            }
        } else {
            this.sqlType = this.getSqlType();
            this.distinctValue = QueryParser.getValuesFromLocal(this.dbInfo, this.tableName, this.columnName);
            this.nDistinctValue = this.distinctValue.size();
        }
    }

    @Override
    String getArguments() {
        if (this.dbInfo.isUseJNDIDataSource()) {
            return this.dbInfo.getJNDIName();
        }
        return this.dbInfo.getDriverName() + " " + this.dbInfo.getURLString();
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        if (this.messageThread.slaveType == 16791) {
            IOUtil.writeString(dout, this.status);
        } else {
            int i;
            dout.writeInt(this.sqlType);
            dout.writeInt(this.nDistinctValue);
            if (this.result != null && this.result.size() > 1) {
                dout.writeBoolean(true);
                for (i = 0; i < this.nDistinctValue; ++i) {
                    IOUtil.writeString(dout, this.distinctValue.elementAt(i).toString());
                    DataType.write(dout, this.sqlType, ((Vector)this.result.elementAt(1)).elementAt(i));
                }
            } else {
                dout.writeBoolean(false);
                for (i = 0; i < this.nDistinctValue; ++i) {
                    DataType.write(dout, this.sqlType, this.distinctValue.elementAt(i));
                }
            }
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSqlType() throws Exception {
        Connection con = this.dbInfo.openConnection();
        String query = "select distinct " + this.columnName + " from " + this.tableName + " where 1=2";
        try {
            query = QueryParser.removeComments(query);
            query = query.replaceAll("\\r\\n|\\r|\\n", " ");
            if (con.getMetaData().getDatabaseProductName().toLowerCase().indexOf("mysql") >= 0 && query.toLowerCase().indexOf(" limit ") < 0) {
                query = query + " LIMIT 0, 1";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int result;
            int n = result = DBdistinctSlave.getSqlType(con, query);
            return n;
        }
        finally {
            con.close();
        }
    }

    static int getSqlType(Connection con, String query) throws Exception {
        ResultSetMetaData rsmd = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            ps = con.prepareStatement(query);
            rsmd = ps.getMetaData();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (rsmd == null || rsmd.getColumnType(1) == 0) {
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            rsmd = rs.getMetaData();
        }
        int columnCt = rsmd.getColumnCount();
        int sqlType = rsmd.getColumnType(columnCt);
        if (ps != null) {
            ps.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return sqlType;
    }
}

