/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.MapToFunction;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;

public class DBparamFunctionMetaSlave
extends ParamQuerySlave {
    DBInfoBasic dbInfo;
    String paramFunction;
    String tableNames;
    int sqlType;

    public DBparamFunctionMetaSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dbInfo = messageThread.dbInfo;
        this.paramFunction = messageThread.paramFunction;
        this.tableNames = messageThread.tableNames;
    }

    @Override
    int getMessageType() {
        return 18658;
    }

    @Override
    void slaveBody() throws Exception {
        this.sqlType = MapToFunction.getFunctionSQLTypeFromLocal(this.dbInfo, this.paramFunction, this.tableNames);
    }

    @Override
    String getArguments() {
        if (this.dbInfo.isUseJNDIDataSource()) {
            return this.dbInfo.getJNDIName();
        }
        return this.dbInfo.getDriverName() + " " + this.dbInfo.getURLString();
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.sqlType);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }
}

