/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;

public class DBparamTypeSlave
extends ParamQuerySlave {
    DBInfoBasic dbInfo;
    int nParam;
    Vector paramType;

    public DBparamTypeSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dbInfo = messageThread.dbInfo;
    }

    @Override
    int getMessageType() {
        return 25679;
    }

    @Override
    void slaveBody() throws Exception {
        this.paramType = QueryParser.getTypesFromLocal(this.dbInfo);
        this.nParam = this.paramType.size();
    }

    @Override
    String getArguments() {
        if (this.dbInfo.isUseJNDIDataSource()) {
            return this.dbInfo.getJNDIName() + ", " + this.dbInfo.getQuery();
        }
        return this.dbInfo.getDriverName() + ", " + this.dbInfo.getURLString() + ", " + this.dbInfo.getQuery();
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.nParam);
        for (int i = 0; i < this.nParam; ++i) {
            int temp = (Integer)this.paramType.elementAt(i);
            dout.writeInt(temp);
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }
}

