/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import quadbase.chart.ColMetaData;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;

public class DBqueryMetaSlave
extends ParamQuerySlave {
    DBInfoBasic dbInfo;
    boolean transposeData;
    boolean[] transposeCol;
    QueryInParamSet inParamSet;
    Vector colMetaData;
    int nInfo;

    public DBqueryMetaSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dbInfo = messageThread.dbInfo;
        this.inParamSet = messageThread.inParamSet;
        this.transposeData = messageThread.transposeData;
        this.transposeCol = messageThread.transposeCol;
    }

    @Override
    int getMessageType() {
        return 23612;
    }

    @Override
    void slaveBody() throws Exception {
        Vector<QueryInParamSet> parameters = new Vector<QueryInParamSet>();
        if (this.inParamSet != null) {
            parameters.addElement(this.inParamSet);
        }
        this.colMetaData = ColMetaData.makeFromLocalDB(parameters, this.dbInfo, this.transposeData, this.transposeCol);
        this.nInfo = this.colMetaData.size();
    }

    @Override
    String getArguments() {
        if (this.dbInfo.isUseJNDIDataSource()) {
            return this.dbInfo.getJNDIName();
        }
        return this.dbInfo.getDriverName() + " " + this.dbInfo.getURLString();
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.nInfo);
        for (int i = 0; i < this.nInfo; ++i) {
            ((ColMetaData)this.colMetaData.elementAt(i)).write(dout);
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }
}

