/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import quadbase.chart.ColData;
import quadbase.chart.ColDataResultSet;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.server.BufferedResultSet;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.ReplacementPolicy;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataType;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;

public class DataBuffer {
    boolean isFile = false;
    String fileName = null;
    DBInfoBasic dbInfo;
    Connection connection;
    int nBuffer = 0;
    int count = 0;
    int bufSize = 0;
    ReplacementPolicy rp;
    BufferedResultSet[] bufferedResultSet;
    static final int LOWPRIORITY = 1;
    static final int HIGHPRIORITY = 4;

    public DataBuffer(int buffer, String fileName) {
        this(buffer);
        this.isFile = true;
        this.fileName = fileName;
    }

    public DataBuffer(int buffer, DBInfoBasic dbInfo) {
        this(buffer);
        this.isFile = false;
        this.dbInfo = dbInfo;
    }

    private DataBuffer(int buffer) {
        this.nBuffer = buffer;
        this.rp = new ReplacementPolicy(this.nBuffer);
        this.bufferedResultSet = new BufferedResultSet[this.nBuffer];
    }

    public boolean getIsFile() {
        return this.isFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean sourceFromFile() {
        return this.isFile;
    }

    public void setDataBuffer(DBInfoBasic dbInfo) {
        this.isFile = false;
        this.dbInfo = dbInfo;
    }

    Connection getConnection() {
        return this.connection;
    }

    void setConnection(Connection conn) {
        this.close();
        this.connection = conn;
        try {
            DatabaseMetaData dmd = this.connection.getMetaData();
            if (dmd.getMaxStatements() == 1) {
                this.nBuffer = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized Connection createConnection() throws Exception {
        this.setConnection(this.dbInfo.openConnection());
        return this.connection;
    }

    synchronized void close() {
        for (int i = 0; i < this.bufSize; ++i) {
            try {
                if (this.bufferedResultSet[i] == null) continue;
                this.bufferedResultSet[i].close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            this.connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean equals(DataBuffer ds) {
        if (ConnectionBuffer.nBuffer < 1) {
            return false;
        }
        if (ds.getIsFile()) {
            return this.getIsFile() && ds.getFileName().equals(this.getFileName());
        }
        return ds.dbInfo.equalsIgnoreQuery(this.dbInfo);
    }

    public synchronized void addData(String sql, QueryInParamSet qSet, ColData[] colData, int priority) {
        if (this.nBuffer == 0) {
            return;
        }
        int index = this.rp.getNextIndex();
        if (this.bufferedResultSet[index] != null) {
            this.bufferedResultSet[index].close();
        }
        this.bufferedResultSet[index] = new BufferedResultSet(sql, qSet, (ColDataResultSet)ColData.getResultSet(colData));
        if (index >= this.bufSize) {
            ++this.bufSize;
        }
        this.rp.setUsed(index, priority);
    }

    public synchronized void addData(String sql, QueryInParamSet qSet, IResultSet rs, int priority) throws Exception {
        if (this.nBuffer == 0) {
            return;
        }
        int index = this.rp.getNextIndex();
        if (this.bufferedResultSet[index] != null) {
            this.bufferedResultSet[index].close();
        }
        this.bufferedResultSet[index] = new BufferedResultSet(sql, qSet, rs);
        if (index >= this.bufSize) {
            ++this.bufSize;
        }
        this.rp.setUsed(index, priority);
    }

    public int getUseBuffer() {
        if (this.nBuffer == 0) {
            return 0;
        }
        int buf = 0;
        for (int i = 0; i < this.bufSize; ++i) {
            if (this.bufferedResultSet[i] == null) continue;
            ++buf;
        }
        return buf;
    }

    public boolean isInBuffer(String qry, QueryInParamSet qSet) {
        return this.getIndex(qry, qSet) >= 0;
    }

    public int getIndex(String qry, QueryInParamSet qSet) {
        if (this.nBuffer == 0) {
            return -1;
        }
        for (int i = 0; i < this.bufSize; ++i) {
            if (this.bufferedResultSet[i] == null || !this.bufferedResultSet[i].equals(qry, qSet)) continue;
            return i;
        }
        return -1;
    }

    public boolean refresh(BufferedResultSet rs) {
        for (int i = 0; i < this.bufSize; ++i) {
            if (this.bufferedResultSet[i] == null || !this.bufferedResultSet[i].equals(rs)) continue;
            this.bufferedResultSet[i].close();
            this.bufferedResultSet[i] = null;
            this.rp.setNotUsed(i);
            return true;
        }
        return false;
    }

    public void refreshAll() {
        for (int i = 0; i < this.bufSize; ++i) {
            if (this.bufferedResultSet[i] != null) {
                this.bufferedResultSet[i].close();
            }
            this.bufferedResultSet[i] = null;
            this.rp.setNotUsed(i);
        }
    }

    public synchronized void setPriority(BufferedResultSet rs, int priority) {
        if (this.nBuffer == 0) {
            return;
        }
        for (int i = 0; i < this.bufSize; ++i) {
            if (this.bufferedResultSet[i] == null || !this.bufferedResultSet[i].equals(rs)) continue;
            this.rp.changeUsed(i, priority);
            return;
        }
    }

    public synchronized void setPriority(int bufferedRSIndex, int priority) {
        if (bufferedRSIndex < 0) {
            return;
        }
        this.rp.changeUsed(bufferedRSIndex, priority);
    }

    public IResultSet getResultSet(String qry, QueryInParamSet qSet) {
        return this.getResultSet(qry, qSet, 0, -1);
    }

    public IResultSet getResultSet(String qry, QueryInParamSet qSet, int startIndex, int displayRow) {
        int idx = this.getIndex(qry, qSet);
        if (idx < 0) {
            return null;
        }
        return this.getResultSet(idx, startIndex, displayRow);
    }

    public IResultSet getResultSet(int index) {
        return this.getResultSet(index, 0, -1);
    }

    public IResultSet getResultSet(int index, int startIndex, int displayRow) {
        IResultSet irs = this.getResultSet(this.bufferedResultSet[index], startIndex, displayRow);
        try {
            if (irs != null) {
                IRSMetaData imd = irs.getMetaData();
                for (int i = 1; i <= imd.getColumnCount(); ++i) {
                    if (DataType.mapType(imd.getColumnType(i)) != 15) continue;
                    this.bufferedResultSet[index] = null;
                    i = imd.getColumnCount() + 1;
                }
            }
        }
        catch (OutOfMemoryError memoryerror) {
            try {
                this.bufferedResultSet[index].close();
                this.bufferedResultSet[index] = null;
                this.rp.setNotUsed(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            memoryerror.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return irs;
    }

    public IResultSet getResultSet(BufferedResultSet rs) {
        return this.getResultSet(rs, 0, -1);
    }

    public IResultSet getResultSet(BufferedResultSet rs, int startIndex, int displayRow) {
        try {
            return rs.getResultSet(startIndex, displayRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DataSet[] getValues(int index, int startIndex, int displayRow) {
        try {
            DataSet[] retvect = this.bufferedResultSet[index].getValue(startIndex, displayRow);
            IResultSet irs = this.getResultSet(this.bufferedResultSet[index], startIndex, displayRow);
            try {
                IRSMetaData imd = irs.getMetaData();
                for (int i = 1; i <= imd.getColumnCount(); ++i) {
                    if (DataType.mapType(imd.getColumnType(i)) != 15) continue;
                    this.bufferedResultSet[index] = null;
                    i = imd.getColumnCount() + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return retvect;
        }
        catch (OutOfMemoryError memoryerror) {
            try {
                this.bufferedResultSet[index].close();
                this.bufferedResultSet[index] = null;
                this.rp.setNotUsed(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            memoryerror.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getRowCount(int index) {
        return this.bufferedResultSet[index].getRowCount();
    }
}

