/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;
import quadbase.reportdesigner.report.ColMetaData;

public class DataFileMetaSlave
extends ParamQuerySlave {
    String dataFilename;
    boolean transposeData;
    boolean[] transposeCol;
    Vector colMetaData;
    int nInfo;
    int sourceType;
    private QueryInParamSet inSet = null;

    public DataFileMetaSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dataFilename = messageThread.infile.startsWith("http://") || messageThread.infile.startsWith("https://") || messageThread.infile.startsWith("/") || messageThread.infile.indexOf(":/") >= 0 ? messageThread.infile : server.getPath(messageThread.infile);
        this.transposeData = messageThread.transposeData;
        this.transposeCol = messageThread.transposeCol;
        this.sourceType = messageThread.sourceType;
        this.inSet = messageThread.inParamSet;
    }

    @Override
    int getMessageType() {
        return 25367;
    }

    @Override
    void slaveBody() throws Exception {
        this.colMetaData = ColMetaData.makeFromLocalDataFile(this.dataFilename, this.transposeData, this.transposeCol, this.sourceType, this.inSet);
        this.nInfo = this.colMetaData.size();
    }

    @Override
    String getArguments() {
        return this.dataFilename;
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.nInfo);
        for (int i = 0; i < this.nInfo; ++i) {
            ((ColMetaData)this.colMetaData.elementAt(i)).write(dout);
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }
}

