/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.server.UserInfo;
import quadbase.common.server.datareg.DataRegResult;
import quadbase.common.server.datareg.DataRegServer;
import quadbase.common.server.datareg.DataRegUser;
import quadbase.common.server.datareg.XmlNodePath;
import quadbase.common.util.internal.IOUtil;
import quadbase.datasourcemanager.manager.ReadXMLTable;

public class DataRegistrySlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    Vector vec;
    String infile;
    DefaultMutableTreeNode treeNode;
    private String fileLockMessage = null;
    private DataOutputStream dout;
    private DataInputStream din;
    ReadXMLTable readXml = new ReadXMLTable();
    private static boolean DEBUG = false;
    static Hashtable users = new Hashtable();

    public DataRegistrySlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.infile = messageThread.infile;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.messageThread.remoteAddr, messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
            this.infile = this.server.getPath(this.infile);
            mess = this.server.checkReadPermission(this.infile, this.messageThread.remoteAddr);
            if (mess != null) {
                this.fileLockMessage = mess;
                if (this.fileLockMessage.lastIndexOf(10) >= 0) {
                    this.fileLockMessage = this.fileLockMessage.substring(this.fileLockMessage.lastIndexOf(10) + 1);
                }
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        DataRegistrySlave.debug("DataRegistrySlave.run()");
        if (!this.authenticate(23801)) {
            return;
        }
        DataRegistrySlave.debug("authenticated");
        try {
            DataRegUser u = this.getUser();
            DataInputStream in = new DataInputStream(this.client_socket.getInputStream());
            short command = in.readShort();
            DataRegistrySlave.debug("command=" + command);
            this.messageThread.details = this.messageThread.details + " COMMAND = ";
            switch (command) {
                case 100: {
                    this.messageThread.details = this.messageThread.details + "OPEN";
                    this.open(u);
                    break;
                }
                case 101: {
                    this.messageThread.details = this.messageThread.details + "EDIT NODE";
                    this.edit(u);
                    break;
                }
                case 102: {
                    this.messageThread.details = this.messageThread.details + "CLOSE EDIT NODE";
                    this.closeEdit(u);
                    break;
                }
                case 103: {
                    this.messageThread.details = this.messageThread.details + "ADD NODE";
                    this.add(u);
                    break;
                }
                case 104: {
                    this.messageThread.details = this.messageThread.details + "CLOSE ADD NODE";
                    this.closeAdd(u, false);
                    break;
                }
                case 105: {
                    this.messageThread.details = this.messageThread.details + "CLOSE ADD NODE CANCEL";
                    this.closeAdd(u, true);
                    break;
                }
                case 108: {
                    this.messageThread.details = this.messageThread.details + "ADD NODE NO CLOSE";
                    this.addNodeNoClose(u);
                    break;
                }
                case 106: {
                    this.messageThread.details = this.messageThread.details + "REMOVE NODE";
                    this.remove(u);
                    break;
                }
                case 107: {
                    this.messageThread.details = this.messageThread.details + "COPY NODE";
                    this.copy(u);
                    break;
                }
                case 109: {
                    this.messageThread.details = this.messageThread.details + "GET NODE LOCK";
                    this.getNodeLock(u);
                    break;
                }
                case 110: {
                    this.messageThread.details = this.messageThread.details + "OVERRIDE NODE LOCK";
                    this.overrideNodeLock(u);
                    break;
                }
                case 111: {
                    this.messageThread.details = this.messageThread.details + "GET OVERRIDE NODE INFO";
                    this.getOverrideNodeInfo(u);
                    break;
                }
                case 112: {
                    this.messageThread.details = this.messageThread.details + "CLEAR OVERRIDE NODE";
                    this.clearOverrideNode(u);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, "Fail to open data registry:" + ex.toString() + "\n");
        }
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        IOUtil.writeStr(dout, this.fileLockMessage);
        ReadXMLTable.writeNode(this.treeNode, dout);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            try {
                this.client_socket.getOutputStream().flush();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }

    DataRegUser getUser() {
        String hostName = this.client_socket.getPeerHost();
        String hostAddr = this.client_socket.getPeerAddress();
        DataRegUser u = (DataRegUser)users.get(hostAddr);
        if (u == null) {
            UserInfo userInfo = this.getUserInfo(hostName, hostAddr);
            u = DataRegServer.createUser(userInfo);
            u.setHostAddr(hostAddr);
            users.put(hostAddr, u);
        }
        return u;
    }

    UserInfo getUserInfo(String hostName, String hostAddress) {
        Iterator<UserInfo> iterator = this.server.userInfo.iterator();
        while (iterator.hasNext()) {
            UserInfo element;
            UserInfo usr = element = iterator.next();
            if (usr.machine == null || !usr.machine.equals(hostName) && !usr.machine.equals(hostAddress)) continue;
            return usr;
        }
        return new UserInfo(hostName, true);
    }

    void open(DataRegUser u) throws Exception {
        DataRegistrySlave.debug("open(DataRegUser)");
        this.openRequest();
        String encoding = IOUtil.readString(this.din, true);
        this.treeNode = DataRegServer.openDataReg(u, this.infile, encoding, this.messageThread.fromLoadBalancer);
        this.sendReply();
    }

    void edit(DataRegUser u) throws Exception {
        DataRegistrySlave.debug("edit(DataRegUser)");
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        DataRegResult result = DataRegServer.editNode(u, nodePath, this.messageThread.fromLoadBalancer);
        this.treeNode = result.root();
        this.openResponse();
        boolean success = result.success();
        DataRegistrySlave.debug("success=" + success);
        this.writeNode();
        this.writeBoolean(success);
        String lockedUserHostInfo = result.getLockedUserHostAddr();
        if (lockedUserHostInfo == null) {
            lockedUserHostInfo = "";
        }
        IOUtil.writeString(this.dout, lockedUserHostInfo);
        String lockedNodePath = result.getLockedNodePath();
        if (lockedNodePath == null) {
            lockedNodePath = "";
        }
        IOUtil.writeString(this.dout, lockedNodePath);
        this.flushResponse();
    }

    void closeEdit(DataRegUser u) throws Exception {
        DataRegistrySlave.debug("closeEdit(DataRegUser)");
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        DefaultMutableTreeNode changedNode = this.readNode();
        DataRegServer.closeEditNode(u, nodePath, changedNode, this.messageThread.fromLoadBalancer);
    }

    void add(DataRegUser u) throws Exception {
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        DataRegResult result = DataRegServer.addNode(u, nodePath, this.messageThread.fromLoadBalancer);
        this.treeNode = result.root();
        this.openResponse();
        boolean success = result.success();
        this.writeNode();
        this.writeBoolean(success);
        String lockedUserHostInfo = result.getLockedUserHostAddr();
        if (lockedUserHostInfo == null) {
            lockedUserHostInfo = "";
        }
        IOUtil.writeString(this.dout, lockedUserHostInfo);
        String lockedNodePath = result.getLockedNodePath();
        if (lockedNodePath == null) {
            lockedNodePath = "";
        }
        IOUtil.writeString(this.dout, lockedNodePath);
        this.flushResponse();
    }

    void closeAdd(DataRegUser u, boolean cancel) throws Exception {
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        DefaultMutableTreeNode addedNode = null;
        if (!cancel) {
            addedNode = this.readNode();
        }
        DataRegServer.endAddNode(u, nodePath, addedNode, this.messageThread.fromLoadBalancer);
    }

    void addNodeNoClose(DataRegUser u) throws Exception {
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        DefaultMutableTreeNode addedNode = this.readNode();
        DataRegResult result = DataRegServer.addNodeNoClose(u, nodePath, addedNode, this.messageThread.fromLoadBalancer);
        this.treeNode = result.root();
        this.openResponse();
        this.writeNode();
        this.flushResponse();
    }

    void remove(DataRegUser u) throws Exception {
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        DataRegResult result = DataRegServer.removeNode(u, nodePath, this.messageThread.fromLoadBalancer);
        this.treeNode = result.root();
        this.openResponse();
        boolean success = result.success();
        this.writeNode();
        this.writeBoolean(success);
        this.flushResponse();
    }

    void copy(DataRegUser u) throws Exception {
        this.openRequest();
        XmlNodePath srcPath = this.readXmlNodePath();
        XmlNodePath destPath = this.readXmlNodePath();
        String destFile = IOUtil.readString(this.din, true);
        String srcFile = IOUtil.readString(this.din, true);
        DataRegResult result = DataRegServer.copyNode(u, srcPath, destPath, destFile, srcFile, this.messageThread.fromLoadBalancer);
        this.treeNode = result.root();
        this.openResponse();
        boolean success = result.success();
        this.writeNode();
        this.writeBoolean(success);
        this.flushResponse();
    }

    void getNodeLock(DataRegUser u) throws Exception {
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        String lockStr = "";
        lockStr = DataRegServer.getUserForLock(u, nodePath);
        this.openResponse();
        IOUtil.writeString(this.dout, lockStr);
        this.flushResponse();
    }

    void overrideNodeLock(DataRegUser u) throws Exception {
        this.openRequest();
        XmlNodePath nodePath = this.readXmlNodePath();
        String result = DataRegServer.overrideNodeLock(u, nodePath);
        this.openResponse();
        IOUtil.writeString(this.dout, result);
        this.flushResponse();
    }

    void getOverrideNodeInfo(DataRegUser u) throws Exception {
        this.openRequest();
        String nodePathStr = IOUtil.readString(this.din, true);
        String lockedUserInfo = DataRegServer.getOverrideNodeInfo(u, nodePathStr);
        this.openResponse();
        IOUtil.writeString(this.dout, lockedUserInfo);
        this.flushResponse();
    }

    void clearOverrideNode(DataRegUser u) throws Exception {
        this.openRequest();
        String result = DataRegServer.clearOverrideNode(u);
        this.openResponse();
        IOUtil.writeString(this.dout, result);
        this.flushResponse();
    }

    void openResponse() throws IOException {
        this.dout = new DataOutputStream(this.client_socket.getOutputStream());
    }

    void flushResponse() throws IOException {
        this.dout.flush();
    }

    void openRequest() throws IOException {
        this.din = new DataInputStream(this.client_socket.getInputStream());
    }

    void closeRequest() throws IOException {
        this.din.close();
    }

    void writeNode() throws Exception {
        ReadXMLTable.writeNode(this.treeNode, this.dout);
    }

    DefaultMutableTreeNode readNode() throws Exception {
        return this.readXml.readNode(this.din);
    }

    void writeBoolean(boolean b) throws IOException {
        this.dout.writeBoolean(b);
    }

    XmlNodePath readXmlNodePath() throws IOException {
        XmlNodePath dummy;
        int len = this.din.readShort();
        XmlNodePath temp = dummy = new XmlNodePath("dummy");
        this.messageThread.details = this.messageThread.details + " PATH = ";
        for (int i = 0; i < len; ++i) {
            String nodeName = IOUtil.readString(this.din, true);
            this.messageThread.details = this.messageThread.details + nodeName + "/";
            XmlNodePath node = new XmlNodePath(nodeName);
            temp.setNext(node);
            temp = temp.next();
        }
        return dummy.next();
    }

    static void debug(String s) {
        if (DEBUG) {
            System.out.println("DEBUG: DataRegistrySlave - " + s);
        }
    }
}

