/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.queryproc.IQueryProc;
import quadbase.queryproc.IQueryProcFactory;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;
import quadbase.util.internal.IQueryProcInfo;

public abstract class DataSlave {
    static IQueryProcFactory queryProcFactory;
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    protected ConnectionBuffer connectionBuffer;

    public DataSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.connectionBuffer = server.getConnectionBuffer();
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    IQueryProcInfo getPreprocessInfo() {
        return null;
    }

    IResultSet preprocess(IResultSet irs) throws Exception {
        try {
            IQueryProcInfo qInfo = this.getPreprocessInfo();
            IQueryProc q = queryProcFactory.createQueryProc(qInfo.getSelectionColType(), true);
            q.setDrawNullColumn(this.messageThread.drawNullColumn, this.messageThread.nullHandleName);
            q.setInputResultSet(irs);
            q.setInputInfo(qInfo);
            q.run();
            return q.getOutputRows();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void run() {
        if (this.authenticate(20876)) {
            byte[] indata = this.readData();
            this.writeOutput(indata);
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    void writeData(DataOutputStream out, Object obj) throws IOException {
        if (this.messageThread.drawNullColumn && obj instanceof String && this.messageThread.nullHandleName.equals(obj)) {
            DataType.write(out, null);
        } else {
            DataType.write(out, obj);
        }
    }

    IResultSet preProcess(IResultSet irs) throws Exception {
        return irs;
    }

    byte[] writeToBuffer(IResultSet rs) throws Exception {
        int i;
        ByteArrayOutputStream bStream = new ByteArrayOutputStream(1024);
        DataOutputStream dStream = new DataOutputStream(bStream);
        IRSMetaData md = rs.getMetaData();
        int nCol = md.getColumnCount();
        int nRow = 0;
        int[] columnType = new int[nCol];
        for (i = 1; i <= nCol; ++i) {
            String columnName = md.getColumnName(i);
            String tblName = "";
            try {
                tblName = md.getTableName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            columnType[i - 1] = md.getColumnType(i);
            IOUtil.writeString(dStream, columnName);
            IOUtil.writeString(dStream, tblName);
            dStream.writeInt(columnType[i - 1]);
        }
        while (!ServerMessage.exceedLimit(nRow) && rs.next()) {
            for (i = 1; i <= nCol; ++i) {
                Object temp = rs.getObject(i);
                if (i == nCol && columnType[nCol - 1] == 8 && !(temp instanceof Double) && temp != null) {
                    temp = Double.valueOf(temp.toString());
                }
                if ((columnType[i - 1] == 3 || columnType[i - 1] == 2) && temp instanceof Double && temp != null) {
                    temp = BigDecimal.valueOf((Double)temp);
                }
                this.writeData(dStream, temp);
            }
            ++nRow;
        }
        dStream.close();
        byte[] outBuf = bStream.toByteArray();
        bStream.close();
        ByteArrayOutputStream bStream2 = new ByteArrayOutputStream(1024);
        DataOutputStream dStream2 = new DataOutputStream(bStream2);
        dStream2.writeInt(nRow);
        dStream2.writeInt(nCol);
        dStream2.write(outBuf, 0, outBuf.length);
        dStream2.close();
        return bStream2.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void writeOutput(byte[] indata) {
        if (indata == null) {
            return;
        }
        DataOutputStream outstream = null;
        try {
            outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            outstream.writeInt(indata.length);
            outstream.write(indata, 0, indata.length);
            this.cleanup(0, "Finish\n", false);
        }
        catch (Exception ex) {
            this.cleanup(0, ex.toString() + "\n", false);
            CloseUtils.close(outstream);
        }
        catch (Error err) {
            this.cleanup(0, err.toString() + "\n", false);
            {
                catch (Throwable throwable) {
                    CloseUtils.close(outstream);
                    throw throwable;
                }
            }
            CloseUtils.close(outstream);
        }
        CloseUtils.close(outstream);
    }

    abstract byte[] readData();

    abstract void cleanup(int var1, String var2, boolean var3);

    abstract String getHeader();
}

