/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;

public class DefaultFilesSlave
extends Thread {
    String filename = null;
    Server server;
    IConnection client_socket;

    public DefaultFilesSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.server = server;
        this.client_socket = socket;
        this.filename = messageThread.infile;
    }

    @Override
    public void run() {
        try {
            this.runSlave();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runSlave() throws Exception {
        if (this.filename.equals("globalFormat")) {
            this.sendReply(ServerMessage.getDefaultGlobalFormat());
        } else if (this.filename.equals("fontMapping")) {
            this.sendReply(ServerMessage.getDefaultFontMapping());
        } else if (this.filename.equals("htmlDpi")) {
            this.sendReply(String.valueOf(QbUtil.pixelPerInchExport));
        } else if (this.filename.equals("paperSize")) {
            this.sendReply(ServerMessage.getPaperSizeStr());
        }
    }

    void sendReply(String file) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeBoolean(file == null);
        if (file != null) {
            IOUtil.writeString(dout, file);
        }
        try {
            byte[] array = bstream.toByteArray();
            this.client_socket.setContentLength(array.length);
            this.client_socket.getOutputStream().write(array);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }
}

