/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.File;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;

public class DeleteFileSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public DeleteFileSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        String deleteFile = this.messageThread.deleteFile;
        int drillNum = this.messageThread.drillNum;
        DataOutputStream dout = null;
        boolean success = false;
        String previousFile = deleteFile + drillNum + ".tpl";
        File file = new File(this.server.getPath(previousFile));
        if (file.exists()) {
            success = file.delete();
        }
        String nextFile = deleteFile + ++drillNum + ".tpl";
        File nfile = new File(this.server.getPath(nextFile));
        while (nfile.exists()) {
            nfile.renameTo(file);
            previousFile = nextFile;
            file = new File(this.server.getPath(previousFile));
            nextFile = deleteFile + ++drillNum + ".tpl";
            nfile = new File(this.server.getPath(nextFile));
        }
        int code = success ? 0 : 6;
        try {
            dout = new DataOutputStream(this.client_socket.getOutputStream());
            dout.writeInt(code);
        }
        catch (Exception exception) {
            CloseUtils.close(dout);
            CloseUtils.close(this.client_socket);
            catch (Throwable throwable) {
                CloseUtils.close(dout);
                CloseUtils.close(this.client_socket);
                throw throwable;
            }
        }
        CloseUtils.close(dout);
        CloseUtils.close(this.client_socket);
    }
}

