/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import quadbase.common.server.Server;
import quadbase.common.server.UserInfo;
import quadbase.common.swing.SortedComboBoxModel;

public class DeleteUserDialog
extends JDialog {
    private JLabel lbUsername;
    private JButton btnDelete;
    private JButton btnCancel;
    private JComboBox<String> cbUsers;
    private boolean succeeded;
    private Vector<UserInfo> userInfo;

    public DeleteUserDialog(Frame parent, Vector<UserInfo> userInfo) {
        super(parent, "Delete Existing User", true);
        this.userInfo = userInfo;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.fill = 2;
        this.lbUsername = new JLabel("Username: ");
        cs.gridx = 0;
        cs.gridy = 0;
        cs.gridwidth = 1;
        panel.add((Component)this.lbUsername, cs);
        SortedComboBoxModel<String> model = new SortedComboBoxModel<String>(this.getUserList(userInfo));
        this.cbUsers = new JComboBox<String>(model);
        cs.gridx = 1;
        cs.gridy = 0;
        cs.gridwidth = 2;
        panel.add(this.cbUsers, cs);
        this.btnDelete = new JButton("Delete");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeleteUserDialog.this.deleteUser()) {
                    JOptionPane.showMessageDialog(DeleteUserDialog.this, "User " + DeleteUserDialog.this.getUsername() + " is deleted!", "Delete New User", 1);
                    DeleteUserDialog.this.cbUsers.removeItem(DeleteUserDialog.this.getUsername());
                    DeleteUserDialog.this.succeeded = true;
                } else {
                    DeleteUserDialog.this.succeeded = false;
                }
            }
        });
        this.btnCancel = new JButton("Close");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteUserDialog.this.dispose();
            }
        });
        JPanel bp = new JPanel();
        bp.add(this.btnDelete);
        bp.add(this.btnCancel);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)bp, "Last");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public String getUsername() {
        return this.cbUsers.getSelectedItem().toString();
    }

    private boolean deleteUser() {
        try {
            this.deleteUser(this.getUsername());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void deleteUser(String username) throws Exception {
        File inFile = new File(Server.configDir, "config.txt");
        File outFile = new File("tempfile.txt");
        FileInputStream fis = new FileInputStream(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        FileOutputStream fos = new FileOutputStream(outFile);
        PrintWriter out = new PrintWriter(fos);
        String thisLine = "";
        while ((thisLine = in.readLine()) != null) {
            thisLine = thisLine.trim();
            String name = "";
            int idx = thisLine.indexOf(32);
            name = idx <= 0 ? thisLine : thisLine.substring(0, idx);
            if (name.equalsIgnoreCase(username)) continue;
            out.println(thisLine);
        }
        out.flush();
        out.close();
        in.close();
        inFile.delete();
        outFile.renameTo(inFile);
        Iterator<UserInfo> iterator = this.userInfo.iterator();
        while (iterator.hasNext()) {
            UserInfo uInfo = iterator.next();
            if (!uInfo.getUser().equals(username)) continue;
            iterator.remove();
        }
    }

    private String[] getUserList(Vector<UserInfo> userInfos) {
        String[] result = new String[userInfos.size()];
        int i = 0;
        for (UserInfo uinfo : userInfos) {
            result[i] = uinfo.getUser();
            ++i;
        }
        return result;
    }
}

