/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class DesignerSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    DataOutputStream outstream = null;

    public DesignerSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    public void run() {
        this.server.userCounter(true);
        try {
            this.server.writeLog(this.getHeader() + "start...\n");
            String errmessage = this.messageThread.isOrganizer ? this.server.userCheck(this.messageThread.blogin ? 1 : 2, this.client_socket.getPeerAddress()) : this.server.userCheck(this.messageThread.blogin ? 1 : 2, this.messageThread.username, this.messageThread.password, this.messageThread.isFromQbDesigner, this.client_socket.getPeerAddress(), 30831);
            this.outstream = new DataOutputStream(this.client_socket.getOutputStream());
            if (errmessage != null) {
                this.cleanup(1, errmessage);
            } else {
                this.cleanup(0, "Finish\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(1, ex.toString());
            return;
        }
        catch (Error err) {
            this.cleanup(1, err.toString());
            return;
        }
    }

    void cleanup(int code, String err) {
        this.acknowledge(code, err);
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.outstream != null) {
            try {
                this.outstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Fail to Acknowledge client " + ex.toString(), true);
        }
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\n" + (this.messageThread.blogin ? "login " + this.messageThread.username : "logout ") + " -- ";
    }
}

