/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.rmi.PortableRemoteObject;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.IOUtil;

public class EJBAccessSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public EJBAccessSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(32416)) {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                String jndiName = this.messageThread.jndiName;
                String homeName = this.messageThread.homeName;
                String remoteName = this.messageThread.remoteName;
                String selectedMethodName = this.messageThread.selectedMethodName;
                Object[] param = this.messageThread.param;
                Hashtable<String, String> environment = this.messageThread.environment;
                InitialContext initial = new InitialContext(environment);
                Object objref = initial.lookup(jndiName);
                Class<?> homeClass = Class.forName(homeName);
                Class<?> remoteClass = Class.forName(remoteName);
                Object home = PortableRemoteObject.narrow((Object)objref, homeClass);
                Method[] getters = EJBAccessSlave.retrieveGetters(remoteClass);
                Method method = EJBAccessSlave.getMethod(homeClass, selectedMethodName);
                Object result = method.invoke(home, param);
                Object[] ret = null;
                if (result instanceof Collection) {
                    ret = ((Collection)result).toArray();
                } else if (result instanceof Enumeration) {
                    Server.println(this.server, "EspressReport now only support EJB2.0");
                } else {
                    Server.println(this.server, "RETURN TYPE IS WRONG.");
                }
                int nRow = ret.length;
                int nCol = getters.length;
                dout.writeInt(nRow);
                dout.writeInt(nCol);
                for (Method getter : getters) {
                    String colName = getter.getName().substring(3);
                    String retTypeName = getter.getReturnType().getName();
                    int type = EJBUtil.mapFieldType(retTypeName);
                    IOUtil.writeString(dout, retTypeName);
                    IOUtil.writeString(dout, colName);
                    dout.writeInt(type);
                }
                if (ret != null) {
                    for (Object element : ret) {
                        for (Method getter : getters) {
                            Object objResult = getter.invoke(element, new Object[0]);
                            IOUtil.writeString(dout, objResult.toString());
                        }
                    }
                }
                dout.close();
                byte[] outBuffer = bstream.toByteArray();
                bstream.close();
                ByteArrayOutputStream bStream2 = new ByteArrayOutputStream(1024);
                DataOutputStream dStream2 = new DataOutputStream(bStream2);
                dStream2.writeInt(0);
                dStream2.writeInt(outBuffer.length);
                dStream2.write(outBuffer, 0, outBuffer.length);
                dStream2.close();
                this.client_socket.getOutputStream().write(bStream2.toByteArray());
                this.client_socket.getOutputStream().flush();
                this.client_socket.getOutputStream().write(0);
                this.client_socket.getOutputStream().flush();
            }
            catch (NameNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                this.cleanup(7, "Server failed to access the ejb component :" + ex.toString() + "\n");
            }
        }
    }

    private static Method[] retrieveGetters(Class remoteClass) {
        Method[] remoteMethods = remoteClass.getDeclaredMethods();
        Vector<Method> temp = new Vector<Method>();
        for (Method remoteMethod : remoteMethods) {
            String methodName = remoteMethod.getName();
            if (!methodName.startsWith("get")) continue;
            temp.addElement(remoteMethod);
        }
        Method[] getters = new Method[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            getters[i] = (Method)temp.elementAt(i);
        }
        return getters;
    }

    private static Method getMethod(Class homeClass, String selectedMethodName) {
        Method[] homeMethods = homeClass.getDeclaredMethods();
        Method method = null;
        for (Method homeMethod : homeMethods) {
            if (!homeMethod.getName().equals(selectedMethodName)) continue;
            method = homeMethod;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Method not found!");
        }
        return method;
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

