/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class EJBHomeMethodAccessSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public EJBHomeMethodAccessSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    private Method[] getValidFindMethods(Method[] homeMethods) {
        Vector<Method> temp = new Vector<Method>();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!homeMethods[i].getName().startsWith("find") || homeMethods[i].getName().equals("findByPrimaryKey")) continue;
            temp.addElement(homeMethods[i]);
        }
        Method[] methods = new Method[temp.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)temp.elementAt(i);
        }
        return methods;
    }

    public void run() {
        if (this.authenticate(32418)) {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                String homeName = this.messageThread.homeName;
                Class<?> homeClass = Class.forName(homeName);
                Method[] homeMethods = this.getValidFindMethods(homeClass.getDeclaredMethods());
                dout.writeInt(0);
                dout.writeInt(homeMethods.length);
                for (Method homeMethod : homeMethods) {
                    IOUtil.writeString(dout, homeMethod.getName());
                    Class<?>[] paramTypes = homeMethod.getParameterTypes();
                    dout.writeInt(paramTypes.length);
                    for (Class<?> paramType : paramTypes) {
                        IOUtil.writeString(dout, paramType.getName());
                    }
                    Class<?> returnType = homeMethod.getReturnType();
                    IOUtil.writeString(dout, returnType.getName());
                }
                dout.close();
                this.client_socket.getOutputStream().write(bstream.toByteArray());
                this.client_socket.getOutputStream().flush();
                this.client_socket.getOutputStream().write(0);
                this.client_socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                this.cleanup(7, "Server failed to retrieve the ejb home methods :" + ex.toString() + "\n");
            }
        }
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

