/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.IOUtil;

public class EJBMetaDataSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public EJBMetaDataSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(32417)) {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                String remoteName = this.messageThread.remoteName;
                Class<?> remoteClass = Class.forName(remoteName);
                Method[] getters = EJBMetaDataSlave.retrieveGetters(remoteClass);
                dout.writeInt(0);
                int nCol = getters.length;
                dout.writeInt(nCol);
                for (Method getter : getters) {
                    String colName = getter.getName().substring(3);
                    String retTypeName = getter.getReturnType().getName();
                    int type = EJBUtil.mapFieldType(retTypeName);
                    IOUtil.writeString(dout, colName);
                    dout.writeInt(type);
                }
                dout.close();
                this.client_socket.getOutputStream().write(bstream.toByteArray());
                this.client_socket.getOutputStream().flush();
                this.client_socket.getOutputStream().write(0);
                this.client_socket.getOutputStream().flush();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                this.cleanup(7, "Server failed to access the remote interface :" + ex.toString() + "\n");
            }
        }
    }

    private static Method[] retrieveGetters(Class remoteClass) {
        Method[] remoteMethods = remoteClass.getDeclaredMethods();
        Vector<Method> temp = new Vector<Method>();
        for (Method remoteMethod : remoteMethods) {
            String methodName = remoteMethod.getName();
            if (!methodName.startsWith("get")) continue;
            temp.addElement(remoteMethod);
        }
        Method[] getters = new Method[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            getters[i] = (Method)temp.elementAt(i);
        }
        return getters;
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

