/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Date;
import quadbase.chart.ColData;
import quadbase.chart.ColDataResultSet;
import quadbase.chart.ExcelAccess;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class ExcelSlave
extends DataSlave {
    public ExcelSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    public byte[] readData() {
        try {
            switch (this.messageThread.jobRequest) {
                case 12002: {
                    ColData[] colData = ExcelAccess.getColData(this.messageThread.excelInfo, this.messageThread.transposeData, this.messageThread.transposeCol, this.messageThread.tsInfo, this.messageThread.startIndex, this.messageThread.displayRow);
                    ColDataResultSet rs = new ColDataResultSet(colData);
                    byte[] outBuf = this.writeToBuffer(rs);
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return outBuf;
                }
                case 12003: {
                    String[] sheetNames = ExcelAccess.getSheetNames(this.messageThread.excelInfo.getFilename());
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(sheetNames.length * 20);
                    DataOutputStream dos = new DataOutputStream(bos);
                    IOUtil.writeStrings(dos, sheetNames);
                    dos.flush();
                    dos.close();
                    return bos.toByteArray();
                }
            }
            throw new UnsupportedOperationException("Unknow Excel slave type: " + this.messageThread.jobRequest);
        }
        catch (Exception ex) {
            this.cleanup(1, ex.toString(), true);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nExcel file = " + this.messageThread.excelInfo.getFilename() + " -- ";
    }
}

