/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.reportdesigner.util.internal.BarcodeUtil;

public class ExportBarcodeSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public ExportBarcodeSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(28929)) {
            try {
                String filename = this.messageThread.barcodeFileName;
                String codeText = this.messageThread.codeText;
                int barType = this.messageThread.barType;
                int height = this.messageThread.barHeight;
                int width = this.messageThread.barWidth;
                Font font = this.messageThread.barFont;
                Color bgColor = this.messageThread.barBgColor;
                Color fColor = this.messageThread.barFColor;
                BarcodeUtil.getBarCodeImage(codeText, barType, width, height, this.server.getPath(filename), font, bgColor, fColor);
                this.sendReply();
            }
            catch (Exception ex) {
                this.cleanup(3, "Server failed to export the bar code :" + ex.toString() + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        CloseUtils.close(this.client_socket);
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

