/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ReleaseFileSlave;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.QbUtil;

public class ExportSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    FileOutputStream fstream = null;
    String outputfile;

    public ExportSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    public void run() {
        block18: {
            byte[] indata;
            this.outputfile = this.messageThread.outfile;
            try {
                this.server.writeLog(this.getHeader() + "start...\n");
                DataInputStream instream = new DataInputStream(this.client_socket.getInputStream());
                indata = new byte[this.messageThread.packageLen];
                instream.readFully(indata, 0, this.messageThread.packageLen);
            }
            catch (IOException ex) {
                this.cleanup(3, "Fail to read data " + ex.toString() + "\n");
                return;
            }
            catch (Exception ex) {
                this.cleanup(-2, ex.toString() + "\n");
                return;
            }
            catch (OutOfMemoryError err) {
                this.cleanup(2, err.toString() + "\n");
                return;
            }
            catch (Error err) {
                this.cleanup(-1, err.toString() + "\n");
                return;
            }
            this.server.userCounter(true);
            try {
                String mess = this.server.userCheck(3, null, null, this.messageThread.remoteAddr, 1076);
                if (!mess.equals("OK")) {
                    this.cleanup(5, mess);
                    return;
                }
            }
            catch (Exception ex) {
                this.cleanup(5, ex.toString());
                return;
            }
            this.outputfile = this.messageThread.absolutePath ? this.messageThread.outfile : this.server.getPath(this.messageThread.outfile);
            try {
                String errmsg = this.server.checkReadPermission(this.outputfile, this.messageThread.remoteAddr);
                if (errmsg != null) {
                    throw new Exception(errmsg);
                }
                if (OrgUtil.isReportData(this.outputfile)) {
                    OrgUtil.setReportData(this.outputfile, indata);
                    break block18;
                }
                if (OrgUtil.isChartData(this.outputfile)) {
                    OrgUtil.setChartData(this.outputfile, indata);
                    break block18;
                }
                if (OrgUtil.isDashboardData(this.outputfile)) {
                    OrgUtil.setDashboardData(this.outputfile, indata);
                    break block18;
                }
                try {
                    QbUtil.checkExtensionsBlacklist(this.outputfile);
                    this.fstream = new FileOutputStream(this.server.getPath(this.outputfile));
                    this.fstream.write(indata, 0, this.messageThread.packageLen);
                    this.fstream.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new ReleaseFileSlave(this.outputfile, this.server, this.client_socket).run();
                    this.cleanup(3, "Failed to write to file " + this.outputfile + ".\n" + ex.toString() + "\n");
                    return;
                }
                catch (Error err) {
                    err.printStackTrace();
                    new ReleaseFileSlave(this.outputfile, this.server, this.client_socket).run();
                    this.cleanup(3, "Failed to write to file " + this.outputfile + ".\n" + err.toString() + "\n");
                    return;
                }
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        if (this.messageThread.createHtml) {
            this.createHtmlFile(this.outputfile, this.messageThread.outfile, this.messageThread.useSwing, this.messageThread.usePageViewer, this.messageThread.useXML);
        }
        this.cleanup(0, "Finish.\n");
    }

    private void createHtmlFile(String outputFileName, String originalName, boolean useSwing, boolean usePageViewer, boolean useXML) {
        String fileNameParam;
        String jarFile;
        String codeClass;
        PrintWriter pWriter;
        String truncatedName = outputFileName.substring(0, outputFileName.length() - 4);
        int ind1 = (truncatedName = truncatedName.replace('\\', '/')).lastIndexOf(47);
        String basename = ind1 >= 0 ? truncatedName.substring(ind1 + 1) + ".html" : truncatedName + ".html";
        String htmlFileName = this.server.getPath(this.server.getHTMLDirectory() + basename);
        try {
            FileOutputStream fout = new FileOutputStream(this.server.getPath(htmlFileName));
            pWriter = new PrintWriter(fout);
        }
        catch (Exception e) {
            Server.println(this.server, "quadbase.reportdesigner.server.ExportSlave: ERROR");
            e.printStackTrace();
            return;
        }
        if (useXML) {
            originalName = originalName.substring(0, originalName.length() - 4) + ".xml";
        }
        pWriter.println("<html>");
        pWriter.println("<body>");
        if (!useSwing) {
            if (usePageViewer) {
                codeClass = "quadbase.reportdesigner.PageViewer.Viewer.class";
                jarFile = "PageViewer";
                fileNameParam = "FileName";
            } else {
                codeClass = "quadbase.reportdesigner.ReportViewer.Viewer.class";
                jarFile = "ReportViewerWithChart";
                fileNameParam = "filename";
            }
        } else if (usePageViewer) {
            codeClass = "quadbase.reportdesigner.PageViewer.swing.Viewer.class";
            jarFile = "SwingPageViewer";
            fileNameParam = "FileName";
        } else {
            codeClass = "quadbase.reportdesigner.ReportViewer.swing.Viewer.class";
            jarFile = "SwingReportViewerWithChart";
            fileNameParam = "filename";
        }
        pWriter.println("<applet code=\"" + codeClass + "\" width=100% height=100%");
        pWriter.println("archive=\"../lib/" + jarFile + ".jar,../lib/qblicense.jar,../lib/ExportLib.jar\">");
        pWriter.println("<PARAM name=\"" + fileNameParam + "\" value=\"" + originalName + "\">");
        if (ServerMessage.isServlet()) {
            pWriter.println("<PARAM name=\"comm_protocol\" value=\"servlet\">");
            pWriter.println("<PARAM name=\"comm_url\" value=\"" + ServerMessage.getConnectServlet() + "\">");
            pWriter.println("<PARAM name=\"servlet_context\" value=\"" + ServerMessage.getServletContext() + "\">");
        }
        if (this.messageThread.deleteFile != null) {
            pWriter.println("<PARAM name=\"SecurityLevel\" value=\"" + this.messageThread.deleteFile + "\">");
        }
        pWriter.println("</applet>");
        pWriter.println("</body>");
        pWriter.println("</html>");
        pWriter.flush();
        pWriter.close();
    }

    void cleanup(int code, String err) {
        this.acknowledge(code, err);
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nOutput : " + this.outputfile + " -- ";
    }
}

