/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import quadbase.common.client.ServerMessage;
import quadbase.common.formula.Formula;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.param.RootQueryParam;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.server.QbObjectPool;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbAuthenticator;
import quadbase.ext.ListenerManager;
import quadbase.ext.SchedulerListener;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.scheduler.PackageObject;
import quadbase.scheduler.ScheduleObject;

public class ExportThread
extends Thread {
    private static QbObjectPool pool = new QbObjectPool();
    private static boolean sharedDrive = true;
    private ScheduleObject obj;
    private boolean debug = false;
    private Server server;
    private Hashtable<String, MailInfo> emailCenter = null;
    private String currentExportLocation = null;

    public ExportThread(Server server, ScheduleObject obj) {
        this.obj = obj;
        this.server = server;
    }

    private static String toExportExt(int type) {
        switch (type) {
            case 2: {
                return ".pdf";
            }
            case 3: {
                return ".csv";
            }
            case 9: {
                return ".xls";
            }
            case 17: {
                return ".xlsx";
            }
            case 6: 
            case 7: 
            case 8: {
                return ".xml";
            }
            case 5: {
                return ".txt";
            }
            case 13: {
                return ".rtf";
            }
            case 4: {
                return ".html";
            }
            case 10: {
                return ".pak";
            }
            case 1: {
                return ".rpt";
            }
        }
        return "";
    }

    static String flatten(String[] s) {
        if (s == null || s.length == 0) {
            return null;
        }
        String result = s[0];
        for (int i = 1; i < s.length; ++i) {
            result = result + "," + s[i];
        }
        return result;
    }

    static String flatten(Vector s) {
        if (s == null || s.size() == 0) {
            return null;
        }
        String result = (String)s.elementAt(0);
        for (int i = 1; i < s.size(); ++i) {
            result = result + "," + (String)s.elementAt(i);
        }
        return result;
    }

    public static String convertToUnicode2(String str) {
        str = ExportThread.replace(str, "#", "%" + Integer.toHexString(35));
        str = ExportThread.replace(str, "\t", "     ");
        str = ExportThread.replace(str, " ", "%" + Integer.toHexString(32));
        str = ExportThread.replace(str, "\\", "%" + Integer.toHexString(92));
        str = ExportThread.replace(str, "\n", "%" + Integer.toHexString(10));
        str = ExportThread.replace(str, "\"", "%" + Integer.toHexString(34));
        str = ExportThread.replace(str, "'", "%" + Integer.toHexString(39));
        str = ExportThread.replace(str, ";", "%" + Integer.toHexString(59));
        str = ExportThread.replace(str, ">", "%" + Integer.toHexString(62));
        str = ExportThread.replace(str, "<", "%" + Integer.toHexString(60));
        return str;
    }

    public static String replace(String str, String oldChars, String newChars) {
        int i = str.indexOf(oldChars);
        int oldCharLen = oldChars.length();
        int newCharLen = newChars.length();
        while (i >= 0) {
            String str1 = "";
            String str2 = "";
            if (i != 0) {
                str1 = str.substring(0, i);
            }
            if (i + oldCharLen < str.length()) {
                str2 = str.substring(i + oldCharLen);
            }
            if (i + newCharLen < (str = str1 + newChars + str2).length()) {
                i = str.indexOf(oldChars, i + newCharLen);
                continue;
            }
            i = -1;
        }
        return str;
    }

    @Override
    public void run() {
        String[] lastExportFilePath = null;
        String[] fileLocation = null;
        Throwable[] stackTrace = null;
        boolean ocurrError = false;
        this.emailCenter = new Hashtable();
        if (this.obj instanceof PackageObject) {
            PackageObject pakObj = (PackageObject)this.obj;
            lastExportFilePath = new String[pakObj.getReportCount()];
            fileLocation = new String[lastExportFilePath.length];
            stackTrace = new Throwable[lastExportFilePath.length];
            int k = 0;
            for (int i = 0; i < pakObj.getReportCount(); ++i) {
                ScheduleObject sObj = pakObj.getReportExportObject(i);
                fileLocation[k] = sObj.getFileLocation();
                try {
                    this.currentExportLocation = null;
                    this.getExportLocation(sObj);
                    sObj.setLastExportFile(this.currentExportLocation);
                    lastExportFilePath[k] = this.exportReport(sObj, lastExportFilePath[k]);
                    if (this.debug) {
                        System.out.println("REPORT INPUT FILE LOCATION - " + fileLocation[k]);
                    }
                    if (this.debug) {
                        System.out.println("REPORT EXPORT FILE LOCATION - " + lastExportFilePath[k]);
                    }
                }
                catch (Throwable e) {
                    ocurrError = true;
                    stackTrace[k] = e;
                }
                ++k;
            }
        } else if (this.obj.isReport()) {
            fileLocation = new String[]{this.obj.getFileLocation()};
            lastExportFilePath = new String[1];
            stackTrace = new Throwable[1];
            try {
                lastExportFilePath[0] = this.exportReport(this.obj, lastExportFilePath[0]);
            }
            catch (Throwable e) {
                ocurrError = true;
                stackTrace[0] = e;
            }
        } else if (!this.obj.isChart()) {
            if (this.debug) {
                this.server.printToLog("EXEC COMMAND : " + this.obj.getCommand());
            }
            try {
                this.server.writeScheduleLog("EXEC COMMAND : " + this.obj.getCommand());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Runtime.getRuntime().exec(this.obj.getCommand());
            }
            catch (Exception e) {
                ocurrError = true;
                stackTrace = new Throwable[]{e};
            }
        }
        if (this.emailCenter != null) {
            this.sendPackageEmail();
        }
        if (!ocurrError) {
            this.callBack(true, this.obj, null);
            if (this.debug) {
                System.out.println("CLEANING....");
            }
            System.gc();
            if (this.debug) {
                System.out.println("DONE!");
            }
        } else {
            this.callBack(false, this.obj, this.getFirstError(stackTrace));
            if (this.debug) {
                System.out.println(this.combineError(stackTrace));
            }
            this.server.writeScheduleLog("EXPORT FAILS - BEGIN");
            this.server.writeScheduleLog(this.obj.getName());
            this.server.writeScheduleLog(this.combineString(fileLocation));
            Timestamp cTime = new Timestamp(System.currentTimeMillis());
            DateFormat df = DateFormat.getDateTimeInstance();
            this.server.writeScheduleLog(df.format(cTime));
            cTime = new Timestamp(this.obj.getStartDate());
            this.server.writeScheduleLog("SCHEDULE START DATE: " + df.format(cTime));
            if (this.obj.getEndDate() != -1L) {
                cTime = new Timestamp(this.obj.getEndDate());
                this.server.writeScheduleLog("SCHEDULE END DATE: " + df.format(cTime));
            }
            this.server.writeScheduleLog("EXPORT LOC: " + this.combineString(lastExportFilePath));
            this.server.writeScheduleLog(this.combineError(stackTrace));
            this.server.writeScheduleLog("EXPORT FAILS - END");
        }
        this.notifyDone();
    }

    String combineString(String[] str) {
        if (str == null) {
            return "";
        }
        String val = "";
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == null) {
                str[i] = "";
            }
            val = val.equals("") ? str[i] : val + " || " + str[i];
        }
        return val;
    }

    String combineError(Throwable[] error) {
        if (error == null) {
            return "";
        }
        String val = "";
        for (Throwable element : error) {
            String str = "";
            if (element != null) {
                str = IOUtil.getStackTrace(element);
            }
            val = val.equals("") ? str : val + " || " + str;
        }
        return val;
    }

    Throwable getFirstError(Throwable[] eList) {
        for (Throwable element : eList) {
            if (element == null) continue;
            return element;
        }
        return null;
    }

    String exportReport(ScheduleObject obj, String lastExportFilePath) throws Throwable {
        Exception errorEx = null;
        try {
            this.server.printToLog("[Task : " + obj.getName() + "] EXPORT FILE : " + obj.getFileLocation());
            String secLevel = null;
            if (obj.getSecurityLevel() != null) {
                secLevel = obj.getSecurityLevel();
            }
            Vector<Object[]> paramList = obj.getParamList();
            QbReport.setEspressManagerUsed(false);
            Properties props = new Properties();
            props.put("enterprise server", "true");
            props.put("optimize memory", obj.isMemoryOptimized() + "");
            props.put("multi-page export", QbReport.isExportToMultiPages() + "");
            props.put("prompt parameter", "false");
            if (secLevel != null && !secLevel.equals("")) {
                props.put("security level", secLevel);
            }
            if (obj.getBurstReport() == ScheduleObject.GROUPBURSTING || obj.getBurstReport() == ScheduleObject.ALLBURSTING) {
                props.put("useBackupData", "false");
            }
            Object[] c = pool.getObject(obj.getReportLocation(), props, true, false);
            QbReport report = (QbReport)c[0];
            boolean newCreated = (Boolean)c[1];
            report.setMultiPageExp(obj.isExportToMultiPages());
            if (obj.isExportToSingleWPagination()) {
                report.setExportToSingleWPagination(true);
            }
            if (obj.isUseExternalStyleSheet()) {
                report.setExternalStyleSheetName(obj.getExternalStyleSheetName());
            }
            if (obj.getTextDelimiter() >= 0) {
                report.setExportDelimiter(obj.getTextDelimiter());
            }
            if (obj.getNewLineDelimiter() >= 0) {
                report.setExportNewlineDelimiter(obj.getNewLineDelimiter());
            }
            if (obj.getPortNumber() > -1) {
                report.setDynamicExport(report.isDynamicExport(), obj.getServerName(), obj.getPortNumber());
                report.setServletDirectory(obj.getServletDirectory());
            }
            OrderedParameterSet allPromptParams = report.getReportObj().getParametersInSequence();
            System.out.println("ALL PROMPT PARAMS SIZE = " + allPromptParams.size());
            if (allPromptParams.size() > 0) {
                if (paramList != null) {
                    String exportLoc = this.getExportLocation(obj);
                    for (int i = 0; i < paramList.size(); ++i) {
                        String[] paramAddr = null;
                        try {
                            Object[] row = paramList.elementAt(i);
                            if (obj.isSendEmail()) {
                                String paramSetName = null;
                                if (row.length > allPromptParams.size()) {
                                    paramSetName = (String)row[row.length - 1];
                                }
                                if (obj.getBurstEmail() != null) {
                                    paramAddr = (String[])obj.getBurstEmail().get(paramSetName);
                                    if (this.debug) {
                                        System.out.println("PARAM SET NAME = " + paramSetName);
                                        System.out.println("BURST EMAIL COUNT = " + obj.getBurstEmail().size());
                                        if (paramAddr == null) {
                                            System.out.println("PARAM ADDR IS NULL!");
                                        } else {
                                            for (int k = 0; k < paramAddr.length; ++k) {
                                                System.out.println("paramAddr[" + k + "] = " + paramAddr[k]);
                                            }
                                        }
                                    }
                                } else if (this.debug) {
                                    System.out.println("BURST EMAIL = null!");
                                }
                            }
                            for (int j = 0; j < allPromptParams.size(); ++j) {
                                Param param;
                                block60: {
                                    param = allPromptParams.get(j);
                                    if (this.debug) {
                                        System.out.println("PARAM1[" + i + "][" + j + "] = " + row[j].toString());
                                    }
                                    if (!param.isFormulaParam()) {
                                        if (param.multiValue()) {
                                            Vector rowVec = (Vector)row[j];
                                            Object[] tmp = new Object[rowVec.size()];
                                            for (int t = 0; t < tmp.length; ++t) {
                                                tmp[t] = rowVec.elementAt(t);
                                            }
                                            Vector<Object> multiVal = ReportUtil.getMultiValueObject(param.getSqlType(), tmp, null);
                                            param.setValues(multiVal);
                                        } else {
                                            try {
                                                if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && ((String)row[j]).toLowerCase().startsWith("current") && param instanceof RootQueryParam) {
                                                    Formula formula = new Formula(null, (String)row[j]);
                                                    ((RootQueryParam)param).setValueVariable(formula);
                                                    break block60;
                                                }
                                                if (param instanceof QueryParam && ((QueryParam)param).findParam().isAllOptionEnabled() && ((QueryParam)param).findParam().getAllOptionLabel() != null && ((QueryParam)param).findParam().getAllOptionLabel().equals(row[j])) {
                                                    param.setValue(row[j]);
                                                    break block60;
                                                }
                                                param.setValue(ReportUtil.getValueObject(param.getSqlType(), row[j]));
                                            }
                                            catch (Exception ex) {
                                                param.setValue(ReportUtil.getValueObject(param.getSqlType(), row[j]));
                                            }
                                        }
                                    } else {
                                        param.setValue(row[j]);
                                    }
                                }
                                param.getReport().setSubReportParamValues(param);
                                report.getReportObj().setSubReportParamValues(param);
                            }
                            if (obj.getBurstReport() == ScheduleObject.GROUPBURSTING || obj.getBurstReport() == ScheduleObject.ALLBURSTING) {
                                this.burstReport(report, obj);
                                return lastExportFilePath;
                            }
                            report.refresh();
                            if (this.setHTMLParameters(obj, report)) {
                                report.setChartExportHTMLParameters(this.getTruncatedFilePath(exportLoc + "_" + i), this.getURLMapping(obj.getURLMapping()), this.getTruncatedFileName(exportLoc + "_" + i));
                            }
                            report.setServletDirectory(obj.getServletDirectory());
                            lastExportFilePath = exportLoc + "_" + i;
                            if (report.getReportObj().getInitializeReportError() == null) {
                                this.export(report, obj.getReportType(), lastExportFilePath, obj);
                                if (this.setHTMLParameters(obj, report)) {
                                    report.cleanExportedFiles();
                                }
                                this.sendEmail(obj, exportLoc + "_" + i, null, paramAddr);
                            } else {
                                if (this.isSendFailEmail(obj)) {
                                    this.sendFailEmail(obj, paramAddr);
                                }
                                errorEx = new Exception(report.getReportObj().getInitializeReportError());
                            }
                        }
                        catch (Exception ex) {
                            if (this.isSendFailEmail(obj)) {
                                this.sendFailEmail(obj, paramAddr);
                            }
                            errorEx = ex;
                        }
                        if (obj.getBurstReport() != ScheduleObject.ALLBURSTING) continue;
                        this.burstReport(report, obj);
                        return lastExportFilePath;
                    }
                } else if (!this.isMapToColumn(allPromptParams)) {
                    this.server.printToLog("task finished, no more parameters for file [" + obj.getFileLocation() + "]");
                    this.notifyDone();
                    return lastExportFilePath;
                }
            } else {
                try {
                    if (obj.getBurstReport() == ScheduleObject.GROUPBURSTING || obj.getBurstReport() == ScheduleObject.ALLBURSTING) {
                        this.burstReport(report, obj);
                        return lastExportFilePath;
                    }
                    if (!newCreated) {
                        report.refreshWithOriginalData();
                    }
                    if (this.debug) {
                        System.out.println("EXPORTING REPORT");
                    }
                    String exportLoc = this.getExportLocation(obj);
                    if (this.setHTMLParameters(obj, report)) {
                        report.setChartExportHTMLParameters(this.getTruncatedFilePath(exportLoc), this.getURLMapping(obj.getURLMapping()), this.getTruncatedFileName(exportLoc));
                    }
                    lastExportFilePath = exportLoc;
                    if (this.debug) {
                        System.out.println("EXPORT FILE = " + exportLoc);
                    }
                    if (report.getReportObj().getInitializeReportError() == null) {
                        this.export(report, obj.getReportType(), exportLoc, obj);
                        if (this.setHTMLParameters(obj, report)) {
                            report.cleanExportedFiles();
                        }
                        this.sendEmail(obj, exportLoc, null, null);
                    }
                    System.out.println("IS SEND FAIL EMAIL - " + this.isSendFailEmail(obj));
                    if (this.isSendFailEmail(obj)) {
                        this.sendFailEmail(obj, null);
                    }
                    errorEx = new Exception(report.getReportObj().getInitializeReportError());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (this.isSendFailEmail(obj)) {
                        this.sendFailEmail(obj, null);
                    }
                    errorEx = ex;
                }
            }
            pool.close(report);
            this.server.printToLog("task finished for file [" + obj.getID() + "]");
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            if (this.isSendFailEmail(obj)) {
                if (obj.getBurstEmail() != null) {
                    this.sendFailEmail(obj, this.getAllAddresses(obj.getBurstEmail()));
                } else {
                    this.sendFailEmail(obj, null);
                }
            }
            throw ex2;
        }
        if (errorEx != null) {
            throw errorEx;
        }
        return lastExportFilePath;
    }

    private String getExportLocation(ScheduleObject obj) {
        if (this.currentExportLocation != null) {
            return this.currentExportLocation;
        }
        this.currentExportLocation = obj.isTimestampAttached() ? obj.getExportLocation() + "_" + this.getExportTime() : obj.getExportLocation();
        return this.currentExportLocation;
    }

    private String getExportLocation(ScheduleObject obj, Object groupValue) {
        String exportLocation = obj.getExportLocation() + "_" + groupValue.toString();
        if (obj.isTimestampAttached()) {
            exportLocation = exportLocation + this.getExportTime();
        }
        return exportLocation;
    }

    private String getExportTime() {
        String timeVar = DateFormat.getDateTimeInstance(3, 3).format(new Date());
        timeVar = timeVar.replace('/', '-');
        timeVar = timeVar.replace('\\', '-');
        timeVar = timeVar.replace(':', '.');
        return timeVar;
    }

    String[] getAllAddresses(Hashtable emailList) {
        Vector<String> addressTBL = new Vector<String>();
        Enumeration e = emailList.keys();
        while (e.hasMoreElements()) {
            String paramSetName = (String)e.nextElement();
            String[] addresses = (String[])emailList.get(paramSetName);
            if (addresses == null) continue;
            for (int i = 0; i < addresses.length; ++i) {
                if (addressTBL.contains(addresses[i].toLowerCase())) continue;
                addressTBL.add(addresses[i].toLowerCase());
            }
        }
        String[] vals = new String[addressTBL.size()];
        for (int i = 0; i < addressTBL.size(); ++i) {
            vals[i] = (String)addressTBL.elementAt(i);
        }
        return vals;
    }

    private void export(QbReport report, int reportType, String path, ScheduleObject obj) throws Throwable {
        try {
            block14: {
                if (sharedDrive) {
                    try {
                        report = this.doSchedulerListener(report, path, obj);
                        int index = path.indexOf(58);
                        if (index == -1) {
                            if (reportType == 2 && obj.isEncodePDF()) {
                                report.export(reportType, path, obj.getPDFUserPassword(), obj.getPDFOwnerPassword(), 3900);
                            } else {
                                report.export(reportType, path);
                            }
                            sharedDrive = false;
                            return;
                        }
                        String driver = path.substring(0, index);
                        String fileName = Report.getFullName("\\\\" + ServerMessage.serverHost + "\\" + driver + "_drive" + path.substring(index + 1), reportType);
                        FileOutputStream fout = new FileOutputStream(fileName);
                        if (reportType == 2 && obj.isEncodePDF()) {
                            report.export(reportType, (OutputStream)fout, obj.getPDFUserPassword(), obj.getPDFOwnerPassword(), 3900);
                            break block14;
                        }
                        report.export(reportType, (OutputStream)fout, path);
                    }
                    catch (IOException ex) {
                        if (reportType == 2 && obj.isEncodePDF()) {
                            report.export(reportType, path, obj.getPDFUserPassword(), obj.getPDFOwnerPassword(), 3900);
                        } else {
                            report.export(reportType, path);
                        }
                        sharedDrive = false;
                    }
                } else if (reportType == 2 && obj.isEncodePDF()) {
                    report.export(reportType, path, obj.getPDFUserPassword(), obj.getPDFOwnerPassword(), 3900);
                } else {
                    Properties props = new Properties();
                    props.setProperty("limit excel cell split", obj.isLimitExcelCellSplit() + "");
                    report.export(reportType, path, props, null);
                }
            }
            this.callBack(true, obj, path + ExportThread.toExportExt(reportType), null);
        }
        catch (Throwable e) {
            this.callBack(false, obj, path + ExportThread.toExportExt(reportType), e);
            throw e;
        }
    }

    private void burstReport(QbReport qbreport, ScheduleObject obj) {
        Report report = qbreport.getReportObj();
        if (report.reportType == 0 || report.reportType == 4) {
            return;
        }
        try {
            Object groupValue = null;
            Vector<Object[]> vec = new Vector<Object[]>();
            IResultSet rs = this.getResult(report);
            if (rs != null) {
                IRSMetaData md = rs.getMetaData();
                int rowLength = md.getColumnCount();
                while (rs.next()) {
                    Object[] row = new Object[rowLength];
                    for (int i = 0; i < rowLength; ++i) {
                        row[i] = rs.getObject(i + 1);
                    }
                    if (groupValue == null || row[report.breakColInfo[0].getMapping()].equals(groupValue)) {
                        groupValue = row[report.breakColInfo[0].getMapping()];
                        vec.addElement(row);
                        continue;
                    }
                    this.exportGroup(qbreport, obj, vec, groupValue, md);
                    groupValue = row[report.breakColInfo[0].getMapping()];
                    vec = new Vector();
                    vec.add(row);
                }
                this.exportGroup(qbreport, obj, vec, groupValue, md);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void exportGroup(QbReport qbreport, ScheduleObject obj, Vector vec, Object groupValue, IRSMetaData md) {
        try {
            if (obj.getBurstReport() == ScheduleObject.ALLBURSTING) {
                int i;
                int rowLength = md.getColumnCount();
                Report report = qbreport.getReportObj();
                ColData[] colData = new ColData[rowLength + 1];
                for (i = 0; i < rowLength; ++i) {
                    colData[i] = new ColData(md.getColumnName(i + 1), md.getTableName(i + 1), md.getColumnType(i + 1), -1, CastUtil.getColumnDisplaySize(md, i + 1), rowLength + 1);
                }
                colData[rowLength] = new ColData("qbCount", 4, colData.length);
                for (i = 0; i < vec.size(); ++i) {
                    Object[] aRow = (Object[])vec.elementAt(i);
                    for (int j = 0; j < rowLength; ++j) {
                        colData[j].add(aRow[j]);
                    }
                    colData[rowLength].add(i);
                }
                qbreport.report = report.setNewData(colData, report.colDataSorted);
                if (this.debug) {
                    System.out.println("EXPORTING REPORT");
                }
                String exportLoc = this.getExportLocation(obj, groupValue);
                if (this.setHTMLParameters(obj, qbreport)) {
                    report.setChartExportHTMLParameters(this.getTruncatedFilePath(exportLoc), this.getURLMapping(obj.getURLMapping()), this.getTruncatedFileName(exportLoc));
                }
                this.export(qbreport, obj.getReportType(), exportLoc, obj);
                if (this.setHTMLParameters(obj, qbreport)) {
                    qbreport.cleanExportedFiles();
                }
                if (obj.getBurstReport() == ScheduleObject.ALLBURSTING) {
                    String addressStr = "";
                    ColInfo colInfo = report.colInfo[obj.getEmailColumnIndex()];
                    addressStr = colInfo.getMapping() > -1 ? (String)qbreport.report.colData[colInfo.getMapping()].getData(0) : (String)colInfo.getFormulaObj().getValue(qbreport.report.getReportTables().elementAt(0), 0, 0, 0, 0, 0, qbreport.report, null, null);
                    String[] toAddress = addressStr.split(",");
                    obj.setToAddresses(toAddress);
                    this.sendEmail(obj, exportLoc, groupValue, null);
                } else {
                    this.sendEmail(obj, exportLoc, groupValue, null);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private IResultSet getResult(Report report) {
        IResultSet rs = null;
        Vector<QueryInParamSet> params = null;
        if (!(report.reportType != 1 && report.reportType != 2 && report.reportType != 3 || report.isTransposed())) {
            String originalQuery = report.dbInfo.getQuery();
            report.dbInfo.setQuery(TransformQuery.transform(originalQuery, report.colInfo));
            report.colDataSorted = false;
            if (report.dbInfo instanceof QueryFileInfo) {
                params = new Vector();
                Vector<QueryInParamSet> parameters = QueryFileInfo.getParameter(report.getQueryFileInfo());
                QueryInParamSet inSet = parameters.elementAt(0);
                params.addElement(inSet);
            }
            try {
                rs = DBAccess.retrieveIResultSet(params, report.dbInfo, false, false, null, null, null, 0, -1, report.isForExportOnly());
                report.colDataSorted = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            report.dbInfo.setQuery(originalQuery);
            if (!report.colDataSorted) {
                try {
                    rs = DBAccess.retrieveIResultSet(params, report.dbInfo, false, false, null, null, null, 0, -1, report.isForExportOnly());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            if (report.dbInfo instanceof QueryFileInfo) {
                params = new Vector<QueryInParamSet>();
                params.addElement(((QueryFileInfo)report.dbInfo).getInSet());
            }
            try {
                rs = DBAccess.retrieveIResultSet(params, report.dbInfo, false, report.isTransposed(), report.getTransposeColumn(), null, null, 0, -1, report.isForExportOnly());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return rs;
    }

    private boolean isSendFailEmail(ScheduleObject obj) {
        return obj.isSendEmail() && (obj.getFailBodyText() != null && !obj.getFailBodyText().equals("") || obj.getFailSubject() != null && !obj.getFailSubject().equals(""));
    }

    private void sendFailEmail(ScheduleObject obj, String[] toAddresses) {
        if (!obj.isSendEmail()) {
            return;
        }
        if (this.emailCenter != null) {
            this.mergeFailEmail(obj, toAddresses);
            return;
        }
        String fromAddress = "";
        String subject = "";
        String bodyText = "";
        fromAddress = obj.getFromAddress();
        if (toAddresses == null) {
            toAddresses = obj.getToAddresses();
        }
        bodyText = obj.getFailBodyText();
        subject = obj.getFailSubject();
        if (toAddresses == null) {
            toAddresses = new String[]{};
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", Server.smtpHostName);
        if (Server.smtpSSL) {
            props.put("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.port", Integer.toString(Server.smtpPort));
        }
        if (Server.smtpSecure) {
            props.put("mail.smtp.auth", Boolean.toString(Server.smtpSecure));
            props.put("mail.smtp.ssl", Boolean.toString(Server.smtpSSL));
            props.put("mail.smtp.port", Integer.toString(Server.smtpPort));
        }
        Session session = null;
        session = Server.smtpSecure ? Session.getInstance((Properties)props, (Authenticator)new QbAuthenticator(Server.smtpUserName, Server.smtpPassword)) : Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session);
        try {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(bodyText);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            message.setSubject(subject);
            message.setFrom((Address)new InternetAddress(fromAddress));
            for (String toAddresse : toAddresses) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddresse));
            }
            Transport.send((Message)message);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            this.server.printToLog(IOUtil.getStackTrace(me));
        }
    }

    private void sendPackageEmail() {
        Enumeration<String> e = this.emailCenter.keys();
        while (e.hasMoreElements()) {
            String address = e.nextElement();
            MailInfo mailInfo = this.emailCenter.get(address.toLowerCase());
            this.sendEmail(address, mailInfo);
        }
    }

    private void mergeFailEmail(ScheduleObject obj, String[] toAddresses) {
        MailInfo info = new MailInfo();
        if (toAddresses == null) {
            toAddresses = obj.getToAddresses();
        }
        for (String toAddresse : toAddresses) {
            info = this.emailCenter.get(toAddresse.toLowerCase());
            if (info == null) {
                info = new MailInfo();
                info.fromAddress = obj.getFromAddress();
                info.emailType = obj.getEmailType();
            }
            info.bodyText = obj.getFailBodyText();
            info.subject = obj.getFailSubject();
            this.emailCenter.put(toAddresse.toLowerCase(), info);
        }
    }

    private void mergeEmail(ScheduleObject obj, String exportLoc, String[] toAddresses) {
        MailInfo info = new MailInfo();
        if (toAddresses == null) {
            toAddresses = obj.getToAddresses();
        }
        for (String toAddresse : toAddresses) {
            info = this.emailCenter.get(toAddresse.toLowerCase());
            if (info == null) {
                info = new MailInfo();
                info.fromAddress = obj.getFromAddress();
                info.emailType = obj.getEmailType();
                info.bodyText = obj.getBodyText();
                info.subject = obj.getSubject();
            }
            String urlMapping = "";
            urlMapping = obj.getURLMapping();
            if (info.emailType == 0) {
                try {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(this.getFullName(obj, exportLoc));
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(this.getTruncatedFileName(this.getFullName(obj, exportLoc)));
                    info.attachmentBodyParts.add(messageBodyPart);
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                    this.server.printToLog(IOUtil.getStackTrace(me));
                }
            } else if (info.emailType == 1) {
                String link = this.getURLMapping(urlMapping) + this.getTruncatedFileName(this.getFullName(obj, exportLoc));
                link = ExportThread.convertToUnicode2(link);
                info.links.add(link);
            }
            this.emailCenter.put(toAddresse.toLowerCase(), info);
        }
    }

    private String getFullName(ScheduleObject obj, String exportLoc) {
        return Report.getFullName(exportLoc, obj.getReportType());
    }

    private void sendEmail(ScheduleObject obj, String exportLoc, Object groupValue, String[] toAddresses) {
        if (obj.isExportToMultiPages() && obj.getReportType() == 4) {
            return;
        }
        if (!obj.isSendEmail() && groupValue == null) {
            return;
        }
        if (this.emailCenter != null) {
            this.mergeEmail(obj, exportLoc, toAddresses);
            return;
        }
        String fromAddress = "";
        String subject = "";
        String bodyText = "";
        int emailType = 0;
        String urlMapping = "";
        fromAddress = obj.getFromAddress();
        if (toAddresses == null) {
            toAddresses = obj.getToAddresses();
        }
        emailType = obj.getEmailType();
        bodyText = obj.getBodyText();
        urlMapping = obj.getURLMapping();
        subject = obj.getSubject();
        if (toAddresses == null) {
            toAddresses = new String[]{};
        }
        this.server.printToLog("sending email for [" + exportLoc + "], from address [" + fromAddress + "] to [" + ExportThread.flatten(toAddresses) + "]");
        Properties props = new Properties();
        props.put("mail.smtp.host", Server.smtpHostName);
        if (Server.smtpSSL) {
            props.put("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.port", Integer.toString(Server.smtpPort));
        }
        if (Server.smtpSecure) {
            props.put("mail.smtp.auth", Boolean.toString(Server.smtpSecure));
            props.put("mail.smtp.port", Integer.toString(Server.smtpPort));
        }
        Session session = null;
        session = Server.smtpSecure ? Session.getInstance((Properties)props, (Authenticator)new QbAuthenticator(Server.smtpUserName, Server.smtpPassword)) : Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session);
        try {
            String content;
            if (emailType == 0) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(bodyText);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)mimeBodyPart);
                MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                FileDataSource source = new FileDataSource(this.getFullName(obj, exportLoc));
                mimeBodyPart2.setDataHandler(new DataHandler((DataSource)source));
                mimeBodyPart2.setFileName(this.getTruncatedFileName(this.getFullName(obj, exportLoc)));
                multipart.addBodyPart((BodyPart)mimeBodyPart2);
                message.setContent((Multipart)multipart);
            } else if (emailType == 1) {
                String string2 = this.getURLMapping(urlMapping) + this.getTruncatedFileName(this.getFullName(obj, exportLoc));
                string2 = ExportThread.convertToUnicode2(string2);
                content = "<HTML><HEAD><TITLE></TITLE></HEAD><BODY>";
                content = content + bodyText;
                content = content + "<p><a href=\"" + string2 + "\">" + string2 + "</a></BODY></HTML>";
                message.setContent((Object)content, "text/html");
            } else if (emailType == 2) {
                if (!obj.isChart()) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(this.getFullName(obj, exportLoc));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        int nextByte = fileInputStream.read();
                        while (nextByte != -1) {
                            out.write(nextByte);
                            nextByte = fileInputStream.read();
                        }
                        out.flush();
                        if (obj.getReportType() == 4) {
                            message.setContent((Object)out.toString(), "text/html");
                        } else {
                            System.out.println("Only DHTML can be send as HTML!");
                        }
                        out.close();
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    String string = this.getURLMapping(urlMapping) + this.getTruncatedFileName(this.getFullName(obj, exportLoc));
                    content = "<HTML><HEAD><TITLE></TITLE></HEAD><BODY>";
                    content = content + "<P><IMG SRC=\"" + string + "\"></BODY></HTML>";
                    message.setContent((Object)content, "text/html");
                }
            }
            message.setSubject(subject);
            message.setFrom((Address)new InternetAddress(fromAddress));
            for (String toAddresse : toAddresses) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddresse));
            }
            Transport.send((Message)message);
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
            this.server.printToLog(IOUtil.getStackTrace(messagingException));
        }
        this.server.printToLog("email sent for [" + exportLoc + "]");
    }

    private void sendEmail(String toAddress, MailInfo mailInfo) {
        this.server.printToLog("sending email for [" + ExportThread.flatten(mailInfo.exportLocs) + "], from address [" + mailInfo.fromAddress + "] to [" + toAddress + "]");
        Properties props = new Properties();
        props.put("mail.smtp.host", Server.smtpHostName);
        if (Server.smtpSSL) {
            props.put("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.port", Integer.toString(Server.smtpPort));
        }
        if (Server.smtpSecure) {
            props.put("mail.smtp.auth", Boolean.toString(Server.smtpSecure));
            props.put("mail.smtp.port", Integer.toString(Server.smtpPort));
        }
        Session session = null;
        session = Server.smtpSecure ? Session.getInstance((Properties)props, (Authenticator)new QbAuthenticator(Server.smtpUserName, Server.smtpPassword)) : Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session);
        try {
            if (mailInfo.emailType == 0) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(mailInfo.bodyText);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                if (this.debug) {
                    System.out.println("ATTACHMENT SIZE = " + mailInfo.attachmentBodyParts.size());
                }
                for (int i = 0; i < mailInfo.attachmentBodyParts.size(); ++i) {
                    multipart.addBodyPart((BodyPart)((MimeBodyPart)mailInfo.attachmentBodyParts.elementAt(i)));
                }
                message.setContent((Multipart)multipart);
            } else if (mailInfo.emailType == 1) {
                String content = "<HTML><HEAD><TITLE></TITLE></HEAD><BODY>";
                content = content + mailInfo.bodyText;
                if (this.debug) {
                    System.out.println("LINKS SIZE = " + mailInfo.links.size());
                }
                for (int i = 0; i < mailInfo.links.size(); ++i) {
                    String link = (String)mailInfo.links.elementAt(i);
                    content = content + "<p><a href=\"" + link + "\">" + link + "</a><BR>\n";
                }
                content = content + "</BODY></HTML>";
                if (this.debug) {
                    System.out.println("CONTENT = " + content);
                }
                message.setContent((Object)content, "text/html");
            }
            message.setSubject(mailInfo.subject);
            message.setFrom((Address)new InternetAddress(mailInfo.fromAddress));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddress));
            Transport.send((Message)message);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            this.server.printToLog(IOUtil.getStackTrace(me));
        }
        this.server.printToLog("email sent for [" + ExportThread.flatten(mailInfo.exportLocs) + "]");
    }

    void notifyDone() {
        this.server.scheduleFinished(this);
    }

    private String getTruncatedFilePath(String fullname) {
        if (fullname == null) {
            return null;
        }
        int index = (fullname = fullname.replace('\\', '/')).lastIndexOf(47);
        if (index != -1 && index < fullname.length() - 1) {
            return fullname.substring(0, index);
        }
        return fullname;
    }

    private String getTruncatedFileName(String fullname) {
        if (fullname == null) {
            return null;
        }
        int index = (fullname = fullname.replace('\\', '/')).lastIndexOf(47);
        if (index != -1 && index < fullname.length() - 1) {
            return fullname.substring(index + 1);
        }
        return fullname;
    }

    private String getURLMapping(String url) {
        if (url == null || url.trim().equals("")) {
            return null;
        }
        if (!url.endsWith("/")) {
            return url + "/";
        }
        return url;
    }

    private void callBack(boolean success, ScheduleObject obj, Throwable e) {
        this.callBack(success, obj, null, e);
    }

    private void callBack(boolean success, ScheduleObject obj, String exportPath, Throwable e) {
        if (this.server.getSchedulerCallBackClass() == null) {
            return;
        }
        String methodName = "exportSucceeded";
        if (!success) {
            methodName = "exportFailed";
        }
        try {
            Class<?> objClass = Class.forName(this.server.getSchedulerCallBackClass());
            Constructor<?> objCons = objClass.getConstructor(new Class[0]);
            Object callBackClass = objCons.newInstance(new Object[0]);
            Class<?> schObj = Class.forName("quadbase.scheduler.ScheduleObject");
            Class<?> stringObj = Class.forName("java.lang.String");
            Class<?> throwableObj = Class.forName("java.lang.Throwable");
            Method objMethod = null;
            if (success) {
                objMethod = objClass.getMethod(methodName, schObj, stringObj);
                objMethod.invoke(callBackClass, obj, exportPath);
            } else {
                objMethod = objClass.getMethod(methodName, schObj, stringObj, throwableObj);
                objMethod.invoke(callBackClass, obj, exportPath, e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private QbReport doSchedulerListener(QbReport report, String exportPath, ScheduleObject obj) {
        ListenerManager lm = this.server.getListenerManager();
        if (lm == null) {
            return report;
        }
        SchedulerListener sl = lm.getSchedulerListener();
        if (sl == null) {
            return report;
        }
        return sl.modifyBeforeExport(report, obj, exportPath);
    }

    private boolean setHTMLParameters(ScheduleObject obj, QbReport report) {
        return (obj.getEmailType() == 0 || obj.getEmailType() == 2) && !report.isDynamicExport();
    }

    private boolean isMapToColumn(Parameters params) {
        for (int i = 0; i < params.size(); ++i) {
            Param param = params.get(i);
            if (param.isMapToColumn() || param.getDefaultValue() != null) continue;
            return false;
        }
        return true;
    }

    class MailInfo {
        String fromAddress = "";
        String subject = "";
        String bodyText = "";
        int emailType = 0;
        Vector attachmentBodyParts = new Vector();
        Vector links = new Vector();
        Vector exportLocs = new Vector();
    }
}

