/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Dimension;
import java.awt.Frame;
import java.io.DataInputStream;
import quadbase.chart.Chart;
import quadbase.chart.GraphicsTable;
import quadbase.chart.ValueTable;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.common.server.Server;
import quadbase.util.internal.IOUtil;

public class ExtractMethodList {
    Chart chart;
    DataInputStream in;
    Server server;

    public ExtractMethodList(Server server, Chart chart, DataInputStream in) {
        this.server = server;
        this.chart = chart;
        this.in = in;
    }

    Chart extract() throws Exception {
        short command = this.in.readShort();
        while (command != 0) {
            switch (command) {
                case 1: {
                    this.extractChart3DProperties();
                    break;
                }
                case 2: {
                    this.extractChartProperties();
                    break;
                }
                case 3: {
                    this.extractQbChart();
                    break;
                }
                case 4: {
                    this.extractTable();
                    break;
                }
                default: {
                    Server.println("Extract:  unknown class: " + command);
                }
            }
            command = this.in.readShort();
        }
        return this.chart;
    }

    void extractChart3DProperties() throws Exception {
        short command = this.in.readShort();
        switch (command) {
            case 1: {
                this.navigate(this.in.readBoolean(), this.in.readShort(), this.in.readShort());
                break;
            }
            case 2: {
                this.chart.set3DDrawType(this.in.readShort());
                break;
            }
            case 3: {
                this.chart.setDrawSeriesOnCategoryAxis(this.in.readBoolean());
                break;
            }
            default: {
                Server.println("ExtractChart3DProperties:  unknown method: " + command);
            }
        }
    }

    void extractChartProperties() throws Exception {
        short command = this.in.readShort();
        switch (command) {
            case 1: {
                this.chart = this.changeChartType(this.in.readShort(), this.chart.is2DimChart());
                break;
            }
            case 2: {
                this.chart = this.changeChartType(this.chart.getChartType(), this.in.readBoolean());
                break;
            }
            case 3: {
                this.chart.setComboType(this.in.readShort());
                break;
            }
            case 4: {
                double tmpA = this.in.readFloat();
                double tmpB = this.in.readFloat();
                double tmpC = this.in.readFloat();
                boolean isVert = this.chart.chartType != 1 && this.chart.chartType != 15 && this.chart.chartType != 18 && this.chart.chartType != 5;
                this.chart.setAxisScale(isVert ? 1 : 0, tmpA, tmpB, tmpC);
                this.chart.setAxisAutoOrigin(isVert ? 1 : 0, true);
                break;
            }
            default: {
                Server.println("ExtractChartProperties:  unknown method: " + command);
            }
        }
    }

    void extractTable() throws Exception {
        short command = this.in.readShort();
        switch (command) {
            case 1: {
                short tab = this.in.readShort();
                if (this.chart.gt == null || !this.chart.showLegend2() || tab < 0) break;
                if (tab == 0) {
                    this.chart.gt.setData(this.chart, this.chart.mData);
                } else {
                    this.chart.gt.setData(this.chart, this.chart.mData2);
                }
                this.chart.gt.select_axis = tab;
                this.chart.gt.cBorder = null;
                this.chart.gt.firstShown = true;
                break;
            }
            case 2: {
                short tab = this.in.readShort();
                if (this.chart.gt == null || tab < 0) break;
                this.chart.gt.select_tab = tab;
                break;
            }
            default: {
                Server.println("ExtractTable:  unknown method: " + command);
            }
        }
    }

    void extractQbChart() throws Exception {
        short command = this.in.readShort();
        Frame frame = new Frame();
        frame.addNotify();
        String fileName = "";
        switch (command) {
            case 1: {
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                fileName = IOUtil.readString(this.in, true);
                this.chart.get_directExport(this.server.getPath(fileName), this.server.getPath(fileName), this.in.readShort(), size.width, size.height, frame, false, 99);
                break;
            }
            case 2: {
                this.chart.setBackgroundTransparent(this.in.readBoolean());
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                this.chart.get_directExport(this.server.getPath(IOUtil.readString(this.in, true)), this.server.getPath(IOUtil.readString(this.in, true)), 1, size.width, size.height, frame, this.in.readBoolean(), 99);
                break;
            }
            case 3: {
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                this.chart.get_directExport(this.server.getPath(IOUtil.readString(this.in, true)), this.server.getPath(IOUtil.readString(this.in, true)), 7, size.width, size.height, frame, this.in.readBoolean(), this.in.readShort());
                break;
            }
            case 4: {
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                this.chart.get_directExport(this.server.getPath(IOUtil.readString(this.in, true)), this.server.getPath(IOUtil.readString(this.in, true)), 10, size.width, size.height, frame, this.in.readBoolean(), this.in.readShort());
                break;
            }
            case 5: {
                this.chart.setDrawBorderForWMF(this.in.readBoolean());
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                fileName = this.server.getPath(IOUtil.readString(this.in, true));
                this.chart.get_directExport(fileName, fileName, 8, size.width, size.height, frame, false, 99);
                break;
            }
            case 6: {
                this.chart.exportDataFile(this.server.getPath(IOUtil.readString(this.in, true)), (int)this.in.readShort(), (int)this.in.readShort());
                break;
            }
            case 7: {
                this.chart.loadTemplate(this.server.getPath(IOUtil.readString(this.in, true)));
                break;
            }
            case 8: {
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                this.chart.get_directExport(this.server.getPath(IOUtil.readString(this.in, true)), this.server.getPath(IOUtil.readString(this.in, true)), this.in.readShort(), size.width, size.height, frame, this.in.readBoolean(), 99);
                break;
            }
            case 9: {
                this.chart.setBufferedImageUsed(this.in.readBoolean());
                break;
            }
            case 10: {
                this.chart.setBufferedImageType(this.in.readShort());
                break;
            }
            case 11: {
                Dimension size = this.getExportSize(this.in.readShort(), this.in.readShort());
                fileName = this.server.getPath(IOUtil.readString(this.in, true));
                this.chart.get_directExport(fileName, fileName, 13, size.width, size.height, frame, false, 99);
                break;
            }
            default: {
                Server.println("ExtractQbChart:  unknown method: " + command);
            }
        }
        frame.removeNotify();
    }

    Chart changeChartType(int chartType, boolean is2DimChart) throws Exception {
        Chart newChart = this.chart;
        Frame f = new Frame();
        f.addNotify();
        ValueTable valueTable = this.chart.valueTable;
        GraphicsTable.recoverTableSize(this.chart);
        newChart.gt.tableWidth = this.chart.gt.tableWidth;
        newChart.gt.tableHeight = this.chart.gt.tableHeight;
        newChart = Chart.createChart(f, chartType, is2DimChart, this.chart, null, this.chart.usedColumns);
        if (valueTable != null) {
            newChart.valueTable = new ValueTable(newChart, valueTable);
        }
        if (!newChart.is2DimChart()) {
            newChart.validatePosition();
        }
        f.removeNotify();
        return newChart;
    }

    void navigate(boolean rotateMode, int step, int direction) {
        if (this.chart.is2DimChart()) {
            return;
        }
        Space space = (Space)this.chart.getSpace();
        if (space == null) {
            this.chart.validatePosition();
            space = (Space)this.chart.getSpace();
        }
        float scale = space.spaceScale;
        double increment = 0.0;
        int movement = 0;
        if (rotateMode) {
            increment = 0.002 + (double)step * 0.3121592653589793 / 1000.0;
        } else {
            movement = 5 + step * 995 / 1000;
        }
        double alpha = Math.atan2(-space.viewVec.k, -space.viewVec.i);
        double theta = Math.asin(-space.viewVec.j);
        switch (direction) {
            case 0: {
                if (rotateMode) {
                    if (!((theta -= increment) < -1.5707963267948966)) break;
                    theta = -1.5702963267948966;
                    break;
                }
                this.chart.translateSpace(0.0f, movement, 0.0f);
                break;
            }
            case 1: {
                if (rotateMode) {
                    if (!((theta += increment) > 1.5707963267948966)) break;
                    theta = 1.5702963267948966;
                    break;
                }
                this.chart.translateSpace(0.0f, -movement, 0.0f);
                break;
            }
            case 2: {
                if (rotateMode) {
                    alpha -= increment;
                    break;
                }
                this.chart.translateSpace(-movement, 0.0f, 0.0f);
                break;
            }
            case 3: {
                if (rotateMode) {
                    alpha += increment;
                    break;
                }
                this.chart.translateSpace(movement, 0.0f, 0.0f);
                break;
            }
        }
        double t = Math.cos(theta) * (double)scale;
        double t2 = Math.sin(theta) * (double)scale;
        this.chart.setlookfrom_x((float)(t * Math.cos(alpha) + (double)this.chart.getlookto_x()));
        this.chart.setlookfrom_y((float)(t2 + (double)this.chart.getlookto_y()));
        this.chart.setlookfrom_z((float)(t * Math.sin(alpha) + (double)this.chart.getlookto_z()));
        space.lookat(this.chart.getlookfrom_x(), this.chart.getlookfrom_y(), this.chart.getlookfrom_z(), this.chart.getlookto_x(), this.chart.getlookto_y(), this.chart.getlookto_z());
    }

    private Dimension getExportSize(int w, int h) {
        if (w <= 0) {
            w = this.chart.getSize().width;
        }
        if (h <= 0) {
            h = this.chart.getSize().height;
        }
        if (w <= 0) {
            w = 400;
        }
        if (h <= 0) {
            h = 500;
        }
        return new Dimension(w, h);
    }
}

