/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class FileInfoSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    FileOutputStream fstream = null;
    String file;
    String absolutePath = null;
    boolean isValidFile = false;
    boolean isDirectory = false;
    boolean isFileExisted = false;
    long lastModifiedDate = 0L;
    byte[] data = null;

    public FileInfoSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    public void run() {
        this.file = this.messageThread.infile;
        this.server.writeLog(this.getHeader() + "start...\n");
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), 1076);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return;
        }
        File tmp = new File(this.server.getPath(this.file));
        this.absolutePath = tmp.getAbsolutePath();
        this.isDirectory = tmp.isDirectory();
        this.isFileExisted = tmp.exists();
        this.lastModifiedDate = tmp.lastModified();
        if (this.messageThread.getData) {
            try {
                File pic = new File(this.absolutePath);
                long length = pic.length();
                this.data = new byte[(int)length];
                FileInputStream picIn = new FileInputStream(pic);
                picIn.read(this.data);
                picIn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            tmp.getCanonicalPath();
            this.isValidFile = true;
        }
        catch (IOException ex) {
            this.isValidFile = false;
        }
        this.cleanup(0, "Finish.\n");
    }

    void cleanup(int code, String err) {
        this.acknowledge(code, err);
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            if (code != 0) {
                IOUtil.writeString(dout2, s);
            } else {
                dout2.writeBoolean(this.isValidFile);
                IOUtil.writeString(dout2, this.absolutePath);
                dout2.writeBoolean(this.isDirectory);
                dout2.writeBoolean(this.isFileExisted);
                dout2.writeLong(this.lastModifiedDate);
                if (this.data != null) {
                    dout2.writeInt(this.data.length);
                    dout2.write(this.data);
                }
            }
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nOutput : " + this.file + " -- ";
    }
}

