/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportorganizer.data.OrganizerDataImpl;

public class FileLockSlave
extends Thread {
    public static final int GET_FILE_LOCK_INFO = 1;
    public static final int RELEASE_FILE_LOCK = 2;
    public static final int OVERRIDE_FILE_LOCK = 3;
    public static final int RELEASE_ALL_FILE_LOCK_FOR_USER = 4;
    public static final int RELEASE_FILE_OVERRIDE = 5;
    public static final int RELEASE_ALL_FILE_OVERRIDE_FOR_USER = 6;
    public static final int GET_OVERRIDE_LOCK_INFO = 7;
    private static final Logger LOGGER = Logger.getLogger(FileLockSlave.class.getName());
    private static final String ORG_USER_NAME = "OrgUserName";
    private static final String ORG_USER_TOKEN = "OrgUserToken";
    String requestFile;
    Server server;
    IConnection client_socket;
    String machine;
    int requestType;

    public FileLockSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.requestFile = messageThread.infile;
        this.server = server;
        this.client_socket = socket;
        this.machine = messageThread.remoteAddr;
        this.requestType = messageThread.fileLockOption;
    }

    @Override
    public void run() {
        this.requestFile = ServerMessage.getPath(this.requestFile).toUpperCase();
        String message = "";
        switch (this.requestType) {
            case 1: {
                message = this.getFileLockInfo();
                break;
            }
            case 2: {
                LOGGER.finest("Release file lock");
                message = this.releaseFileLock();
                break;
            }
            case 3: {
                LOGGER.finest("Override file lock");
                message = this.overrideFileLock();
                break;
            }
            case 4: {
                LOGGER.finest("Release all file lock for user");
                message = this.releaseAllFileLocksForUser();
                break;
            }
            case 6: {
                LOGGER.finest("Release all file ovrerride for user");
                message = this.releaseAllOverridesForUser();
                break;
            }
            case 7: {
                LOGGER.finest("Get override lock");
                message = this.getOverrideLockInfo();
            }
        }
        try {
            DataOutputStream dout = new DataOutputStream(this.client_socket.getOutputStream());
            IOUtil.writeString(dout, message);
            dout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.client_socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFileLockInfo() {
        String fromMachine = this.server.lockedFiles.get(this.requestFile);
        return fromMachine == null ? "" : fromMachine;
    }

    private String getOverrideLockInfo() {
        Vector overrideList = (Vector)this.server.overrideFiles.get(this.requestFile);
        if (overrideList == null) {
            return "";
        }
        for (int i = 0; i < overrideList.size(); ++i) {
            String machineName = (String)overrideList.elementAt(i);
            if (machineName.equals(this.machine)) {
                return this.machine;
            }
            Hashtable<String, String> attr = this.parseClientAddress(machineName);
            String orgUserToken = attr.get(ORG_USER_TOKEN);
            attr = this.parseClientAddress(this.machine);
            String currOrgUserToken = attr.get(ORG_USER_TOKEN);
            if (orgUserToken == null || !orgUserToken.equals(currOrgUserToken)) continue;
            return machineName;
        }
        return "";
    }

    private String releaseFileLock() {
        String absPath = new File(this.server.getPath(this.requestFile)).getAbsolutePath().toUpperCase();
        if (this.machine == null) {
            int code = 6;
            try {
                String removed = this.server.lockedFiles.get(absPath);
                if (removed != null && this.client_socket.getPeerAddress().equals(removed)) {
                    LOGGER.finest("FileLockSlave - absPath - " + absPath + " release file lock");
                    this.server.lockedFiles.remove(absPath);
                    code = 0;
                } else {
                    code = 6;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            return code + "";
        }
        String msg = "0";
        try {
            Enumeration<String> enum1 = this.server.lockedFiles.keys();
            while (enum1.hasMoreElements()) {
                String key = enum1.nextElement();
                if (!key.equals(absPath)) continue;
                String lockMachineValue = this.server.lockedFiles.get(key);
                String orgUserToken = "&OrgUserToken=";
                int loc = lockMachineValue.lastIndexOf(orgUserToken);
                String lockToken = "";
                if (loc > 0) {
                    lockToken = lockMachineValue.substring(loc + orgUserToken.length());
                }
                loc = this.machine.lastIndexOf(orgUserToken);
                String userToken = "";
                if (loc > 0) {
                    userToken = this.machine.substring(loc + orgUserToken.length());
                }
                if (this.machine.equals(this.server.lockedFiles.get(key))) {
                    LOGGER.finest("FileLockSlave - key - " + key + " release file lock");
                    this.server.lockedFiles.remove(key);
                    continue;
                }
                if (lockToken.equals("") || !lockToken.equals(userToken)) continue;
                LOGGER.finest("FileLockSlave - lockToken - " + lockToken + " release file lock");
                this.server.lockedFiles.remove(key);
            }
        }
        catch (Exception e) {
            msg = "6";
        }
        return msg;
    }

    private String overrideFileLock() {
        if (this.requestFile == null || this.machine == null) {
            return "Error: File or Machine is not specified";
        }
        String fromMachine = this.server.lockedFiles.get(this.requestFile);
        if (fromMachine == null) {
            this.server.lockedFiles.put(this.requestFile, this.machine);
            return "0";
        }
        Hashtable<String, String> fromAttr = this.parseClientAddress(fromMachine);
        String fromUserName = fromAttr.get(ORG_USER_NAME);
        String fromUserToken = fromAttr.get(ORG_USER_TOKEN);
        Hashtable<String, String> currAttr = this.parseClientAddress(this.machine);
        String currUserName = currAttr.get(ORG_USER_NAME);
        String currUserToken = currAttr.get(ORG_USER_TOKEN);
        if ((fromUserName.equals(currUserName) || OrganizerDataImpl.isAdmin((String)currUserName)) && !fromUserToken.equals(currUserToken)) {
            this.server.lockedFiles.put(this.requestFile, this.machine);
            Object obj = this.server.overrideFiles.get(this.requestFile);
            Vector machineList = new Vector();
            if (obj != null) {
                machineList = (Vector)obj;
            }
            boolean found = false;
            for (int i = 0; i < machineList.size(); ++i) {
                if (!fromMachine.equals(machineList.elementAt(i))) continue;
                found = true;
                break;
            }
            if (!found) {
                machineList.add(fromMachine);
            }
            this.server.overrideFiles.put(this.requestFile, machineList);
            this.server.overrideTimeTable.put(fromMachine, System.currentTimeMillis());
            return "0";
        }
        return "";
    }

    private String releaseAllFileLocksForUser() {
        Enumeration<String> keys = this.server.lockedFiles.keys();
        while (keys.hasMoreElements()) {
            String filePath = keys.nextElement();
            String lockMachine = this.server.lockedFiles.get(filePath);
            if (!lockMachine.equals(this.machine)) continue;
            this.server.lockedFiles.remove(filePath);
        }
        return "0";
    }

    private String releaseAllOverridesForUser() {
        Enumeration keys = this.server.overrideFiles.keys();
        while (keys.hasMoreElements()) {
            String filePath = (String)keys.nextElement();
            Vector machineList = (Vector)this.server.overrideFiles.get(filePath);
            for (int i = machineList.size() - 1; i >= 0; --i) {
                if (!this.machine.equals(machineList.elementAt(i))) continue;
                machineList.remove(i);
            }
            if (machineList.size() == 0) {
                this.server.overrideFiles.remove(filePath);
                continue;
            }
            this.server.overrideFiles.put(filePath, machineList);
        }
        return "0";
    }

    private Hashtable<String, String> parseClientAddress(String clientAddress) {
        Hashtable<String, String> kvPair = new Hashtable<String, String>();
        int loc = clientAddress.indexOf(63);
        if (loc < 0) {
            kvPair.put("IPAddress", clientAddress);
            return kvPair;
        }
        kvPair.put("IPAddress", clientAddress.substring(0, loc));
        String kvStr = clientAddress.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(kvStr, "&");
        while (st.hasMoreTokens()) {
            String pairStr = st.nextToken();
            loc = pairStr.indexOf(61);
            String key = pairStr.substring(0, loc);
            String val = pairStr.substring(loc + 1);
            kvPair.put(key, val);
        }
        return kvPair;
    }
}

