/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.IOException;
import java.io.InputStream;
import quadbase.chart.FilterInfo;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.server.StreamSlave;
import quadbase.common.util.internal.IOUtil;
import quadbase.queryproc.filter.EqFilter;
import quadbase.queryproc.filter.RunSimpleFilter;
import quadbase.util.IResultSet;
import quadbase.util.StreamResultSet;
import quadbase.util.internal.IQueryProcInfo;
import quadbase.util.internal.TransposeRS;

public class FilterDataFileSlave
extends StreamSlave {
    public FilterDataFileSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    IQueryProcInfo getPreprocessInfo() {
        return this.messageThread.tsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream in = null;
        try {
            if (this.authenticate(28816)) {
                IResultSet irs;
                if (IOUtil.isXMLFormat(this.messageThread.infile) || this.messageThread.sourceType == 4) {
                    in = this.getInputStream();
                    irs = this.createXMLResultSet();
                } else if (this.messageThread.sourceType == 6) {
                    irs = this.createClassResultSet();
                } else {
                    in = this.getInputStream();
                    irs = new StreamResultSet(in, this.messageThread.encoding);
                }
                if (this.messageThread.transposeData) {
                    irs = TransposeRS.doTranspose(irs, this.messageThread.transposeCol);
                }
                if (this.messageThread.filterData) {
                    RunSimpleFilter rsf = new RunSimpleFilter();
                    FilterInfo filterInfo = this.messageThread.filterInfo;
                    int[] compareOp = filterInfo.getCompareOp();
                    int[] colIndex = filterInfo.getColIndex();
                    Object[] value = filterInfo.getValue();
                    for (int i = 0; i < filterInfo.getSize(); ++i) {
                        if (compareOp[i] != 0) continue;
                        rsf.andCondition(new EqFilter(colIndex[i], value[i]));
                    }
                    irs = rsf.run(irs);
                }
                byte[] outdata = null;
                if (this.messageThread.preProcessData) {
                    IResultSet ors = this.preprocess(irs);
                    irs.close();
                    outdata = this.writeToBuffer(ors);
                    ors.close();
                } else {
                    outdata = this.writeToBuffer(irs);
                }
                if (in != null) {
                    in.close();
                }
                this.writeOutput(outdata);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(-2, ex.toString() + "\n");
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(-1, err.toString() + "\n");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

