/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import quadbase.chart.ColDataResultSet;
import quadbase.chart.FilterInfo;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.SQLSlave;
import quadbase.common.server.Server;
import quadbase.queryproc.IQueryProc;
import quadbase.queryproc.filter.EqFilter;
import quadbase.queryproc.filter.FilterResultSet;
import quadbase.queryproc.filter.RunSimpleFilter;
import quadbase.util.IResultSet;
import quadbase.util.internal.IQueryProcInfo;

public class FilterPPSQLSlave
extends SQLSlave {
    IResultSet irs;
    boolean filterData;

    public FilterPPSQLSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.filterData = messageThread.filterData;
    }

    @Override
    public void run() {
        try {
            if (this.authenticate(27587)) {
                this.irs = this.getResultSet();
                if (this.irs instanceof ColDataResultSet) {
                    if (this.filterData) {
                        this.connectionBuffer.setPriority(this.dbInfo, this.messageThread.inParamSet, 4);
                    } else {
                        this.connectionBuffer.setPriority(this.dbInfo, this.messageThread.inParamSet, 1);
                    }
                }
                if (this.filterData) {
                    RunSimpleFilter rsf = new RunSimpleFilter();
                    FilterInfo filterInfo = this.messageThread.filterInfo;
                    int[] compareOp = filterInfo.getCompareOp();
                    int[] colIndex = filterInfo.getColIndex();
                    Object[] value = filterInfo.getValue();
                    for (int i = 0; i < filterInfo.getSize(); ++i) {
                        if (compareOp[i] != 0) continue;
                        rsf.andCondition(new EqFilter(colIndex[i], value[i]));
                    }
                    this.irs = rsf.run(this.irs);
                }
                byte[] outdata = null;
                if (this.messageThread.preProcessData) {
                    IResultSet ors = this.preprocess(this.irs);
                    outdata = this.writeToBuffer(ors);
                    ors.close();
                } else {
                    outdata = this.writeToBuffer(this.irs);
                }
                this.irs.close();
                if (this.conn != null) {
                    this.closeConnection();
                }
                this.writeOutput(outdata);
            }
        }
        catch (Exception ex) {
            if (this.conn != null) {
                this.closeConnection();
                this.cleanup(1, "Failed to retrieve data.\n " + ex.getMessage() + "\n", true);
            } else if (this.dbInfo.getQuery() == null || this.dbInfo.getQuery().trim().equals("")) {
                this.cleanup(1, ex.getMessage() + "\n", true);
            } else {
                this.cleanup(1, "Failed to connect to database\n " + ex.getMessage() + "\n", true);
            }
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n", true);
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(-1, err.toString() + "\n", true);
        }
    }

    @Override
    IQueryProcInfo getPreprocessInfo() {
        return this.messageThread.tsInfo;
    }

    @Override
    IResultSet preprocess(IResultSet irs) throws Exception {
        try {
            IQueryProcInfo qInfo = this.getPreprocessInfo();
            boolean useObjectBuffer = !this.filterData || this.messageThread.preProcessData;
            IQueryProc q = queryProcFactory.createQueryProc(qInfo.getSelectionColType(), useObjectBuffer);
            q.setDrawNullColumn(this.messageThread.drawNullColumn, this.messageThread.nullHandleName);
            if (this.filterData) {
                ((FilterResultSet)irs).setIQueryProc(q);
            }
            q.setInputResultSet(irs);
            q.setInputInfo(qInfo);
            q.run();
            return q.getOutputRows();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

