/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.InputStream;
import java.util.Date;
import quadbase.chart.SOAPAccess;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;

public class GetSOAPXMLSlave
extends DataSlave {
    public GetSOAPXMLSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    public byte[] readData() {
        try {
            InputStream is = SOAPAccess.getXMLStreamFromLocal(this.messageThread.soapInfo);
            byte[] result = new byte[is.available()];
            is.read(result);
            return result;
        }
        catch (Exception ex) {
            this.cleanup(1, "Failed to retrieve data.\n" + ex.toString() + "\n", true);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
        }
        return null;
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nSOAP data source wsdlFile = " + this.messageThread.soapInfo.getWsdlUri() + " -- ";
    }
}

