/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import quadbase.chart.ExportChart;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.util.gif.GifEncoder87a;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.ImageEncoder;

public class ImgExportSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    String outputfile;

    public ImgExportSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block26: {
            int[] buffer;
            this.outputfile = this.messageThread.outfile;
            try {
                this.server.writeLog(this.getHeader() + "start...\n");
                DataInputStream instream = new DataInputStream(new BufferedInputStream(this.client_socket.getInputStream()));
                int size = this.messageThread.width * this.messageThread.height;
                buffer = new int[size];
                int i = 0;
                while (i < size) {
                    buffer[i++] = instream.readInt();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.cleanup(-2, ex.toString() + "\n");
                return;
            }
            catch (OutOfMemoryError err) {
                err.printStackTrace();
                this.cleanup(2, err.toString() + "\n");
                return;
            }
            catch (Error err) {
                err.printStackTrace();
                this.cleanup(-1, err.toString() + "\n");
                return;
            }
            if (!this.server.userCounter(true)) {
                this.acknowledge(4, "");
                try {
                    this.client_socket.close();
                }
                catch (IOException err) {
                    // empty catch block
                }
                return;
            }
            try {
                String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), 29203);
                if (!mess.equals("OK")) {
                    this.cleanup(5, mess);
                    return;
                }
            }
            catch (Exception ex) {
                this.cleanup(5, ex.toString());
                return;
            }
            this.outputfile = this.messageThread.outfile.replace('|', ':');
            this.outputfile.replace('\\', '/');
            if (!this.messageThread.absolutePath) {
                this.outputfile = this.messageThread.usedURL ? this.server.urlPath + "/" + this.outputfile : this.server.getPath(this.outputfile);
            }
            try {
                boolean isPng;
                boolean isJpeg = this.messageThread.format == 3;
                boolean bl = isPng = this.messageThread.format == 4;
                if (isJpeg || isPng) {
                    MemoryImageSource source = new MemoryImageSource(this.messageThread.width, this.messageThread.height, buffer, 0, this.messageThread.width);
                    if (IOUtil.isJava2D()) {
                        this.outputfile = this.outputfile + (isJpeg ? ".jpg" : ".png");
                        ImageEncoder.ExportFormat exportFormat = isJpeg ? ImageEncoder.ExportFormat.JPEG : ImageEncoder.ExportFormat.PNG;
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(this.server.getPath(this.outputfile));
                            Image image = Toolkit.getDefaultToolkit().createImage(source);
                            ImageEncoder.encode(exportFormat, image, out, this.messageThread.quality);
                        }
                        catch (Throwable throwable) {
                            CloseUtils.close(out);
                            throw throwable;
                        }
                        CloseUtils.close(out);
                        break block26;
                    }
                    String mess = "Please include ExportLib.jar file in your classpath";
                    this.cleanup(3, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                    break block26;
                }
                if (this.messageThread.format == 5) {
                    this.outputfile = this.outputfile + ".gif";
                    FileOutputStream out = new FileOutputStream(this.server.getPath(this.outputfile));
                    new GifEncoder87a(buffer, this.messageThread.width, this.messageThread.height).write(out);
                } else if (this.server.service) {
                    this.sendDataToService(this.messageThread.format, buffer, this.messageThread.width, this.messageThread.height, this.outputfile, this.messageThread.quality);
                } else {
                    ExportChart.nativeExport(this.messageThread.format, buffer, this.messageThread.width, this.messageThread.height, this.server.getPath(this.outputfile), this.messageThread.quality);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                String mess = ex.toString();
                this.cleanup(3, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String mess = ex.toString();
                this.cleanup(-2, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                return;
            }
            catch (OutOfMemoryError err) {
                String mess = err.toString();
                this.cleanup(2, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                err.printStackTrace();
                return;
            }
            catch (Error err) {
                String mess = err.toString();
                this.cleanup(-1, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                err.printStackTrace();
                return;
            }
        }
        this.cleanup(0, "Finish.\n");
    }

    void cleanup(int code, String err) {
        this.acknowledge(code, err);
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Fail to Acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nOutput : " + this.outputfile + " -- ";
    }

    void sendDataToService(int format, int[] buffer, int width, int height, String filename, int quality) throws Exception {
        Socket client_socket2 = null;
        ServerSocket socket2 = new ServerSocket(0);
        filename = filename.replace('/', '\\');
        int portno = socket2.getLocalPort();
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(100);
            DataOutputStream dout3 = new DataOutputStream(bstream);
            dout3.writeInt(portno);
            dout3.writeByte((byte)format);
            dout3.writeShort((short)width);
            dout3.writeShort((short)height);
            dout3.writeShort((short)quality);
            filename = filename.replace('/', '\\');
            Server.writeString(dout3, filename);
            DataOutputStream dout2 = new DataOutputStream(System.out);
            dout2.writeBytes("Service_EXPORTIMG");
            byte[] barray = bstream.toByteArray();
            dout2.writeShort(barray.length + 3);
            dout2.write(barray);
            int size = width * height;
            for (int i = 0; i < size; ++i) {
                dout2.writeInt(buffer[i]);
            }
            dout2.flush();
            client_socket2 = socket2.accept();
        }
        catch (IOException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                CloseUtils.close(client_socket2);
                CloseUtils.close(socket2);
                throw throwable;
            }
        }
        CloseUtils.close(client_socket2);
        CloseUtils.close(socket2);
        try {
            DataInputStream din = new DataInputStream(client_socket2.getInputStream());
            if (din.readByte() == 101) {
                byte[] b = new byte[100];
                int len = din.read(b);
                throw new IOException(new String(b, 0, len - 2));
            }
            din.close();
            client_socket2.close();
            socket2.close();
        }
        catch (Exception ex) {
            try {
                client_socket2.close();
                socket2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }
}

