/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.FilterInfo;
import quadbase.chart.LoadChart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.SaveChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.network.ServletConnection;
import quadbase.common.network.ServletServerConnection;
import quadbase.common.pak.PakEntry;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.server.ChartExportSlave;
import quadbase.common.server.ChtExportSlave;
import quadbase.common.server.ClassFileSlave;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.CopyFileSlave;
import quadbase.common.server.CreateChartSlave;
import quadbase.common.server.CreatePakSlave;
import quadbase.common.server.CreateViewPagesSlave;
import quadbase.common.server.DBFirstValueSlave;
import quadbase.common.server.DBdistinctSlave;
import quadbase.common.server.DBparamFunctionMetaSlave;
import quadbase.common.server.DBparamMetaSlave;
import quadbase.common.server.DBparamTypeSlave;
import quadbase.common.server.DBqueryMetaSlave;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.DataFileMetaSlave;
import quadbase.common.server.DataFileSlave;
import quadbase.common.server.DataRegistrySlave;
import quadbase.common.server.DefaultFilesSlave;
import quadbase.common.server.DeleteFileSlave;
import quadbase.common.server.DeleteTempFileSlave;
import quadbase.common.server.DesignerSlave;
import quadbase.common.server.EJBAccessSlave;
import quadbase.common.server.EJBHomeMethodAccessSlave;
import quadbase.common.server.EJBMetaDataSlave;
import quadbase.common.server.ExcelSlave;
import quadbase.common.server.ExportBarcodeSlave;
import quadbase.common.server.ExportSlave;
import quadbase.common.server.FileInfoRootSlave;
import quadbase.common.server.FileInfoSlave;
import quadbase.common.server.FileLockSlave;
import quadbase.common.server.FilterDataFileSlave;
import quadbase.common.server.FilterPPSQLSlave;
import quadbase.common.server.GetSOAPXMLSlave;
import quadbase.common.server.ImgExportSlave;
import quadbase.common.server.LicenseInfoSlave;
import quadbase.common.server.PageViewerHTMLSlave;
import quadbase.common.server.ParseWSDLSlave;
import quadbase.common.server.QBDatabaseConnection;
import quadbase.common.server.QBSQLSlave;
import quadbase.common.server.QBTableInfo;
import quadbase.common.server.QBTableList;
import quadbase.common.server.QbFileOutputStreamSlave;
import quadbase.common.server.ReleaseFileSlave;
import quadbase.common.server.RenameSlave;
import quadbase.common.server.ReplaceSlave;
import quadbase.common.server.SCHScheduler;
import quadbase.common.server.SFparamMetaSlave;
import quadbase.common.server.SQLSlave;
import quadbase.common.server.SalesForceQuerySlave;
import quadbase.common.server.Server;
import quadbase.common.server.ServerDirectorySlave;
import quadbase.common.server.StreamSlave;
import quadbase.common.server.TestDBConnectionSlave;
import quadbase.common.server.TestSalesForceConnectionSlave;
import quadbase.common.server.URLSlave;
import quadbase.common.server.UnpakSlave;
import quadbase.common.server.UserLanguageSlave;
import quadbase.common.server.XMLChartSlave;
import quadbase.common.server.XMLDataParserSlave;
import quadbase.common.server.XMLDataSheetSlave;
import quadbase.common.server.XMLFontMappingSlave;
import quadbase.common.server.XMLGlobalFormatSlave;
import quadbase.common.server.XMLReportDataSlave;
import quadbase.common.server.XMLReportSlave;
import quadbase.common.server.XMLTemplateSlave;
import quadbase.common.server.XMLVerifySlave;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.ERESLog;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.scheduler.ScheduleObject;

public class MessageThread
extends Thread {
    String infile;
    String outfile;
    String oldStr;
    String newStr;
    byte[] reportData;
    DBInfoBasic dbInfo;
    String username;
    String password;
    boolean useDBbuffer = false;
    int slaveType;
    String orgUserName;
    String remoteAddr;
    String details = null;
    int width;
    int height;
    int packageLen;
    int format;
    int quality;
    boolean usedURL = false;
    boolean absolutePath;
    boolean createHtml = false;
    boolean useSwing = false;
    boolean usePageViewer = false;
    boolean useXML = false;
    int viewerType = 0;
    boolean blogin;
    boolean isOrganizer;
    boolean isFromQbDesigner;
    IConnection socket;
    Server server;
    int requestNo;
    boolean transposeData;
    boolean[] transposeCol;
    boolean filterData;
    boolean preProcessData;
    PreprocInfo tsInfo;
    FilterInfo filterInfo;
    String[] validExtension;
    boolean readLastModifiedTime = false;
    boolean includeDir = true;
    boolean isGoUpEnabled = true;
    String defaultDir = "";
    int sourceType = 2;
    boolean drawNullColumn = false;
    String nullHandleName = "NULL";
    String deleteFile = null;
    int drillNum = 0;
    String deleteTempFile = null;
    boolean hasParameters;
    QueryInParamSet inParamSet;
    String tableName;
    String columnName;
    String paramName;
    String paramFunction;
    String tableNames;
    DataBuffer dataBuffer;
    String[] tableType;
    String query;
    int defaultValue;
    int startIndex;
    int displayRow;
    boolean checkSyntaxOnly;
    ScheduleObject scheduleObject;
    int rowIndex;
    String barcodeFileName;
    String codeText;
    int barType;
    int barWidth;
    int barHeight;
    int barcodeLMargin;
    Font barFont;
    Color barBgColor;
    Color barFColor;
    Chart chart;
    String jndiName;
    String homeName;
    String remoteName;
    String selectedMethodName;
    Object[] param;
    Hashtable<String, String> environment = null;
    XMLFileQueryInfo xmlFileQueryInfo;
    XMLFileQueryInfo xmlDataSheetInfo;
    int xmlStartIndex;
    int xmlDisplayRow;
    String xmlFile;
    int verifyType;
    String externalFile;
    String[] columnNames;
    boolean[] isAsc;
    int order = -1;
    int[] mapping;
    String exportfile;
    int jobRequest;
    int exportType;
    boolean isMultiPageUsed;
    boolean paginatedSinglePage;
    boolean exportTarget = true;
    String exportServlet = "http://localhost:8080/servlet/ViewerExportServlet";
    boolean isDynamicExport = false;
    String serverName = "localhost";
    int serverPort = 8080;
    String servletDirectory = "servlet/";
    boolean doSorting = false;
    String encoding;
    long bufferTime;
    boolean getData = false;
    boolean fromLoadBalancer = false;
    boolean lock = false;
    int fileLockOption;
    SOAPQueryFileInfo soapInfo = null;
    SalesForceQueryFileInfo sfQueryInfo = null;
    ExcelFileInfo excelInfo;
    PakEntry[] pakEntries = null;
    int flashFrameCount = 12;
    float flashFrameRate = 20.0f;
    boolean isDefaultValue;
    private String rootFile;

    public MessageThread(Server server, IConnection socket, int requestNo) {
        this.socket = socket;
        this.server = server;
        this.requestNo = requestNo;
        if (Server.showMonitor) {
            ++Server.sm.smui.vThread;
        }
    }

    private void readTestDBConnectionMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
    }

    private void readTestSFConnectionMessage(DataInputStream in) throws IOException {
        this.username = IOUtil.readString(in, true);
        this.password = IOUtil.readString(in, true);
    }

    private void readSFQueryMessage(DataInputStream in) throws IOException {
        this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfo(in, 361);
        this.sfQueryInfo.setServerUrl(IOUtil.readStr(in));
        this.sfQueryInfo.setSessionId(IOUtil.readStr(in));
        this.startIndex = in.readInt();
        this.displayRow = in.readInt();
        this.transposeData = in.readBoolean();
        if (this.transposeData) {
            this.transposeCol = IOUtil.readBooleans(in);
        }
        if (in.readBoolean()) {
            this.tsInfo = new PreprocInfo(0);
            this.tsInfo.readAsStream(in, 100);
        }
    }

    private void readExcelMessage(DataInputStream in) throws IOException {
        this.jobRequest = in.readInt();
        switch (this.jobRequest) {
            case 12002: {
                this.excelInfo = ExcelFileInfo.read(in, 0);
                this.transposeData = in.readBoolean();
                if (this.transposeData) {
                    this.transposeCol = IOUtil.readBooleans(in);
                }
                if (in.readBoolean()) {
                    this.tsInfo = new PreprocInfo(0);
                    this.tsInfo.readAsStream(in, 100);
                }
                this.startIndex = in.readInt();
                this.displayRow = in.readInt();
                break;
            }
            case 12003: {
                String path = IOUtil.readString(in);
                this.excelInfo = new ExcelFileInfo(path);
            }
        }
    }

    private void readSFparamMetaMessage(DataInputStream in) throws IOException {
        this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfo(in, 361);
        this.sfQueryInfo.setServerUrl(IOUtil.readStr(in));
        this.sfQueryInfo.setSessionId(IOUtil.readStr(in));
        this.paramName = IOUtil.readString(in, true);
    }

    private void readSOAPConnectionMessage(DataInputStream in) throws IOException {
        this.soapInfo = SOAPQueryFileInfo.readSOAPQueryFileInfo(new VersioningDataInput(in, 6612));
    }

    private void readParseWSDLMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readStr(in);
    }

    private void readSQLMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
        this.hasParameters = in.readBoolean();
        this.inParamSet = this.hasParameters ? QueryInParamSet.read(in, 6612) : null;
        this.server.getConnectionBuffer();
        this.useDBbuffer = in.readBoolean() && ConnectionBuffer.getBufferSize() > 1;
        this.transposeData = in.readBoolean();
        this.transposeCol = IOUtil.readBooleans(in);
        this.startIndex = in.readInt();
        this.displayRow = in.readInt();
    }

    private void readSQLMessageEXT(DataInputStream in) throws IOException {
        this.readSQLMessage(in);
        this.drawNullColumn = in.readBoolean();
        this.nullHandleName = IOUtil.readStr(in);
    }

    private void readFilterPPSQLMessage(DataInputStream in) throws IOException {
        this.readSQLMessage(in);
        this.drawNullColumn = in.readBoolean();
        this.nullHandleName = IOUtil.readStr(in);
        this.filterData = in.readBoolean();
        if (this.filterData) {
            this.filterInfo = FilterInfo.readAsStream(in, 100);
        }
        this.preProcessData = in.readBoolean();
        if (this.preProcessData) {
            this.tsInfo = new PreprocInfo(0);
            this.tsInfo.readAsStream(in, 100);
        }
    }

    private void readFilterDataFileMessage(DataInputStream in) throws IOException {
        this.readStreamMessage(in);
        this.transposeData = in.readBoolean();
        this.transposeCol = IOUtil.readBooleans(in);
        this.filterData = in.readBoolean();
        if (this.filterData) {
            this.filterInfo = FilterInfo.readAsStream(in, 100);
        }
        this.preProcessData = in.readBoolean();
        if (this.preProcessData) {
            this.tsInfo = new PreprocInfo(0);
            this.tsInfo.readAsStream(in, 100);
        }
        this.sourceType = in.readInt();
        this.drawNullColumn = in.readBoolean();
        this.nullHandleName = IOUtil.readStr(in);
        this.encoding = IOUtil.readStr(in);
    }

    private void readDefaultFilesSlave(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
    }

    private void writeExportMessage(DataOutputStream out) throws IOException {
        out.writeInt(this.packageLen);
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeBoolean(false);
        out.writeBoolean(this.createHtml);
        out.writeBoolean(this.useSwing);
        out.writeBoolean(this.usePageViewer);
        out.writeBoolean(this.useXML);
        IOUtil.writeStr(out, this.deleteFile);
    }

    private void readExportMessage(DataInputStream in) throws IOException {
        this.packageLen = in.readInt();
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.absolutePath = in.readBoolean();
        this.createHtml = in.readBoolean();
        this.useSwing = in.readBoolean();
        this.usePageViewer = in.readBoolean();
        this.useXML = in.readBoolean();
        this.deleteFile = IOUtil.readStr(in);
    }

    private void writePageViewerHTMLMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeBoolean(false);
        out.writeBoolean(this.useSwing);
    }

    private void readPageViewerHTMLMessage(DataInputStream in) throws IOException {
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.absolutePath = in.readBoolean();
        this.useSwing = in.readBoolean();
    }

    private void writeChartExportMessage(DataOutputStream out) throws IOException {
        out.writeInt(this.packageLen);
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeBoolean(false);
        out.writeBoolean(this.createHtml);
        out.writeBoolean(this.useSwing);
        out.writeBoolean(this.usePageViewer);
        out.writeBoolean(this.useXML);
    }

    private void readChartExportMessage(DataInputStream in) throws IOException {
        this.packageLen = in.readInt();
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.absolutePath = in.readBoolean();
        this.createHtml = in.readBoolean();
        this.viewerType = in.readShort();
        this.useSwing = in.readBoolean();
        this.useXML = in.readBoolean();
    }

    private void readEJBInfoMessage(DataInputStream in) throws IOException {
        this.jndiName = IOUtil.readString(in, true);
        this.homeName = IOUtil.readString(in, true);
        this.remoteName = IOUtil.readString(in, true);
        this.selectedMethodName = IOUtil.readString(in, true);
        int size = in.readInt();
        String[] paramTypes = new String[size];
        String[] values = new String[size];
        this.param = new Object[size];
        for (int i = 0; i < size; ++i) {
            paramTypes[i] = IOUtil.readString(in, true);
            values[i] = IOUtil.readString(in, true);
            this.param[i] = EJBUtil.getRuntimeInputValue(paramTypes[i], values[i]);
        }
        int envsize = in.readInt();
        if (envsize > 0) {
            this.environment = new Hashtable();
            for (int i = 0; i < envsize; ++i) {
                String key = IOUtil.readString(in, true);
                String val = IOUtil.readString(in, true);
                this.environment.put(key, val);
            }
        }
    }

    private void readEJBRemoteNameMessage(DataInputStream in) throws IOException {
        this.remoteName = IOUtil.readString(in, true);
    }

    private void readEJBHomeNameMessage(DataInputStream in) throws IOException {
        this.homeName = IOUtil.readString(in, true);
    }

    private void readXMLVerifyMessage(DataInputStream in) throws IOException {
        this.xmlFile = IOUtil.readString(in, true);
        this.verifyType = in.readInt();
        this.externalFile = IOUtil.readString(in, true);
    }

    private void writeStreamMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.infile));
    }

    private void readStreamMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        this.infile = this.checkWorkingDirectory(this.infile);
    }

    private void readReleaseFileByMachineMessage(DataInputStream in) throws IOException {
        this.remoteAddr = IOUtil.readString(in, true);
    }

    private void readFileLockMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
        String remoteAddress = IOUtil.readString(in, true);
        this.fileLockOption = in.readInt();
        if (!(this.socket instanceof ServletServerConnection) || this.remoteAddr.indexOf("OrgUserToken") < 0) {
            this.remoteAddr = remoteAddress;
        }
    }

    private void readStreamDataMessage(DataInputStream in) throws IOException {
        this.infile = this.replaceBackSlashesBySlashes(IOUtil.readString(in, true));
        this.getData = in.readBoolean();
    }

    private String replaceBackSlashesBySlashes(String input) {
        if (input != null && input.indexOf(":\\") > -1) {
            return input.replace('\\', '/');
        }
        return input;
    }

    private void readViewPagesMessage(DataInputStream in) throws IOException {
        try {
            int i;
            this.infile = IOUtil.readString(in, true);
            int count = in.readInt();
            if (count > 0) {
                this.reportData = new byte[count];
                in.readFully(this.reportData);
            }
            if (this.infile.indexOf(":\\") > -1) {
                this.infile = this.infile.replace('\\', '/');
            }
            boolean hasSecurity = in.readBoolean();
            this.username = null;
            if (hasSecurity) {
                this.username = IOUtil.readString(in, true);
            }
            this.outfile = IOUtil.readString(in, true);
            if (this.outfile.indexOf(":\\") > -1) {
                this.outfile = this.outfile.replace('\\', '/');
            }
            this.rootFile = IOUtil.readString(in, true);
            this.jobRequest = in.readInt();
            if (this.jobRequest == 4) {
                this.doSorting = in.readBoolean();
                return;
            }
            if (in.readBoolean()) {
                this.param = new Object[in.readInt()];
                for (i = 0; i < this.param.length; ++i) {
                    if (in.readBoolean()) {
                        if (in.readBoolean()) {
                            Vector<Object> vec = new Vector<Object>();
                            int size = in.readInt();
                            for (int j = 0; j < size; ++j) {
                                vec.addElement(DataType.read(IOUtil.readString(in, true)));
                            }
                            this.param[i] = vec;
                            continue;
                        }
                        this.param[i] = DataType.read(IOUtil.readString(in, true));
                        continue;
                    }
                    this.param[i] = null;
                }
            } else {
                this.param = null;
            }
            this.order = in.readInt();
            this.mapping = new int[in.readInt()];
            for (i = 0; i < this.mapping.length; ++i) {
                this.mapping[i] = in.readInt();
            }
            this.columnNames = new String[in.readInt()];
            this.isAsc = new boolean[this.columnNames.length];
            for (i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = IOUtil.readString(in, true);
                this.isAsc[i] = in.readBoolean();
            }
            if (this.jobRequest == 2) {
                this.exportType = in.readInt();
                this.exportfile = IOUtil.readString(in, true);
                if (this.exportfile.indexOf(":\\") > -1) {
                    this.exportfile = this.exportfile.replace('\\', '/');
                }
                this.isMultiPageUsed = in.readBoolean();
                this.paginatedSinglePage = in.readBoolean();
                this.exportTarget = in.readBoolean();
                this.exportServlet = IOUtil.readString(in, true);
                this.isDynamicExport = in.readBoolean();
                this.serverName = IOUtil.readString(in, true);
                this.serverPort = in.readInt();
                this.servletDirectory = IOUtil.readString(in, true);
            }
            this.bufferTime = in.readLong();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    private void readXMLTemplateMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        int len = in.readInt();
        byte[] indata = new byte[len];
        in.readFully(indata, 0, len);
        Frame frame = new Frame();
        frame.addNotify();
        this.chart = new LoadChart().load(frame, new DataInputStream(new ByteArrayInputStream(indata)), false, null);
        frame.removeNotify();
    }

    private void readXMLReportDataMessage(DataInputStream in) throws IOException {
        this.packageLen = in.readInt();
    }

    private void readXMLDataParserMessage(DataInputStream in) throws IOException {
        this.readDataFileMessage(in);
        this.xmlFileQueryInfo = XMLFileQueryInfo.read(in);
    }

    private void readXMLDataSheetMessage(DataInputStream in) throws IOException {
        this.xmlDataSheetInfo = XMLFileQueryInfo.read(in);
        this.xmlStartIndex = in.readInt();
        this.xmlDisplayRow = in.readInt();
    }

    private void readCreateChartMessage(DataInputStream in) throws IOException {
        this.format = in.readInt();
    }

    private void readDataFileMessage(DataInputStream in) throws IOException {
        this.readStreamMessage(in);
        this.transposeData = in.readBoolean();
        this.transposeCol = IOUtil.readBooleans(in);
        this.preProcessData = in.readBoolean();
        if (this.preProcessData) {
            this.tsInfo = new PreprocInfo(0);
            this.tsInfo.readAsStream(in, 100);
        }
        this.sourceType = in.readInt();
        this.drawNullColumn = in.readBoolean();
        this.nullHandleName = IOUtil.readStr(in);
        this.encoding = IOUtil.readStr(in);
    }

    private void writeImgExportMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeInt(this.quality);
        out.writeBoolean(false);
        out.writeInt(this.width);
        out.writeInt(this.height);
        out.writeInt(this.format);
        out.writeBoolean(this.usedURL);
    }

    private void readImgExportMessage(DataInputStream in) throws IOException {
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.quality = in.readInt();
        this.absolutePath = in.readBoolean();
        this.width = in.readInt();
        this.height = in.readInt();
        this.format = in.readInt();
        this.usedURL = in.readBoolean();
    }

    private void writeChtExportMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeBoolean(false);
        out.writeInt(this.format);
        out.writeInt(this.width);
        out.writeInt(this.height);
    }

    private void readChtExportMessage(DataInputStream in) throws IOException {
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.infile = this.checkWorkingDirectory(this.outfile);
        this.absolutePath = in.readBoolean();
        this.format = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.flashFrameCount = in.readInt();
        this.flashFrameRate = in.readFloat();
    }

    private void readDesignMessage(DataInputStream in) throws IOException {
        this.blogin = in.readBoolean();
        this.isOrganizer = in.readBoolean();
        this.isFromQbDesigner = in.readBoolean();
        if (this.blogin) {
            if (!this.isOrganizer) {
                this.username = Coder.decode(IOUtil.readString(in, true), 7004);
                this.password = Coder.decode(IOUtil.readString(in, true), 7004);
            } else {
                this.username = "Organizer User";
                this.password = "";
            }
        }
    }

    private void readURLMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        this.readLastModifiedTime = in.readBoolean();
        this.includeDir = in.readBoolean();
        this.isGoUpEnabled = in.readBoolean();
        if (!this.isGoUpEnabled) {
            this.defaultDir = IOUtil.readString(in, true);
        }
        int size = in.readInt();
        this.validExtension = new String[size];
        for (int i = 0; i < size; ++i) {
            this.validExtension[i] = IOUtil.readString(in, true);
        }
    }

    private void readUserLanguageMessage(DataInputStream in) throws IOException {
    }

    private void readGetOSNameMessage(DataInputStream in) throws IOException {
    }

    private void writeRenameMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.infile));
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
    }

    private void readRenameMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.infile = this.checkWorkingDirectory(this.infile);
        this.outfile = this.checkWorkingDirectory(this.outfile);
    }

    private void writeExportBarcodeMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.barcodeFileName));
        IOUtil.writeString(out, this.codeText);
        out.writeInt(this.barType);
        out.writeInt(this.barWidth);
        out.writeInt(this.barHeight);
        out.writeInt(this.barcodeLMargin);
    }

    private void readExportBarcodeMessage(DataInputStream in) throws IOException {
        this.barcodeFileName = IOUtil.readString(in, true);
        this.barcodeFileName = this.checkWorkingDirectory(this.barcodeFileName);
        this.codeText = IOUtil.readString(in, true);
        this.barType = in.readInt();
        this.barWidth = in.readInt();
        this.barHeight = in.readInt();
        this.barcodeLMargin = in.readInt();
        this.barFont = IOUtil.readFont(in);
        this.barBgColor = IOUtil.readColor(in);
        this.barFColor = IOUtil.readColor(in);
    }

    private void writeReplaceMessage(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.infile));
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        IOUtil.writeString(out, this.oldStr);
        IOUtil.writeString(out, this.newStr);
    }

    private void readReplaceMessage(DataInputStream in) throws IOException {
        this.infile = IOUtil.readString(in, true);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.infile = this.checkWorkingDirectory(this.infile);
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.oldStr = IOUtil.readString(in, true);
        this.newStr = IOUtil.readString(in, true);
    }

    private void writeDeleteFileName(DataOutputStream out) throws IOException {
        out.writeInt(this.drillNum);
        IOUtil.writeString(out, IOUtil.toRelativePath(this.deleteFile));
    }

    private void readDeleteFileName(DataInputStream in) throws IOException {
        this.drillNum = in.readInt();
        this.deleteFile = IOUtil.readString(in, true);
        this.deleteFile = this.checkWorkingDirectory(this.deleteFile);
    }

    private void writeDeleteTempFileName(DataOutputStream out) throws IOException {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.deleteTempFile));
    }

    private void readDeleteTempFileName(DataInputStream in) throws IOException {
        this.deleteTempFile = IOUtil.readString(in, true);
        this.deleteTempFile = this.checkWorkingDirectory(this.deleteTempFile);
    }

    private void readDBdistinctMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
        this.tableName = Coder.decode(IOUtil.readString(in, true), 7004);
        this.columnName = Coder.decode(IOUtil.readString(in, true), 7004);
    }

    private void readPrepareSQLMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
        this.query = Coder.decode(IOUtil.readLongString(in), 7004);
        this.isDefaultValue = in.readBoolean();
    }

    private void readSQLSELECTMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
        this.query = Coder.decode(IOUtil.readLongString(in), 7004);
        this.defaultValue = in.readInt();
    }

    private void readDBparamMetaMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
        this.paramName = Coder.decode(IOUtil.readString(in, true), 7004);
    }

    private void readDBparamFunctionMetaMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
        this.paramFunction = Coder.decode(IOUtil.readString(in, true), 7004);
        this.tableNames = Coder.decode(IOUtil.readString(in, true), 7004);
    }

    private void readDBparamTypeMessage(DataInputStream in) throws IOException {
        this.dbInfo = DBInfoBasic.read(in, 6612);
        if (this.dbInfo.getURLString() != null) {
            this.dbInfo.setURLString(ServerMessage.getDatabaseURL(this.dbInfo.getURLString()));
        }
    }

    private void readDBqueryMetaMessage(DataInputStream in) throws IOException {
        this.readSQLMessage(in);
    }

    private void readDataFileMetaMessage(DataInputStream in) throws IOException {
        this.infile = Coder.decode(IOUtil.readString(in, true), 7004);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        this.transposeData = in.readBoolean();
        this.transposeCol = IOUtil.readBooleans(in);
        this.sourceType = in.readInt();
        boolean hasParam = in.readBoolean();
        this.inParamSet = hasParam ? QueryInParamSet.read(in, 6602) : null;
    }

    private void readDatabaseConnectionMessage(DataInputStream in) throws Exception {
        boolean useJNDIDataSource = in.readBoolean();
        if (useJNDIDataSource) {
            String JNDIName = Coder.decode(IOUtil.readString(in, true), 7004);
            Hashtable<String, String> env = new Hashtable<String, String>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Coder.decode(IOUtil.readString(in, true));
                String value = Coder.decode(IOUtil.readString(in, true));
                if (value == null || value.equals("")) continue;
                env.put(key, value);
            }
            this.server.getConnectionBuffer();
            this.dataBuffer = new DataBuffer(ConnectionBuffer.getBufferSize(), new DBInfoBasic(JNDIName, "", env));
        } else {
            String url = Coder.decode(IOUtil.readString(in, true), 7004);
            String driver = Coder.decode(IOUtil.readString(in, true), 7004);
            String userName = Coder.decode(IOUtil.readString(in, true), 7004);
            String password = Coder.decode(IOUtil.readString(in, true), 7004);
            url = ServerMessage.getDatabaseURL(url);
            this.server.getConnectionBuffer();
            this.dataBuffer = new DataBuffer(ConnectionBuffer.getBufferSize(), new DBInfoBasic(url, driver, userName, password, ""));
        }
    }

    private void readSchModifySchedule(DataInputStream in) throws Exception {
        this.rowIndex = in.readInt();
        this.scheduleObject = ScheduleObject.read(in, 148);
    }

    private void readSchAddSchedule(DataInputStream in) throws Exception {
        this.scheduleObject = ScheduleObject.read(in, 148);
    }

    private void readTableListMessage(DataInputStream in) throws Exception {
        this.readDatabaseConnectionMessage(in);
        int size = in.readInt();
        this.tableType = new String[size];
        for (int i = 0; i < size; ++i) {
            this.tableType[i] = IOUtil.readString(in, true);
        }
        this.usedURL = in.readBoolean();
        this.format = in.readInt();
    }

    private void readTableInfoMessage(DataInputStream in) throws Exception {
        this.readDatabaseConnectionMessage(in);
        this.tableName = IOUtil.readString(in, true);
        this.preProcessData = in.readBoolean();
    }

    private void readTableSQLMessage(DataInputStream in) throws Exception {
        this.readDatabaseConnectionMessage(in);
        this.query = IOUtil.readLongString(in);
        this.startIndex = in.readInt();
        this.displayRow = in.readInt();
        this.packageLen = in.readInt();
        boolean paramExists = in.readBoolean();
        this.inParamSet = paramExists ? QueryInParamSet.read(in, 6612) : null;
    }

    private void readForeignKeyMessage(DataInputStream in) throws Exception {
        this.readDatabaseConnectionMessage(in);
        this.format = in.readInt();
        this.tableName = IOUtil.readString(in, true);
    }

    private void writeCopyFileMessage(DataOutputStream out) throws Exception {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.infile));
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
    }

    private void readCopyFileMessage(DataInputStream in) throws Exception {
        this.infile = IOUtil.readString(in, true);
        if (this.infile.indexOf(":\\") > -1) {
            this.infile = this.infile.replace('\\', '/');
        }
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.infile = this.checkWorkingDirectory(this.infile);
        this.outfile = this.checkWorkingDirectory(this.outfile);
    }

    private void writeOutputStreamInitializeMessage(DataOutputStream out) throws Exception {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeBoolean(this.transposeData);
    }

    private void readCreatePakMessage(DataInputStream in) throws Exception {
        this.format = in.readInt();
        this.infile = IOUtil.readStr(in);
        this.username = IOUtil.readStr(in);
        this.outfile = IOUtil.readStr(in);
    }

    private void readUnpakMessage(DataInputStream in) throws Exception {
        this.jobRequest = in.readInt();
        this.format = in.readInt();
        this.infile = IOUtil.readStr(in);
        if (this.jobRequest == 2 || this.jobRequest == 3) {
            int count = in.readInt();
            this.pakEntries = new PakEntry[count];
            for (int i = 0; i < count; ++i) {
                this.pakEntries[i] = PakEntry.readPakEntry(in);
            }
        }
    }

    private void readOutputStreamInitializeMessage(DataInputStream in) throws Exception {
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.transposeData = in.readBoolean();
    }

    private void writeOuputStreamWriteMessage(DataOutputStream out) throws Exception {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
        out.writeInt(this.packageLen);
    }

    private void readOutputStreamWriteMessage(DataInputStream in) throws Exception {
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
        this.packageLen = in.readInt();
    }

    private void writeOutputStreamCloseMessage(DataOutputStream out) throws Exception {
        IOUtil.writeString(out, IOUtil.toRelativePath(this.outfile));
    }

    private void readOutputStreamCloseMessage(DataInputStream in) throws Exception {
        this.outfile = IOUtil.readString(in, true);
        if (this.outfile.indexOf(":\\") > -1) {
            this.outfile = this.outfile.replace('\\', '/');
        }
        this.outfile = this.checkWorkingDirectory(this.outfile);
    }

    private void readClassFileMessage(DataInputStream in) throws Exception {
        this.packageLen = in.readInt();
        this.infile = IOUtil.readString(in, true);
        boolean moreinfo = in.readBoolean();
        if (moreinfo) {
            this.transposeData = in.readBoolean();
            this.transposeCol = IOUtil.readBooleans(in);
            this.filterData = in.readBoolean();
            if (this.filterData) {
                this.filterInfo = FilterInfo.readAsStream(in, 100);
            }
            this.preProcessData = in.readBoolean();
            if (this.preProcessData) {
                this.tsInfo = new PreprocInfo(0);
                this.tsInfo.readAsStream(in, 100);
            }
            this.width = in.readInt();
            this.height = in.readInt();
            boolean hasParamSet = in.readBoolean();
            this.inParamSet = hasParamSet ? QueryInParamSet.read(in, 6602) : null;
        }
    }

    @Override
    public void run() {
        this.processMessage();
    }

    void processMessage() {
        block231: {
            boolean writeToERESLog = true;
            byte[] requestByteArray = null;
            byte[] responseByteArray = null;
            int process = -1;
            int product = 13;
            try {
                if (this.socket instanceof ServletServerConnection) {
                    this.orgUserName = ((ServletServerConnection)this.socket).getUserName();
                    this.remoteAddr = ((ServletServerConnection)this.socket).getPeerAddress();
                }
                DataInputStream in = new DataInputStream(this.socket.getInputStream());
                this.slaveType = in.readShort();
                boolean b = false;
                if (this.slaveType == 22071 || this.slaveType == 29302 || this.slaveType == 26001 || this.slaveType == 23801 || this.slaveType == 25330 || this.slaveType == 25331 || this.slaveType == 1076 || this.slaveType == 28929 || this.slaveType == 29203 || this.slaveType == 10001 || this.slaveType == 10002 || this.slaveType == 10003 || this.slaveType == 20088 || this.slaveType == 26000 || this.slaveType == 26004 || this.slaveType == 23868 || this.slaveType == 23866 || this.slaveType == 20876 || this.slaveType == 25578) {
                    this.fromLoadBalancer = in.readBoolean();
                    b = true;
                }
                if (!(ServerMessage.isLoadBalancer || this.fromLoadBalancer || this.slaveType != 22071 && this.slaveType != 29302 && this.slaveType != 26001 && this.slaveType != 22111 && this.slaveType != 20880 && this.slaveType != 20881 && this.slaveType != 25330 && this.slaveType != 25331 && this.slaveType != 29370 && this.slaveType != 29371 && this.slaveType != 29399 && this.slaveType != 29203 && this.slaveType != 20088 && this.slaveType != 10001 && this.slaveType != 10002 && this.slaveType != 10003 && this.slaveType != 26000 && this.slaveType != 26004 && this.slaveType != 23868 && this.slaveType != 23866 && this.slaveType != 30500 && this.slaveType != 20876 && this.slaveType != 28931 && this.slaveType != 20877 && this.slaveType != 30158 && this.slaveType != 24578 && this.slaveType != 25588 && this.slaveType != 25579 && this.slaveType != 25578 && this.slaveType != 27678 && this.slaveType != 32420 && this.slaveType != 32419 && this.slaveType != 24327 && this.slaveType != 23801 && this.slaveType != 32415 && this.slaveType != 28816 && this.slaveType != 28929 && this.slaveType != 26002 && this.slaveType != 1076 && this.slaveType != 30831 && this.slaveType != 25367)) {
                    ServletConnection con;
                    block230: {
                        con = null;
                        try {
                            con = new ServletConnection(ServerMessage.serverHost, ServerMessage.portNumber, this.remoteAddr);
                        }
                        catch (IOException ex) {
                            try {
                                Thread.sleep(5000L);
                                con = new ServletConnection(ServerMessage.serverHost, ServerMessage.portNumber, this.remoteAddr);
                            }
                            catch (IOException e) {
                                ServerMessage.downTime = System.currentTimeMillis();
                                if (ServerMessage.isBackupServer) {
                                    ServerMessage.isLoadBalancer = true;
                                    ServerMessage.serverHost = ServerMessage.backupServer;
                                    ServerMessage.portNumber = ServerMessage.backupPort;
                                    ServerMessage.isBackupServer = false;
                                    ServerMessage.backupServer = "";
                                    ServerMessage.backupPort = 8080;
                                    break block230;
                                }
                                ServerMessage.serverHost = ServerMessage.backupServer;
                                ServerMessage.portNumber = ServerMessage.backupPort;
                                ServerMessage.backupServer = "";
                                ServerMessage.backupPort = 8080;
                                con = new ServletConnection(ServerMessage.serverHost, ServerMessage.portNumber, this.remoteAddr);
                            }
                        }
                    }
                    if (con != null) {
                        ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                        DataOutputStream dout = new DataOutputStream(con.getOutputStream());
                        int c = in.read();
                        while (c != -1) {
                            bytestream.write(c);
                            c = in.read();
                        }
                        bytestream.close();
                        requestByteArray = bytestream.toByteArray();
                        dout.writeShort(this.slaveType);
                        if (b) {
                            dout.writeBoolean(false);
                        }
                        dout.write(requestByteArray);
                        dout.flush();
                        dout.close();
                        DataInputStream din = new DataInputStream(con.getInputStream());
                        ByteArrayOutputStream bytestream2 = new ByteArrayOutputStream(2048);
                        c = din.read();
                        while (c != -1) {
                            bytestream2.write(c);
                            c = din.read();
                        }
                        din.close();
                        bytestream2.close();
                        responseByteArray = bytestream2.toByteArray();
                        OutputStream out = this.socket.getOutputStream();
                        out.write(responseByteArray);
                        out.flush();
                        out.close();
                        return;
                    }
                }
                switch (this.slaveType) {
                    case 10004: {
                        this.readDefaultFilesSlave(in);
                        break;
                    }
                    case 1076: {
                        this.readExportMessage(in);
                        break;
                    }
                    case 20088: {
                        this.readPageViewerHTMLMessage(in);
                        break;
                    }
                    case 24097: {
                        this.readSQLMessageEXT(in);
                        break;
                    }
                    case 20876: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 28931: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 20877: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 20880: {
                        this.readViewPagesMessage(in);
                        break;
                    }
                    case 20881: {
                        this.readViewPagesMessage(in);
                        break;
                    }
                    case 29370: {
                        this.readStreamDataMessage(in);
                        break;
                    }
                    case 31010: {
                        break;
                    }
                    case 29371: {
                        this.readStreamDataMessage(in);
                        break;
                    }
                    case 29399: {
                        break;
                    }
                    case 25578: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 25993: {
                        this.readXMLReportDataMessage(in);
                        break;
                    }
                    case 24327: {
                        this.readXMLDataParserMessage(in);
                        break;
                    }
                    case 32420: {
                        this.readXMLDataSheetMessage(in);
                        break;
                    }
                    case 25579: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 25588: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 32415: {
                        this.readDataFileMessage(in);
                        break;
                    }
                    case 32416: {
                        this.readEJBInfoMessage(in);
                        break;
                    }
                    case 32417: {
                        this.readEJBRemoteNameMessage(in);
                        break;
                    }
                    case 32418: {
                        this.readEJBHomeNameMessage(in);
                        break;
                    }
                    case 32419: {
                        this.readXMLVerifyMessage(in);
                        break;
                    }
                    case 30831: {
                        this.readDesignMessage(in);
                        break;
                    }
                    case 30158: {
                        this.readURLMessage(in);
                        break;
                    }
                    case 23868: {
                        this.readRenameMessage(in);
                        break;
                    }
                    case 23866: {
                        this.readReplaceMessage(in);
                        break;
                    }
                    case 28929: {
                        this.readExportBarcodeMessage(in);
                        break;
                    }
                    case 30500: {
                        break;
                    }
                    case 16789: {
                        this.readDBdistinctMessage(in);
                        break;
                    }
                    case 16790: {
                        this.readSQLSELECTMessage(in);
                        break;
                    }
                    case 16791: {
                        this.readPrepareSQLMessage(in);
                        break;
                    }
                    case 15765: {
                        this.readDBdistinctMessage(in);
                        break;
                    }
                    case 18657: {
                        this.readDBparamMetaMessage(in);
                        break;
                    }
                    case 18658: {
                        this.readDBparamFunctionMetaMessage(in);
                        break;
                    }
                    case 25679: {
                        this.readDBparamTypeMessage(in);
                        break;
                    }
                    case 23612: {
                        this.readDBqueryMetaMessage(in);
                        break;
                    }
                    case 25367: {
                        this.readDataFileMetaMessage(in);
                        break;
                    }
                    case 23801: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 28321: 
                    case 28356: 
                    case 28648: 
                    case 28762: 
                    case 28963: {
                        this.readDatabaseConnectionMessage(in);
                        break;
                    }
                    case 28771: {
                        this.readTableListMessage(in);
                        break;
                    }
                    case 28232: {
                        this.readTableInfoMessage(in);
                        break;
                    }
                    case 28928: {
                        this.readTableSQLMessage(in);
                        break;
                    }
                    case 28950: {
                        this.readForeignKeyMessage(in);
                    }
                    case 31001: 
                    case 31005: {
                        break;
                    }
                    case 31002: {
                        this.readSchModifySchedule(in);
                        break;
                    }
                    case 31003: 
                    case 31004: {
                        this.readSchAddSchedule(in);
                        break;
                    }
                    case 22071: {
                        this.readChartExportMessage(in);
                        break;
                    }
                    case 27587: {
                        this.readFilterPPSQLMessage(in);
                        break;
                    }
                    case 24578: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 27678: {
                        this.readXMLTemplateMessage(in);
                        break;
                    }
                    case 22111: {
                        this.readCreateChartMessage(in);
                        break;
                    }
                    case 28816: {
                        this.readFilterDataFileMessage(in);
                        break;
                    }
                    case 29203: {
                        this.readImgExportMessage(in);
                        break;
                    }
                    case 29302: {
                        this.readChtExportMessage(in);
                        break;
                    }
                    case 25330: {
                        this.readDeleteFileName(in);
                        break;
                    }
                    case 25331: {
                        this.readDeleteTempFileName(in);
                        break;
                    }
                    case 25332: {
                        this.readUserLanguageMessage(in);
                        break;
                    }
                    case 25335: {
                        this.readGetOSNameMessage(in);
                        break;
                    }
                    case 26000: {
                        this.readStreamMessage(in);
                        break;
                    }
                    case 26004: {
                        this.readFileLockMessage(in);
                        break;
                    }
                    case 26003: {
                        this.readReleaseFileByMachineMessage(in);
                        break;
                    }
                    case 26001: {
                        this.readCopyFileMessage(in);
                        break;
                    }
                    case 26002: {
                        break;
                    }
                    case 27001: {
                        this.readCreatePakMessage(in);
                        break;
                    }
                    case 27002: {
                        this.readUnpakMessage(in);
                        break;
                    }
                    case 28930: {
                        break;
                    }
                    case 10001: {
                        this.readOutputStreamInitializeMessage(in);
                        break;
                    }
                    case 10002: {
                        this.readOutputStreamWriteMessage(in);
                        break;
                    }
                    case 10003: {
                        this.readOutputStreamCloseMessage(in);
                        break;
                    }
                    case 25333: {
                        this.readClassFileMessage(in);
                        break;
                    }
                    case 25502: {
                        this.readSOAPConnectionMessage(in);
                        break;
                    }
                    case 25503: {
                        this.readParseWSDLMessage(in);
                        break;
                    }
                    case 32000: {
                        this.readTestDBConnectionMessage(in);
                        break;
                    }
                    case 11001: {
                        this.readTestSFConnectionMessage(in);
                        break;
                    }
                    case 11002: {
                        this.readSFQueryMessage(in);
                        break;
                    }
                    case 11003: {
                        this.readSFparamMetaMessage(in);
                        break;
                    }
                    case 12001: {
                        this.readExcelMessage(in);
                        break;
                    }
                    default: {
                        throw new IOException("Invalid Message Type " + this.slaveType);
                    }
                }
                if (this.socket instanceof ServletServerConnection) {
                    ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
                    int c = in.read();
                    while (c != -1) {
                        bytestream.write(c);
                        c = in.read();
                    }
                    in.close();
                    bytestream.close();
                    requestByteArray = bytestream.toByteArray();
                    in = new DataInputStream(new ByteArrayInputStream(requestByteArray));
                    ((ServletServerConnection)this.socket).setInputStream(in);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.closesocket();
                this.server.writeLog("[" + this.requestNo + "]  Fail to read message from " + this.socket.getPeerAddress() + "\n");
                return;
            }
            catch (Error err) {
                err.printStackTrace();
                this.closesocket();
                this.server.writeLog("[" + this.requestNo + "]  Error to read message from " + this.socket.getPeerAddress() + "\n");
                return;
            }
            this.details = "";
            try {
                if (Server.showMonitor) {
                    ++Server.sm.smui.vThread;
                }
                process = this.slaveType;
                switch (this.slaveType) {
                    case 10004: {
                        new DefaultFilesSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 1076: {
                        this.server.incRequestIONo();
                        new ExportSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 20088: {
                        this.server.incRequestIONo();
                        new PageViewerHTMLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 20876: {
                        this.server.incRequestIONo();
                        new StreamSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 28931: {
                        this.server.incRequestIONo();
                        new StreamSlave(this, this.server, this.socket, true).run();
                        break;
                    }
                    case 20877: {
                        this.server.incRequestIONo();
                        new StreamSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 20880: {
                        this.server.incRequestIONo();
                        new CreateViewPagesSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 20881: {
                        this.server.incRequestIONo();
                        new CreateViewPagesSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 29370: {
                        this.server.incRequestIONo();
                        new FileInfoSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 31010: {
                        this.server.incRequestIONo();
                        new LicenseInfoSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 29371: {
                        this.server.incRequestIONo();
                        new FileInfoSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 29399: {
                        this.server.incRequestIONo();
                        new FileInfoRootSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25578: {
                        this.server.incRequestIONo();
                        new XMLReportSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25993: {
                        this.server.incRequestIONo();
                        new XMLReportDataSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 24327: {
                        this.server.incRequestIONo();
                        new XMLDataParserSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32420: {
                        this.server.incRequestIONo();
                        new XMLDataSheetSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25579: {
                        this.server.incRequestIONo();
                        new XMLGlobalFormatSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25588: {
                        this.server.incRequestIONo();
                        new XMLFontMappingSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32415: {
                        this.server.incRequestIONo();
                        new DataFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32416: {
                        this.server.incRequestIONo();
                        new EJBAccessSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32417: {
                        this.server.incRequestIONo();
                        new EJBMetaDataSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32418: {
                        this.server.incRequestIONo();
                        new EJBHomeMethodAccessSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32419: {
                        this.server.incRequestIONo();
                        new XMLVerifySlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 24097: {
                        this.server.incRequestSQLNo();
                        new SQLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25502: {
                        new GetSOAPXMLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25503: {
                        new ParseWSDLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 32000: {
                        new TestDBConnectionSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 11001: {
                        new TestSalesForceConnectionSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 11002: {
                        new SalesForceQuerySlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 11003: {
                        new SFparamMetaSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 12001: {
                        new ExcelSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 30158: {
                        new URLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 23868: {
                        new RenameSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 23866: {
                        new ReplaceSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 28929: {
                        new ExportBarcodeSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 30500: {
                        new ServerDirectorySlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 16789: 
                    case 16790: 
                    case 16791: {
                        new DBdistinctSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 15765: {
                        new DBFirstValueSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 18657: {
                        new DBparamMetaSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 18658: {
                        new DBparamFunctionMetaSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25679: {
                        new DBparamTypeSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 23612: {
                        new DBqueryMetaSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25367: {
                        new DataFileMetaSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 28321: 
                    case 28356: 
                    case 28648: 
                    case 28762: 
                    case 28950: 
                    case 28963: {
                        new QBDatabaseConnection(this, this.server, this.socket, this.slaveType).run();
                        break;
                    }
                    case 31001: 
                    case 31002: 
                    case 31003: 
                    case 31004: 
                    case 31005: {
                        new SCHScheduler(this, this.server, this.socket, this.slaveType).run();
                    }
                    case 25332: {
                        new UserLanguageSlave(this, this.server, this.socket, this.slaveType).run();
                        break;
                    }
                    case 25335: {
                        new UserLanguageSlave(this, this.server, this.socket, this.slaveType).run();
                        break;
                    }
                    case 28771: {
                        new QBTableList(this, this.server, this.socket).run();
                        break;
                    }
                    case 28232: {
                        new QBTableInfo(this, this.server, this.socket).run();
                        break;
                    }
                    case 28928: {
                        new QBSQLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 23801: {
                        new DataRegistrySlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 22071: {
                        this.server.incRequestIONo();
                        new ChartExportSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 28816: {
                        this.server.incRequestIONo();
                        new FilterDataFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 24578: {
                        this.server.incRequestIONo();
                        new XMLChartSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 27678: {
                        this.server.incRequestIONo();
                        new XMLTemplateSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 22111: {
                        this.server.incRequestIONo();
                        new CreateChartSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 27587: {
                        this.server.incRequestIONo();
                        new FilterPPSQLSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 29203: {
                        new ImgExportSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 29302: {
                        new ChtExportSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25330: {
                        new DeleteFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 25331: {
                        new DeleteTempFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 26000: {
                        new ReleaseFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 26004: {
                        new FileLockSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 26003: {
                        new ReleaseFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 26001: {
                        new CopyFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 26002: {
                        this.sendWorkingDirectory(this.socket);
                        break;
                    }
                    case 27001: {
                        new CreatePakSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 27002: {
                        new UnpakSlave(this, this.server, this.socket).run();
                        break;
                    }
                    case 28930: {
                        this.server.stopServer();
                        break;
                    }
                    case 10001: 
                    case 10002: 
                    case 10003: {
                        this.server.incRequestIONo();
                        new QbFileOutputStreamSlave(this, this.server, this.socket, this.slaveType).run();
                        break;
                    }
                    case 25333: {
                        new ClassFileSlave(this, this.server, this.socket).run();
                        break;
                    }
                    default: {
                        new DesignerSlave(this, this.server, this.socket).run();
                    }
                }
                if (writeToERESLog && !SaveChart.VERSIONNAME.equals(this.infile) && !SaveReport.VERSIONNAME.equals(this.infile)) {
                    this.details = this.getDetailsInfo();
                    String remoteAddress = this.remoteAddr != null && this.remoteAddr.contains("?") ? this.remoteAddr.substring(0, this.remoteAddr.indexOf(63)) : this.remoteAddr;
                    if (this.details.trim().startsWith("OUT FILE:")) {
                        if (this.details.endsWith(".pak") || this.details.endsWith(".rpt") || this.details.endsWith(".cht") || this.details.endsWith(".tpl") || this.details.endsWith(".pac")) {
                            String detail = "Saved file: " + this.details.substring(this.details.indexOf(58) + 1);
                            ERESLog.writeLog(this.orgUserName, process, remoteAddress, 5, detail);
                        }
                    } else if (process == 23801) {
                        if (this.details.contains("= ADD NODE") || this.details.contains("= REMOVE NODE") || this.details.contains("= EDIT NODE")) {
                            ERESLog.writeLog(this.orgUserName, process, remoteAddress, 5, this.details);
                        }
                    } else {
                        ERESLog.writeLog(this.orgUserName, process, remoteAddress, product, this.details);
                    }
                }
                if (Server.showMonitor) {
                    Server.sm.smui.vThread -= 2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.server.writeLog("[" + this.requestNo + "] " + ex.toString());
                if (Server.showMonitor) {
                    Server.sm.smui.vThread -= 2;
                }
                this.closesocket();
            }
            catch (Error err) {
                err.printStackTrace();
                if (Server.showMonitor) {
                    Server.sm.smui.vThread -= 2;
                }
                this.server.writeLog("[" + this.requestNo + "] " + err.toString());
                this.closesocket();
            }
            try {
                if (!ServerMessage.isLoadBalancer || ServerMessage.backupServer.equals("") || this.slaveType != 22071 && this.slaveType != 29302 && this.slaveType != 26001 && this.slaveType != 23801 && this.slaveType != 25330 && this.slaveType != 25331 && this.slaveType != 1076 && this.slaveType != 28929 && this.slaveType != 29203 && this.slaveType != 10001 && this.slaveType != 10002 && this.slaveType != 10003 && this.slaveType != 20088 && this.slaveType != 26000 && this.slaveType != 23868 && this.slaveType != 23866 && this.slaveType != 20876 && this.slaveType != 25578) break block231;
                ServletConnection con = null;
                try {
                    con = new ServletConnection(ServerMessage.backupServer, ServerMessage.backupPort, this.remoteAddr);
                }
                catch (IOException ex) {
                    try {
                        Thread.sleep(5000L);
                        con = new ServletConnection(ServerMessage.backupServer, ServerMessage.backupPort, this.remoteAddr);
                    }
                    catch (IOException c) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    DataOutputStream dout = new DataOutputStream(con.getOutputStream());
                    dout.writeShort(this.slaveType);
                    dout.writeBoolean(true);
                    if (this.slaveType == 1076) {
                        this.writeExportMessage(dout);
                    } else if (this.slaveType == 22071) {
                        this.writeChartExportMessage(dout);
                    } else if (this.slaveType == 29302) {
                        this.writeChtExportMessage(dout);
                    } else if (this.slaveType == 26001) {
                        this.writeCopyFileMessage(dout);
                    } else if (this.slaveType == 25330) {
                        this.writeDeleteFileName(dout);
                    } else if (this.slaveType == 25331) {
                        this.writeDeleteTempFileName(dout);
                    } else if (this.slaveType == 29203) {
                        this.writeImgExportMessage(dout);
                    } else if (this.slaveType == 20088) {
                        this.writePageViewerHTMLMessage(dout);
                    } else if (this.slaveType == 10001) {
                        this.writeOutputStreamInitializeMessage(dout);
                    } else if (this.slaveType == 10002) {
                        this.writeOuputStreamWriteMessage(dout);
                    } else if (this.slaveType == 10003) {
                        this.writeOutputStreamCloseMessage(dout);
                    } else if (this.slaveType == 26000) {
                        this.writeStreamMessage(dout);
                    } else if (this.slaveType != 26004) {
                        if (this.slaveType == 23868) {
                            this.writeRenameMessage(dout);
                        } else if (this.slaveType == 23866) {
                            this.writeReplaceMessage(dout);
                        } else if (this.slaveType == 28929) {
                            this.writeExportBarcodeMessage(dout);
                        } else if (this.slaveType == 23801) {
                            this.writeStreamMessage(dout);
                        } else if (this.slaveType == 20876) {
                            this.writeStreamMessage(dout);
                        } else if (this.slaveType == 25578) {
                            this.writeStreamMessage(dout);
                        }
                    }
                    dout.write(requestByteArray);
                    dout.flush();
                    dout.close();
                    DataInputStream din = new DataInputStream(con.getInputStream());
                    int c = din.read();
                    while (c != -1) {
                        c = din.read();
                    }
                    din.close();
                } else {
                    ServerMessage.downTime = System.currentTimeMillis();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    String getDetailsInfo() {
        String str = "";
        if (this.infile != null && !this.infile.equals("")) {
            str = " IN FILE: " + this.infile;
        }
        if (this.outfile != null && !this.outfile.equals("")) {
            str = str + " OUT FILE: " + this.outfile;
        }
        if (this.deleteFile != null && !this.deleteFile.equals("")) {
            str = str + " DELETE FILE: " + this.deleteFile;
        }
        if (this.query != null && !this.query.equals("")) {
            str = str + " QUERY: " + this.query;
        }
        if (this.dbInfo != null) {
            str = str + " DBINFO = " + this.dbInfo.getQuery();
        }
        return this.details + str;
    }

    public String getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(String rootFile) {
        this.rootFile = rootFile;
    }

    void closesocket() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWorkingDirectory(IConnection client_socket) {
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(client_socket.getOutputStream());
            IOUtil.writeString(dout, ServerMessage.getWorkingDirectory());
        }
        catch (IOException iOException) {
            CloseUtils.close(dout);
        }
        catch (Throwable throwable) {
            CloseUtils.close(dout);
            throw throwable;
        }
        CloseUtils.close(dout);
        try {
            client_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String checkWorkingDirectory(String fileName) {
        String workingDir;
        if (ServerMessage.eresDir == null || ServerMessage.eresDir.equals("")) {
            return fileName;
        }
        if (ServerMessage.eresDir.indexOf(":\\") > -1) {
            ServerMessage.eresDir = ServerMessage.eresDir.replace('\\', '/');
        }
        if ((workingDir = ServerMessage.getWorkingDirectory()).indexOf(":\\") > -1) {
            workingDir = workingDir.replace('\\', '/');
        }
        if (!ServerMessage.eresDir.equals(workingDir) && fileName.startsWith(ServerMessage.eresDir)) {
            fileName = workingDir + this.infile.substring(ServerMessage.eresDir.length());
        }
        return fileName;
    }
}

