/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class PageViewerHTMLSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    FileOutputStream fstream = null;
    String outputfile;

    public PageViewerHTMLSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    public void run() {
        this.outputfile = this.messageThread.outfile;
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), 20088);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return;
        }
        this.outputfile = this.messageThread.absolutePath ? this.messageThread.outfile : this.server.getPath(this.messageThread.outfile);
        this.createHtmlFile(this.outputfile, this.messageThread.outfile, this.messageThread.useSwing);
        this.cleanup(0, "Finish.\n");
    }

    private void createHtmlFile(String outputFileName, String originalName, boolean useSwing) {
        String jarFile;
        String codeClass;
        PrintWriter pWriter;
        String truncatedName = outputFileName.substring(0, outputFileName.length() - 5);
        int ind1 = (truncatedName = truncatedName.replace('\\', '/')).lastIndexOf(47);
        String basename = ind1 >= 0 ? truncatedName.substring(ind1 + 1) + ".html" : truncatedName + ".html";
        String htmlFileName = this.server.getPath(this.server.getHTMLDirectory() + basename);
        try {
            FileOutputStream fout = new FileOutputStream(htmlFileName);
            pWriter = new PrintWriter(fout);
        }
        catch (Exception e) {
            Server.println(this.server, "quadbase.reportdesigner.server.ExportSlave: ERROR");
            e.printStackTrace();
            return;
        }
        pWriter.println("<html>");
        pWriter.println("<body>");
        if (!useSwing) {
            codeClass = "quadbase.reportdesigner.PageViewer.Viewer.class";
            jarFile = "PageViewer";
        } else {
            codeClass = "quadbase.reportdesigner.PageViewer.swing.Viewer.class";
            jarFile = "SwingPageViewer";
        }
        pWriter.println("<applet code=\"" + codeClass + "\" width=100% height=100%");
        pWriter.println("archive=\"../lib/" + jarFile + ".jar,../lib/qblicense.jar\">");
        pWriter.println("<PARAM name=\"filename\" value=\"" + originalName + "\">");
        if (ServerMessage.isServlet()) {
            pWriter.println("<PARAM name=\"comm_protocol\" value=\"servlet\">");
            pWriter.println("<PARAM name=\"comm_url\" value=\"" + ServerMessage.getConnectServlet() + "\">");
            pWriter.println("<PARAM name=\"servlet_context\" value=\"" + ServerMessage.getServletContext() + "\">");
        }
        pWriter.println("</applet>");
        pWriter.println("</body>");
        pWriter.println("</html>");
        pWriter.flush();
        pWriter.close();
    }

    void cleanup(int code, String err) {
        this.acknowledge(code, err);
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nOutput : " + this.outputfile + " -- ";
    }
}

