/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public abstract class ParamQuerySlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public ParamQuerySlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    abstract int getMessageType();

    abstract void slaveBody() throws Exception;

    abstract void sendReply() throws Exception;

    abstract String getArguments();

    public void run() {
        if (this.authenticate(this.getMessageType())) {
            try {
                ConnectionBuffer connectionBuffer = this.server.getConnectionBuffer();
                if (connectionBuffer != null && ConnectionBuffer.getBufferSize() <= 1) {
                    connectionBuffer.close();
                }
                this.slaveBody();
                this.sendReply();
            }
            catch (Exception ex) {
                this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
            }
        }
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.getArguments() + " -- ";
    }
}

