/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.Vector;
import quadbase.common.client.ReadDatabase;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class QBDatabaseConnection {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    DataBuffer iBuffer;
    int slaveType;
    String result;
    int tableFormat = 0;
    String tableName;

    public QBDatabaseConnection(MessageThread messageThread, Server server, IConnection socket, int slaveType) {
        this.messageThread = messageThread;
        this.slaveType = slaveType;
        this.server = server;
        this.iBuffer = messageThread.dataBuffer;
        this.client_socket = socket;
        this.tableFormat = messageThread.format;
        this.tableName = messageThread.tableName;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(this.slaveType)) {
            try {
                Connection conn;
                DataBuffer dataBuffer = this.server.getConnectionBuffer().getDataBuffer(this.iBuffer);
                if (dataBuffer == null || (conn = dataBuffer.getConnection()) == null) {
                    this.server.getConnectionBuffer().addData(this.iBuffer, 1);
                    conn = this.iBuffer.createConnection();
                }
                ReadDatabase databaseConnection = new ReadDatabase(conn);
                switch (this.slaveType) {
                    case 28321: {
                        this.result = databaseConnection.getProductName();
                        break;
                    }
                    case 28762: {
                        this.result = databaseConnection.getNumericFunctions();
                        break;
                    }
                    case 28648: {
                        this.result = databaseConnection.getSystemFunctions();
                        break;
                    }
                    case 28963: {
                        this.result = databaseConnection.getTimeDateFunctions();
                        break;
                    }
                    case 28356: {
                        this.result = databaseConnection.getStringFunctions();
                        break;
                    }
                    case 28950: {
                        Vector fkVector = databaseConnection.getKeyConstraints(this.tableFormat, this.tableName);
                        this.sendForeignKeys(fkVector);
                    }
                }
                if (this.slaveType != 28950) {
                    this.sendReply();
                }
            }
            catch (Exception ex) {
                this.cleanup(3, "Fail to connect to database :" + ex.toString() + "\n");
            }
        }
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        IOUtil.writeString(dout, this.result);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void sendForeignKeys(Vector foreignKeyVect) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(foreignKeyVect.size());
        for (int i = 0; i < foreignKeyVect.size(); ++i) {
            Vector v = (Vector)foreignKeyVect.elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                IOUtil.writeString(dout, (String)v.elementAt(j));
            }
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

