/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.network.HeartBeatServer;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.server.BufferedResultSet;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.CleanUpThread;
import quadbase.util.IResultSet;
import quadbase.util.QueryResultSet;

public class QBSQLSlave {
    private static final Logger LOGGER = Logger.getLogger(QBSQLSlave.class.getName());
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    int slaveType;
    DataSet[] dataSet = new DataSet[0];
    Object[][] column;
    DataBuffer iBuffer;
    String query;
    int displayRow;
    int startIndex;
    int totalRows = -1;
    private int timeout = -1;
    private QueryInParamSet inParamSet = null;
    private Statement currentStatement;

    public QBSQLSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.iBuffer = messageThread.dataBuffer;
        this.query = messageThread.query;
        this.startIndex = messageThread.startIndex;
        this.displayRow = messageThread.displayRow;
        this.timeout = messageThread.packageLen;
        this.inParamSet = messageThread.inParamSet;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.authenticate(28928)) {
            try (HeartBeatServer heartBeatServer = null;){
                int idx;
                Connection conn;
                heartBeatServer = new HeartBeatServer(this.client_socket.getOutputStream());
                heartBeatServer.start();
                heartBeatServer.setConnectionClosedListener(new HeartBeatServer.ConnectionClosedListener(){

                    @Override
                    public void onConnectionClosed() {
                        QBSQLSlave.this.cancelCurrentQuery();
                    }
                });
                DataBuffer dataBuffer = this.server.getConnectionBuffer().getDataBuffer(this.iBuffer);
                if (dataBuffer == null || (conn = dataBuffer.getConnection()) == null) {
                    this.server.getConnectionBuffer().addData(this.iBuffer, 1);
                    conn = this.iBuffer.createConnection();
                    dataBuffer = this.iBuffer;
                }
                this.dataSet = (idx = dataBuffer.getIndex(this.query, this.inParamSet)) >= 0 && this.column != null ? dataBuffer.getValues(idx, this.startIndex, this.displayRow) : this.getValues(conn, this.query, this.inParamSet, dataBuffer);
                this.iBuffer = dataBuffer;
                heartBeatServer.close();
                this.sendReply();
            }
        }
        this.iBuffer.close();
    }

    DataSet[] getValues(Connection conn, String query, QueryInParamSet inSet, DataBuffer dataBuffer) throws Exception {
        query = query.trim();
        query = QueryParser.removeComments(query);
        Statement stmt = null;
        String productName = "";
        try {
            productName = conn.getMetaData().getDatabaseProductName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolean isResult;
            if (QueryParser.isCallableStmt(query)) {
                if (inSet != null) {
                    query = inSet.convertToJDBCquery(query);
                }
                CallableStatement callstmt = conn.prepareCall(query);
                if (inSet != null) {
                    inSet.setStmtValue(callstmt);
                }
                try {
                    if (this.timeout > 0) {
                        callstmt.setQueryTimeout(this.timeout);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                isResult = callstmt.execute();
                stmt = callstmt;
            } else if (inSet == null) {
                stmt = conn.createStatement();
                try {
                    if (this.timeout > 0) {
                        stmt.setQueryTimeout(this.timeout);
                    }
                }
                catch (Exception callstmt) {
                    // empty catch block
                }
                this.currentStatement = stmt;
                isResult = stmt.execute(query);
            } else {
                query = inSet.convertToJDBCquery(query);
                PreparedStatement pStmt = conn.prepareStatement(query);
                this.currentStatement = pStmt;
                stmt = pStmt;
                inSet.setStmtValue(pStmt);
                try {
                    if (this.timeout > 0) {
                        stmt.setQueryTimeout(this.timeout);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                isResult = pStmt.execute();
            }
            while (!isResult) {
                if (stmt.getUpdateCount() == -1) {
                    stmt.close();
                    throw new SQLException("No result set returned !");
                }
                isResult = stmt.getMoreResults();
            }
        }
        catch (Exception e) {
            CloseUtils.close(stmt);
            throw e;
        }
        ResultSetMetaData rsMetaData = null;
        ResultSet rs = stmt.getResultSet();
        if (rs != null) {
            rsMetaData = rs.getMetaData();
            int cLen = rsMetaData.getColumnCount();
            this.column = new Object[3][cLen];
            boolean isHSQL = productName.toUpperCase().contains("HSQL");
            boolean isJTDS = conn.getMetaData() != null && conn.getMetaData().getDriverName().toUpperCase().contains("JTDS");
            boolean isHive = productName.toUpperCase().contains("HIVE");
            int expCounter = 0;
            for (int j = 1; j < cLen + 1; ++j) {
                String columnName = rsMetaData.getColumnLabel(j);
                if (isHive && columnName != null) {
                    columnName = columnName.replaceAll(".*\\.", "");
                }
                this.column[0][j - 1] = columnName;
                if (isHSQL && this.column[0][j - 1].equals("")) {
                    this.column[0][j - 1] = "Expression_" + expCounter;
                    ++expCounter;
                }
                if (isJTDS && rsMetaData.getColumnType(j) == 12 && rsMetaData.getColumnDisplaySize(j) == 10) {
                    this.column[1][j - 1] = 91;
                    this.column[2][j - 1] = "date";
                    continue;
                }
                this.column[1][j - 1] = rsMetaData.getColumnType(j);
                this.column[2][j - 1] = rsMetaData.getColumnTypeName(j);
            }
        }
        QueryResultSet resultRS = new QueryResultSet(stmt, productName);
        return this.makeBufferedResultSet(dataBuffer, resultRS, stmt);
    }

    public DataSet[] makeBufferedResultSet(DataBuffer dataBuffer, IResultSet resultRS, Statement statement) throws Exception {
        if (dataBuffer.nBuffer == 0) {
            BufferedResultSet brs = new BufferedResultSet(this.query, this.inParamSet, resultRS);
            DataSet[] retvect = brs.getValue(this.startIndex, this.displayRow);
            this.totalRows = brs.getRowCount();
            statement.close();
            return retvect;
        }
        dataBuffer.addData(this.query, this.inParamSet, resultRS, 1);
        BufferedResultSet brs = dataBuffer.bufferedResultSet[dataBuffer.getIndex(this.query, this.inParamSet)];
        DataSet[] retvect = dataBuffer.getValues(dataBuffer.getIndex(this.query, this.inParamSet), this.startIndex, this.displayRow);
        this.totalRows = brs.getRowCount();
        return retvect;
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void sendReply() throws Exception {
        int j;
        int endIndex;
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        new CleanUpThread(this.dataSet).start();
        dout.writeInt(0);
        int nCol = this.dataSet.length;
        int nRow = 0;
        if (nCol > 0) {
            nRow = this.dataSet[0].size();
        }
        if (this.displayRow < 0) {
            this.displayRow = nRow - (this.startIndex >= 0 ? this.startIndex : 0);
        }
        if (this.startIndex >= 0) {
            this.displayRow = this.displayRow < 0 ? nRow - this.startIndex : (nRow < (endIndex = this.startIndex + this.displayRow) ? nRow - this.startIndex : this.displayRow);
        } else if (this.displayRow < 0) {
            this.displayRow = nRow;
            this.startIndex = 0;
        } else {
            int tmp = nRow % this.displayRow;
            if (tmp != 0) {
                this.displayRow = tmp;
            }
            this.startIndex = nRow - this.displayRow;
        }
        endIndex = this.startIndex + this.displayRow;
        dout.writeInt(nRow < endIndex ? nRow - this.startIndex + 3 : this.displayRow + 3);
        dout.writeInt(nCol);
        for (int i = this.startIndex; i < endIndex && i < nRow; ++i) {
            for (int j2 = 0; j2 < nCol; ++j2) {
                Object obj = this.dataSet[j2].elementAt(i);
                IOUtil.writeLongString(dout, DataType.write(obj));
            }
        }
        if (this.iBuffer.getIndex(this.query, this.inParamSet) >= 0) {
            dout.writeInt(this.iBuffer.getRowCount(this.iBuffer.getIndex(this.query, this.inParamSet)));
        } else {
            dout.writeInt(this.totalRows);
        }
        for (j = 0; j < nCol; ++j) {
            IOUtil.writeString(dout, this.column[0][j].toString());
        }
        for (j = 0; j < nCol; ++j) {
            dout.writeInt((Integer)this.column[1][j]);
        }
        for (j = 0; j < nCol; ++j) {
            IOUtil.writeString(dout, this.column[2][j].toString());
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }

    void cancelCurrentQuery() {
        if (this.currentStatement != null) {
            LOGGER.finest("Canceling query");
            try {
                this.currentStatement.cancel();
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, "Failed to cancel query", e);
            }
        }
    }
}

