/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.util.Date;
import quadbase.common.client.ReadDatabase;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class QBTableInfo {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    int slaveType;
    String tableName;
    Object[][] obj;
    DataBuffer iBuffer;
    boolean isQuery;

    public QBTableInfo(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.iBuffer = messageThread.dataBuffer;
        this.tableName = messageThread.tableName;
        this.isQuery = messageThread.preProcessData;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(28232)) {
            try {
                Connection conn;
                DataBuffer dataBuffer = this.server.getConnectionBuffer().getDataBuffer(this.iBuffer);
                if (dataBuffer == null || (conn = dataBuffer.getConnection()) == null) {
                    this.server.getConnectionBuffer().addData(this.iBuffer, 1);
                    conn = this.iBuffer.createConnection();
                }
                ReadDatabase databaseConnection = new ReadDatabase(conn);
                this.obj = databaseConnection.getTableInfo(this.tableName, this.isQuery);
                this.sendReply();
            }
            catch (Exception ex) {
                this.cleanup(3, "Fail to connect to database :" + ex.toString() + "\n");
            }
        }
        this.iBuffer.close();
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.obj.length);
        for (Object[] element : this.obj) {
            IOUtil.writeString(dout, element[0].toString());
            dout.writeInt((Integer)element[1]);
            IOUtil.writeString(dout, element[2].toString());
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            try {
                this.client_socket.getOutputStream().flush();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

