/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.Vector;
import quadbase.common.client.ReadDatabase;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IOUtil;

public class QBTableList {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    int slaveType;
    String[] type;
    Vector vec;
    DataBuffer iBuffer;
    private boolean useStream = false;
    private int format = 0;

    public QBTableList(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.iBuffer = messageThread.dataBuffer;
        this.type = messageThread.tableType;
        this.useStream = messageThread.usedURL;
        this.format = messageThread.format;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(28771)) {
            try {
                Connection conn;
                DataBuffer dataBuffer = this.server.getConnectionBuffer().getDataBuffer(this.iBuffer);
                if (dataBuffer == null || (conn = dataBuffer.getConnection()) == null) {
                    this.server.getConnectionBuffer().addData(this.iBuffer, 1);
                    conn = this.iBuffer.createConnection();
                }
                ReadDatabase databaseConnection = new ReadDatabase(conn);
                if (!this.useStream) {
                    this.vec = databaseConnection.getTableList(this.type, this.format);
                    this.sendReply();
                } else {
                    this.sendReplyStream(databaseConnection.getTableListStream(this.type, this.format));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.cleanup(3, "Fail to connect to database :" + ex.toString() + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.vec.size());
        for (int i = 0; i < this.vec.size(); ++i) {
            IOUtil.writeString(dout, (String)this.vec.elementAt(i));
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().write(0);
            try {
                this.client_socket.getOutputStream().flush();
            }
            catch (Exception i) {}
        }
        catch (Exception ex) {
            CloseUtils.close(this.client_socket);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReplyStream(DataInputStream in) throws Exception {
        DataOutputStream dout = null;
        try {
            try {
                dout = new DataOutputStream(this.client_socket.getOutputStream());
                dout.writeInt(0);
                while (true) {
                    IOUtil.writeString(dout, IOUtil.readString(in, true));
                }
            }
            catch (Exception exception) {
                CloseUtils.close(dout);
                CloseUtils.close(this.client_socket);
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(dout);
            CloseUtils.close(this.client_socket);
            throw throwable;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        CloseUtils.close(this.client_socket);
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

