/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IOUtil;

public class QbFileOutputStreamSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    private static Hashtable hashtable = null;
    private int operation;

    public QbFileOutputStreamSlave(MessageThread messageThread, Server server, IConnection socket, int op) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.operation = op;
    }

    public void run() {
        this.server.userCounter(true);
        if (this.operation == 10001) {
            this.doInitialize();
        } else if (this.operation == 10002) {
            this.doWrite();
        } else if (this.operation == 10003) {
            this.doClose();
        }
    }

    private synchronized void doInitialize() {
        Object obj;
        String filename = this.messageThread.outfile;
        boolean append = this.messageThread.transposeData;
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), 1076);
            if (!mess.equals("OK")) {
                this.cleanup(mess, false);
                return;
            }
        }
        catch (Exception ex) {
            this.cleanup(ex.toString(), false);
            return;
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((obj = hashtable.get(filename)) != null) {
            this.cleanup("Failed to write to file:" + filename + ".\nThe file is already opened by a user.", false);
        } else {
            try {
                FileOutputStream fstream = new FileOutputStream(this.server.getPath(filename), append);
                hashtable.put(filename, fstream);
                this.cleanup("Successfully initialized file, " + filename + ".", true);
            }
            catch (Exception ex) {
                this.cleanup("Failed to write to file:" + filename + ".\n" + ex.toString(), false);
            }
        }
    }

    private void doWrite() {
        Object obj;
        String filename = this.messageThread.outfile;
        byte[] bytearray = new byte[this.messageThread.packageLen];
        try {
            DataInputStream instream = new DataInputStream(this.client_socket.getInputStream());
            instream.readFully(bytearray, 0, this.messageThread.packageLen);
        }
        catch (IOException ex) {
            this.cleanup("Failed to write to file:" + filename + ".\n" + ex.toString(), false);
            return;
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((obj = hashtable.get(filename)) == null || !(obj instanceof FileOutputStream)) {
            this.cleanup("Failed to write to file:" + filename + ".\nAn internal error has ocurred.", false);
        } else {
            try {
                FileOutputStream filestream = (FileOutputStream)obj;
                filestream.write(bytearray);
                this.cleanup("Successfully written to file, " + filename + ".", true);
            }
            catch (Exception ex) {
                this.cleanup("Failed to write to file:" + filename + ".\n" + ex.toString(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        Object obj;
        String filename = this.messageThread.outfile;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((obj = hashtable.get(filename)) == null || !(obj instanceof FileOutputStream)) {
            this.cleanup("File already closed, " + filename + ".", true);
        } else {
            try {
                FileOutputStream filestream = (FileOutputStream)obj;
                filestream.flush();
                filestream.close();
                this.cleanup("Successfully closed file, " + filename + ".", true);
            }
            catch (Exception ex) {
                this.cleanup("Failed to write to file:" + filename + ".\n" + ex.toString(), false);
            }
            finally {
                hashtable.remove(filename);
            }
        }
    }

    private void cleanup(String err, boolean success) {
        this.acknowledge(err, success);
        CloseUtils.close(this.client_socket);
        this.server.writeLog(this.getHeader() + err, !success);
        this.server.userCounter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(String s, boolean success) {
        DataOutputStream dout2;
        block5: {
            dout2 = null;
            try {
                dout2 = new DataOutputStream(this.client_socket.getOutputStream());
                if (success) {
                    dout2.writeInt(0);
                    break block5;
                }
                dout2.writeInt(6);
                IOUtil.writeString(dout2, s);
            }
            catch (Exception ex) {
                try {
                    this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
                }
                catch (Throwable throwable) {
                    CloseUtils.close(dout2);
                    throw throwable;
                }
                CloseUtils.close(dout2);
            }
        }
        CloseUtils.close(dout2);
    }

    private String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\n -- ";
    }
}

