/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.util.Vector;
import quadbase.chart.CGraphics;
import quadbase.chart.ImageMapNode;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.common.awt.Arc;
import quadbase.util.PickData;
import quadbase.util.internal.IOUtil;

public class QbImageMap {
    protected Vector vec;
    int winWidth;
    int winHeight;
    DataOutputStream out;

    public QbImageMap(Vector vec, DataOutputStream out) {
        this.vec = vec;
        this.out = out;
    }

    private void writeArray(int[] array) {
        try {
            if (array == null) {
                this.out.writeShort(0);
                return;
            }
            this.out.writeShort(array.length);
            for (int element : array) {
                this.out.writeShort(element);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void exportMap(boolean isDrillDown, PickData[] pickData, boolean isFieldDrillDown, String fileName) throws Exception {
        if (this.vec != null) {
            String prev = "";
            if (isDrillDown) {
                int level = 1;
                if (pickData != null) {
                    level = pickData.length + 1;
                }
                prev = level + "$_$";
                if (pickData != null) {
                    for (PickData element : pickData) {
                        prev = prev + CGraphics.getDrillDownLink((PickData)element).link;
                    }
                }
            }
            if (isFieldDrillDown) {
                prev = "FILENAME=" + fileName;
            }
            for (int i = this.vec.size() - 1; i >= 0; --i) {
                ImageMapNode node = (ImageMapNode)this.vec.elementAt(i);
                String nodeLink = prev + node.link;
                if (node.obj instanceof Face) {
                    Face f = (Face)node.obj;
                    this.out.writeShort(1);
                    this.out.writeShort(4);
                    this.out.writeShort(f.v1.screen_x);
                    this.out.writeShort(f.v2.screen_x);
                    this.out.writeShort(f.v3.screen_x);
                    this.out.writeShort(f.v4.screen_x);
                    this.out.writeShort(4);
                    this.out.writeShort(f.v1.screen_y);
                    this.out.writeShort(f.v2.screen_y);
                    this.out.writeShort(f.v3.screen_y);
                    this.out.writeShort(f.v4.screen_y);
                    this.out.writeShort(4);
                } else if (node.obj instanceof Rectangle) {
                    Rectangle r = (Rectangle)node.obj;
                    this.out.writeShort(2);
                    this.out.writeShort(r.x);
                    this.out.writeShort(r.y);
                    this.out.writeShort(r.width);
                    this.out.writeShort(r.height);
                } else if (node.obj instanceof Polygon) {
                    this.out.writeShort(1);
                    Polygon p = (Polygon)node.obj;
                    this.writeArray(p.xpoints);
                    this.writeArray(p.ypoints);
                    this.out.writeShort(p.npoints);
                } else if (node.obj instanceof Arc) {
                    Arc ar = (Arc)node.obj;
                    this.out.writeShort(3);
                    this.out.writeShort(ar.x);
                    this.out.writeShort(ar.y);
                    this.out.writeShort(ar.w);
                    this.out.writeShort(ar.h);
                    this.out.writeFloat((float)((double)ar.startangle * Math.PI / 180.0));
                    this.out.writeFloat((float)((double)(ar.startangle + ar.angle) * Math.PI / 180.0));
                }
                IOUtil.writeString(this.out, node.target);
                int hintIndex = node.hint.lastIndexOf(10);
                if (hintIndex < 0) {
                    IOUtil.writeString(this.out, node.hint);
                    IOUtil.writeString(this.out, "");
                } else {
                    IOUtil.writeString(this.out, node.hint.substring(0, hintIndex));
                    IOUtil.writeString(this.out, node.hint.substring(hintIndex + 1));
                }
                IOUtil.writeString(this.out, nodeLink);
            }
        }
        this.out.writeShort(0);
    }
}

