/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.File;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import quadbase.common.util.internal.QbDebug;
import quadbase.reportdesigner.ReportAPI.QbReport;

public class QbObjectPool {
    static final long CLEANUP_TIME = 86400000L;
    static int CAPACITY = 30;
    boolean DEBUG = true;
    Vector pool = new Vector();
    CleanupThread ct;

    public QbObjectPool() {
        QbObjectPool.debug("CAPACITY = " + CAPACITY);
        this.ct = new CleanupThread(this, 86400000L);
        this.ct.start();
    }

    public static void setCapacity(int c) {
        CAPACITY = c;
    }

    public static int capacity() {
        try {
            return CAPACITY;
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private static void debug(String msg) {
        QbDebug.println(2, "ConnectionPool - " + msg);
    }

    static boolean initDEBUG() {
        File debugFile = new File("debug_conn_pool.conf");
        return debugFile.exists();
    }

    public int size() {
        return this.pool.size();
    }

    public synchronized void cleanup() {
        QbObjectPool.debug("running cleanup");
        Vector<QbObjectDetail> newPool = new Vector<QbObjectDetail>();
        for (QbObjectDetail cd : this.pool) {
            if (!cd.isUsed()) continue;
            newPool.add(cd);
        }
        this.pool = newPool;
        QbObjectPool.debug("cleanup finished");
    }

    public Object[] getObject(String rptLoc, Properties props, boolean isReport, boolean forceAllocate) throws Exception {
        QbObjectPool.debug("size [" + this.size() + "] capacity [" + QbObjectPool.capacity() + "]");
        try {
            if (QbObjectPool.capacity() <= 0) {
                return this.allocateObject(rptLoc, props, isReport, false);
            }
            if (forceAllocate) {
                return this.allocateObject(rptLoc, props, isReport, true);
            }
        }
        catch (SQLException e) {
            QbObjectPool.debug("failed to allocate object");
            return this.getFromPool(rptLoc, props, isReport);
        }
        return this.getFromPool(rptLoc, props, isReport);
    }

    public void close(Object obj) {
        for (QbObjectDetail cd : this.pool) {
            if (cd.obj != obj) continue;
            cd.setUsed(false);
            QbObjectPool.debug("decrementing pool: [" + cd.url + "] use = " + cd.isUsed());
            return;
        }
    }

    Object[] allocateObject(String url, Properties info, boolean isReport, boolean addToPool) throws Exception {
        Object[] c = new Object[]{this.createObject(url, info, isReport), Boolean.TRUE};
        QbObjectPool.debug("allocating new object [" + url + ":" + c[0] + "]");
        if (addToPool) {
            this.pool.add(new QbObjectDetail(c[0], url, info));
            QbObjectPool.debug("adding connection to pool");
        }
        return c;
    }

    Object createObject(String url, Properties info, boolean isReport) throws Exception {
        QbObjectPool.debug("NEW QBREPORT..............................");
        return new QbReport((Object)null, url, (Object[])null, (Object[])null, info);
    }

    Object[] getFromPool(String url, Properties info, boolean isReport) throws Exception {
        QbObjectPool.debug("looking for object from pool [" + url + "]");
        Object[] c = new Object[2];
        for (QbObjectDetail cd : this.pool) {
            File file = new File(url);
            if (cd.lastModified < file.lastModified()) {
                return this.replaceFromPool(url, info, isReport);
            }
            if (isReport && !cd.info.equals(info) || !cd.url.equals(url) || cd.obj == null || (c[0] = cd.setUsed(true)) == null) continue;
            QbObjectPool.debug("using object from pool [" + url + "] use = " + cd.obj);
            c[1] = Boolean.FALSE;
            return c;
        }
        return this.replaceFromPool(url, info, isReport);
    }

    Object[] replaceFromPool(String url, Properties info, boolean isReport) throws Exception {
        Object[] c = this.allocateObject(url, info, isReport, false);
        if (this.size() < QbObjectPool.capacity()) {
            this.pool.add(new QbObjectDetail(c[0], url, info));
            QbObjectPool.debug("adding connection to pool");
            return c;
        }
        for (QbObjectDetail cd : this.pool) {
            if (cd.isUsed()) continue;
            return this.replace(cd, url, info, c[0]);
        }
        QbObjectPool.debug("pool is over capacity limit, allocating new connection outside of pool");
        return c;
    }

    synchronized Object[] replace(QbObjectDetail cd, String url, Properties info, Object newObj) throws Exception {
        QbObjectPool.debug("replacing from pool");
        cd.obj = newObj;
        cd.url = url;
        cd.info = info;
        cd.setUsed(true);
        Object[] c = new Object[]{cd.obj, Boolean.TRUE};
        return c;
    }

    class CleanupThread
    extends Thread {
        QbObjectPool conPool;
        long myInterval;
        boolean myState = true;

        CleanupThread(QbObjectPool cp, long interval) {
            this.setDaemon(true);
            this.conPool = cp;
            this.myInterval = interval;
        }

        @Override
        public void run() {
            while (this.myState) {
                try {
                    Thread.sleep(this.myInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.conPool.cleanup();
            }
        }

        void setState(boolean state) {
            this.myState = state;
        }
    }

    class QbObjectDetail {
        boolean use = false;
        Object obj;
        String url;
        Properties info;
        long lastModified;

        QbObjectDetail(Object object, String url, Properties dbinfo) {
            this.obj = object;
            this.url = url;
            this.info = dbinfo;
            this.lastModified = new File(url).lastModified();
            this.use = true;
        }

        boolean isUsed() {
            return this.use;
        }

        synchronized Object setUsed(boolean b) {
            if (this.use && b) {
                return null;
            }
            this.use = b;
            return this.obj;
        }
    }
}

