/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;

public class ReleaseFileSlave
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(ReleaseFileSlave.class.getName());
    String infile;
    Server server;
    IConnection client_socket;
    String machine = null;
    boolean acknowledge = true;

    public ReleaseFileSlave(MessageThread messageThread, Server server, IConnection socket) {
        super("ReleaseFileSlave");
        this.infile = messageThread.infile;
        this.machine = messageThread.remoteAddr;
        this.server = server;
        this.client_socket = socket;
    }

    public ReleaseFileSlave(String ifile, Server server, IConnection socket) {
        super("ReleaseFileSlave");
        this.infile = ifile;
        this.server = server;
        this.client_socket = socket;
        this.acknowledge = false;
    }

    public ReleaseFileSlave(Server server, String remoteAddr) {
        super("ReleaseFileSlave");
        this.server = server;
        this.machine = remoteAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Hashtable<String, String> hashtable = this.server.lockedFiles;
        synchronized (hashtable) {
            this.releaseFileLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFileLock() {
        int code;
        block15: {
            code = 6;
            LOGGER.finest(" -- RELEASE FILE LOCK START - machine - " + this.machine + " --");
            if (this.machine == null) {
                try {
                    String absPath = new File(this.server.getPath(this.infile)).getAbsolutePath().toUpperCase();
                    LOGGER.finest("AbsPath - " + absPath + " - infile - " + this.infile);
                    String removed = this.server.lockedFiles.get(absPath);
                    LOGGER.finest("Object to remove - " + removed);
                    if (removed != null && this.client_socket.getPeerAddress().equals(removed)) {
                        this.server.lockedFiles.remove(absPath);
                        LOGGER.finest("Releasing lock success - absPath - " + absPath);
                        code = 0;
                        break block15;
                    }
                    if (removed == null) {
                        LOGGER.finest("No lock there");
                        code = 0;
                        LOGGER.finest("Releasing lock success");
                        break block15;
                    }
                    LOGGER.finest("Failure - peer address - " + this.client_socket.getPeerAddress() + " not equal to removed - " + removed);
                    code = 6;
                }
                catch (Exception exc) {
                    LOGGER.log(Level.FINEST, "FAILURE - ", exc);
                    exc.printStackTrace();
                }
            } else {
                try {
                    Enumeration<String> enum1 = this.server.lockedFiles.keys();
                    while (enum1.hasMoreElements()) {
                        String key = enum1.nextElement();
                        String absPath = new File(this.server.getPath(this.infile)).getAbsolutePath().toUpperCase().replace('\\', '/');
                        if (absPath != null && !key.equalsIgnoreCase(absPath)) continue;
                        String lockMachine = this.server.lockedFiles.get(key);
                        int idx = lockMachine.indexOf(63);
                        if (idx < 0) {
                            LOGGER.finest("lockMachine contains (?) - false");
                            LOGGER.finest("lockMachine - " + lockMachine + ", machine - " + this.machine);
                            if (!this.machine.equals(lockMachine)) continue;
                            this.server.lockedFiles.remove(key);
                            LOGGER.finest("key - " + key + " removed from server.lockedFiles");
                            continue;
                        }
                        lockMachine = lockMachine.substring(0, idx);
                        LOGGER.finest("lockMachine - " + lockMachine + ", machine - " + this.machine);
                        if (this.machine.startsWith(lockMachine)) {
                            this.server.lockedFiles.remove(key);
                            LOGGER.finest("key - " + key + " removed from server.lockedFiles");
                        }
                        LOGGER.finest("Releasing lock success - key - " + key);
                    }
                    code = 0;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "FAILURE - ", e);
                    e.printStackTrace();
                    code = 6;
                }
            }
        }
        if (this.acknowledge && this.client_socket != null) {
            DataOutputStream dout = null;
            try {
                dout = new DataOutputStream(this.client_socket.getOutputStream());
                dout.writeInt(code);
            }
            catch (Exception exception) {
                CloseUtils.close(dout);
                CloseUtils.close(this.client_socket);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout);
                CloseUtils.close(this.client_socket);
                throw throwable;
            }
            CloseUtils.close(dout);
            CloseUtils.close(this.client_socket);
        }
        LOGGER.finest("-- RELEASE FILE LOCK END - machine - " + this.machine + " --");
        this.clearOverridedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOverridedFiles() {
        if (this.infile != null) {
            Object obj = this.server.overrideFiles.get(this.infile);
            if (this.machine == null) {
                return;
            }
            if (obj != null) {
                Vector mList = (Vector)obj;
                for (int i = mList.size() - 1; i >= 0; --i) {
                    if (!mList.elementAt(i).equals(this.machine)) continue;
                    mList.remove(i);
                }
                if (mList.size() == 0) {
                    this.server.overrideFiles.remove(this.infile);
                } else {
                    this.server.overrideFiles.put(this.infile, mList);
                }
            }
        } else {
            this.removeFromOverrideTables(this.machine);
        }
        Vector<String> oldOvMachNameList = new Vector<String>();
        Enumeration enumOT = this.server.overrideTimeTable.keys();
        long currTime = System.currentTimeMillis();
        while (enumOT.hasMoreElements()) {
            String machName = (String)enumOT.nextElement();
            long recTime = (Long)this.server.overrideTimeTable.get(machName);
            if (currTime - recTime <= 28800000L) continue;
            oldOvMachNameList.add(machName);
        }
        for (int i = 0; i < oldOvMachNameList.size(); ++i) {
            String om = (String)oldOvMachNameList.elementAt(i);
            Hashtable hashtable = this.server.overrideFiles;
            synchronized (hashtable) {
                this.removeFromOverrideTables(om);
                continue;
            }
        }
    }

    private void removeFromOverrideTables(String machineStr) {
        if (machineStr == null) {
            machineStr = this.client_socket.getPeerAddress();
        }
        Enumeration keys = this.server.overrideFiles.keys();
        Object obj = this.server.overrideTimeTable.get(machineStr);
        if (obj != null) {
            this.server.overrideTimeTable.remove(machineStr);
        }
        while (keys.hasMoreElements()) {
            String lockedFileName = (String)keys.nextElement();
            Vector mList = (Vector)this.server.overrideFiles.get(lockedFileName);
            for (int i = mList.size() - 1; i >= 0; --i) {
                if (!machineStr.equals(mList.elementAt(i))) continue;
                mList.remove(i);
            }
            if (mList.size() == 0) {
                this.server.overrideFiles.remove(lockedFileName);
                continue;
            }
            this.server.overrideFiles.put(lockedFileName, mList);
        }
    }
}

