/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;

public class ReplaceSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public ReplaceSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.authenticate(23868)) {
            FileReader infile = null;
            BufferedReader input = null;
            FileWriter outfile = null;
            try {
                infile = new FileReader(this.server.getPath(this.messageThread.infile));
                input = new BufferedReader(infile);
                outfile = new FileWriter(this.server.getPath(this.messageThread.outfile));
                String s = input.readLine();
                boolean doneReplace = false;
                while ((s = input.readLine()) != null) {
                    if (!s.endsWith(this.messageThread.oldStr) || doneReplace) {
                        outfile.write(s + "\n");
                        continue;
                    }
                    outfile.write(this.messageThread.newStr + "\n");
                    doneReplace = true;
                }
                outfile.flush();
                this.sendReply();
            }
            catch (Exception ex) {
                try {
                    Server.println(this.server, "No file found");
                    this.cleanup(3, "Server failed to replace the string:" + ex.toString() + "\n");
                }
                catch (Throwable throwable) {
                    CloseUtils.close(input);
                    CloseUtils.close(infile);
                    CloseUtils.close(outfile);
                    throw throwable;
                }
                CloseUtils.close(input);
                CloseUtils.close(infile);
                CloseUtils.close(outfile);
            }
            CloseUtils.close(input);
            CloseUtils.close(infile);
            CloseUtils.close(outfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            CloseUtils.close(this.client_socket);
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        CloseUtils.close(this.client_socket);
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

