/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

public class ReplacementPolicy {
    int nBuffer;
    boolean[] isEmpty;
    int[] priority;
    private int armIndex;
    static final int PriorityLimit = 200;

    public ReplacementPolicy(int nBuffer) {
        this.nBuffer = nBuffer;
        this.isEmpty = new boolean[nBuffer];
        this.priority = new int[nBuffer];
        for (int i = 0; i < nBuffer; ++i) {
            this.isEmpty[i] = true;
            this.priority[i] = 0;
        }
        this.armIndex = 0;
    }

    private void incArmIndex() {
        this.armIndex = (this.armIndex + 1) % this.nBuffer;
    }

    public void setUsed(int bufferIndex) {
        this.setUsed(bufferIndex, 1);
    }

    public void setUsed(int bufferIndex, int newPriority) {
        this.isEmpty[bufferIndex] = false;
        this.priority[bufferIndex] = newPriority;
    }

    public void changeUsed(int bufferIndex, int newpriority) {
        this.isEmpty[bufferIndex] = false;
        if (this.priority[bufferIndex] < 200) {
            int n = bufferIndex;
            this.priority[n] = this.priority[n] + newpriority;
        }
    }

    public void setNotUsed(int bufferIndex) {
        this.isEmpty[bufferIndex] = true;
        this.priority[bufferIndex] = 0;
    }

    public int getNextIndex() {
        int returnValue;
        if (this.isEmpty[this.armIndex]) {
            returnValue = this.armIndex;
            this.incArmIndex();
        } else {
            while (!this.isEmpty[this.armIndex] && this.priority[this.armIndex] > 0) {
                this.priority[this.armIndex] = this.priority[this.armIndex] - 1;
                this.incArmIndex();
            }
            returnValue = this.armIndex;
        }
        for (int i = 0; i < this.armIndex; ++i) {
            if (i == returnValue) continue;
            this.priority[i] = 4;
        }
        return returnValue;
    }
}

