/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.util.Vector;
import quadbase.common.server.ExportThread;
import quadbase.common.server.Server;
import quadbase.scheduler.ScheduleObject;

public class RunScheduleThread
extends Thread {
    private long delaytime = 1000L;
    private boolean please_stop = false;
    private Server scheduler;
    private boolean debug = false;
    private int limit = -1;
    private Vector running = new Vector();
    private Vector waiting = new Vector();

    public RunScheduleThread(Server scheduler) {
        this.setDaemon(true);
        this.scheduler = scheduler;
        this.limit = scheduler.getExportThreadLimit();
    }

    public void setTime(long millsec) {
        this.delaytime = millsec;
    }

    public void pleaseStop() {
        this.please_stop = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.please_stop) {
            block3: {
                try {
                    RunScheduleThread.sleep(this.delaytime);
                    if (this.scheduler.scheduleList.size() == 0) continue;
                    long curTime = System.currentTimeMillis();
                    if (curTime % 30000L >= 999L) break block3;
                    this.runScheduleTask(curTime);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (!this.please_stop) continue;
            break;
        }
    }

    synchronized void runScheduleTask(long cal) throws Exception {
        int listSize = this.scheduler.scheduleList.size();
        for (int i = 0; i < listSize; ++i) {
            ScheduleObject obj = this.scheduler.scheduleList.elementAt(i);
            if (this.debug) {
                System.out.println(" \t\t>> EXPORT TO " + obj.getExportLocation());
            }
            if (obj.exportNow(cal)) {
                if (this.debug) {
                    System.out.println(" EXPORT NOW!!");
                }
                ExportThread exportThread = new ExportThread(this.scheduler, obj);
                if (this.limit == -1 || this.running.size() < this.limit) {
                    System.out.println("starting thread and add to run queue");
                    exportThread.start();
                    this.running.add(exportThread);
                } else {
                    System.out.println("adding thread to waiting queue");
                    this.waiting.add(exportThread);
                }
            }
            if (!obj.deleteJob()) continue;
            this.scheduler.scheduleList.removeElementAt(i);
            --listSize;
            --i;
        }
    }

    synchronized void scheduleFinished(ExportThread et) {
        this.running.remove(et);
        System.out.println("removing thread from waiting queue");
        while (this.waiting.size() > 0 && this.running.size() < this.limit) {
            System.out.println("waiting size [" + this.waiting.size() + "] running size [" + this.running.size() + "]");
            ExportThread next = (ExportThread)this.waiting.remove(0);
            next.start();
            this.running.add(next);
        }
    }
}

