/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Date;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.scheduler.ScheduleObject;

public class SCHScheduler {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    int slaveType;
    String result;
    int index;
    ScheduleObject schObj;

    public SCHScheduler(MessageThread messageThread, Server server, IConnection socket, int slaveType) {
        this.messageThread = messageThread;
        this.slaveType = slaveType;
        this.server = server;
        this.client_socket = socket;
        this.index = messageThread.rowIndex;
        this.schObj = messageThread.scheduleObject;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(this.slaveType)) {
            try {
                block1 : switch (this.slaveType) {
                    case 31005: {
                        this.server.writeScheduleList();
                        break;
                    }
                    case 31002: {
                        this.server.scheduleList.setElementAt(this.schObj, this.index);
                        break;
                    }
                    case 31003: {
                        this.server.scheduleList.add(this.schObj);
                        break;
                    }
                    case 31004: {
                        ScheduleObject obj = null;
                        for (int i = 0; i < this.server.scheduleList.size(); ++i) {
                            obj = this.server.scheduleList.elementAt(i);
                            if (!obj.equals(this.schObj)) continue;
                            this.server.scheduleList.removeElementAt(i);
                            break block1;
                        }
                        break;
                    }
                }
                this.sendReply(this.slaveType);
            }
            catch (Exception ex) {
                this.cleanup(3, "Scheduler server error:" + ex.toString() + "\n");
            }
        }
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void sendReply(int slaveType) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        switch (slaveType) {
            case 31001: {
                this.writeScheduleList(this.server.scheduleList, dout);
                break;
            }
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void writeScheduleList(Vector schList, DataOutputStream orgOut) throws Exception {
        VersioningDataOutput out = new VersioningDataOutput(orgOut);
        out.writeInt(schList.size());
        for (int i = 0; i < schList.size(); ++i) {
            ScheduleObject obj = (ScheduleObject)schList.elementAt(i);
            obj.writeComplete(out);
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

