/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.server.MessageThread;
import quadbase.common.server.ParamQuerySlave;
import quadbase.common.server.Server;

public class SFparamMetaSlave
extends ParamQuerySlave {
    SalesForceQueryFileInfo sfQueryInfo;
    String paramName;
    Vector availColumn;
    int nAvailColumn;

    public SFparamMetaSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.sfQueryInfo = messageThread.sfQueryInfo;
        this.paramName = messageThread.paramName;
    }

    @Override
    int getMessageType() {
        return 11003;
    }

    @Override
    void slaveBody() throws Exception {
        this.availColumn = AvailColumn.makeFromLocal(this.sfQueryInfo, this.paramName);
        this.nAvailColumn = this.availColumn.size();
    }

    @Override
    String getArguments() {
        return "SalesForce query";
    }

    @Override
    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        dout.writeInt(this.nAvailColumn);
        for (int i = 0; i < this.nAvailColumn; ++i) {
            ((AvailColumn)this.availColumn.elementAt(i)).write(dout);
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }
}

