/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;
import quadbase.util.QueryResultSet;
import quadbase.util.internal.TransposeRS;

public class SQLSlave
extends DataSlave {
    ByteArrayOutputStream bstream;
    DataOutputStream dout;
    boolean directODBC = false;
    Connection conn;
    protected DBInfoBasic dbInfo;
    protected boolean transposeData = false;
    protected boolean[] transposeCol;
    DataBuffer dataBuffer;

    public SQLSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.dbInfo = messageThread.dbInfo;
        this.transposeData = messageThread.transposeData;
        this.transposeCol = messageThread.transposeCol;
    }

    IResultSet getResultSet() throws Exception {
        this.dataBuffer = new DataBuffer(ConnectionBuffer.getBufferSize(), this.dbInfo);
        if (!this.messageThread.useDBbuffer) {
            this.connectionBuffer.refresh(this.dataBuffer);
        }
        if (Server.showMonitor) {
            ++Server.sm.totalQuery;
        }
        if (this.messageThread.useDBbuffer) {
            IResultSet ait;
            this.dataBuffer = this.connectionBuffer.getDataBuffer(this.dataBuffer);
            int idx = -1;
            if (this.dataBuffer != null && (idx = this.dataBuffer.getIndex(this.dbInfo.getQuery(), this.messageThread.inParamSet)) >= 0 && (ait = this.dataBuffer.getResultSet(idx, this.messageThread.startIndex, this.messageThread.displayRow)) != null) {
                if (this.transposeData) {
                    ait = TransposeRS.doTranspose(ait, this.transposeCol);
                }
                if (Server.showMonitor) {
                    ++Server.sm.bufferQuery;
                }
                return ait;
            }
        }
        if (this.dbInfo.getQuery() == null || this.dbInfo.getQuery().trim().equals("")) {
            throw new Exception("Empty query !");
        }
        if (this.server.service && !this.dbInfo.isUseJNDIDataSource() && this.dbInfo.getDriverName().equals("sun.jdbc.odbc.JdbcOdbcDriver")) {
            int sindex = this.dbInfo.getURLString().indexOf("jdbc:odbc:");
            if (sindex < 0) {
                throw new IOException("URL must start with jdbc:odbc: for using Jdbc-Odbc bridge !");
            }
            if (this.messageThread.hasParameters) {
                throw new IllegalArgumentException("Service does not support parameterized query!");
            }
            IResultSet tmpirs = this.getResultFromService(this.dbInfo.getURLString().substring(10), this.dbInfo.getUserID(), this.dbInfo.getPassword(), this.dbInfo.getQuery());
            return tmpirs;
        }
        if (!this.messageThread.useDBbuffer) {
            this.conn = this.dbInfo.openConnection();
        } else if (this.dataBuffer == null || (this.conn = this.dataBuffer.getConnection()) == null || this.conn.isClosed()) {
            this.dataBuffer = new DataBuffer(ConnectionBuffer.getBufferSize(), this.dbInfo);
            this.connectionBuffer.addData(this.dataBuffer, this.messageThread.filterData ? 4 : 1);
            this.conn = this.dbInfo.openConnection();
            this.dataBuffer.setConnection(this.conn);
        }
        IResultSet tmpirs = this.retrieveResult(this.conn, this.dbInfo.getQuery());
        return tmpirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData() {
        try {
            IResultSet rs = this.getResultSet();
            byte[] outBuf = this.writeToBuffer(rs);
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.conn != null && !this.messageThread.useDBbuffer) {
                this.closeConnection();
            }
            byte[] byArray = outBuf;
            return byArray;
        }
        catch (Exception ex) {
            if (this.conn != null) {
                if (!this.messageThread.useDBbuffer) {
                    this.closeConnection();
                }
                this.cleanup(1, "Failed to retrieve data.\n " + ex.getMessage() + "\n", true);
            } else if (this.dbInfo.getQuery() == null || this.dbInfo.getQuery().trim().equals("")) {
                this.cleanup(1, ex.getMessage() + "\n", true);
            } else {
                this.cleanup(1, "Failed to connect to database\n " + ex.getMessage() + "\n", true);
            }
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(-1, err.toString() + "\n");
        }
        finally {
            if (this.conn != null && !this.messageThread.useDBbuffer) {
                this.closeConnection();
            }
        }
        return null;
    }

    void closeConnection() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, !this.directODBC && code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new java.util.Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nJNDI Name =" + this.dbInfo.getJNDIName() + ", Database : " + this.dbInfo.getURLString() + ", Driver = " + this.dbInfo.getDriverName() + "\nquery = " + this.dbInfo.getQuery() + " -- ";
    }

    IResultSet retrieveResult(Connection conn, String query) throws Exception {
        String productName;
        Statement stmt;
        boolean isResult;
        block15: {
            query = query.trim();
            isResult = false;
            stmt = null;
            productName = "";
            try {
                productName = conn.getMetaData().getDatabaseProductName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (QueryParser.isCallableStmt(query)) {
                if (this.messageThread.hasParameters) {
                    query = this.messageThread.inParamSet.convertToJDBCquery(query);
                }
                CallableStatement callstmt = conn.prepareCall(query);
                if (this.messageThread.hasParameters) {
                    this.messageThread.inParamSet.setStmtValue(callstmt);
                }
                isResult = callstmt.execute();
                stmt = callstmt;
            } else if (this.messageThread.hasParameters) {
                query = this.messageThread.inParamSet.convertToJDBCquery(query);
                PreparedStatement pStmt = conn.prepareStatement(query);
                this.messageThread.inParamSet.setStmtValue(pStmt);
                isResult = pStmt.execute();
                stmt = pStmt;
            } else {
                try {
                    stmt = conn.createStatement();
                    isResult = stmt.execute(query);
                }
                catch (Exception ex) {
                    if (stmt == null) break block15;
                    try {
                        stmt.close();
                        return null;
                    }
                    catch (Exception ex2) {
                        return null;
                    }
                }
            }
        }
        while (!isResult) {
            if (stmt.getUpdateCount() == -1) {
                stmt.close();
                throw new SQLException("No result set returned !");
            }
            isResult = stmt.getMoreResults();
        }
        IResultSet resultRS = new QueryResultSet(stmt, productName);
        resultRS = this.makeBufferedResultSet(resultRS);
        if (this.messageThread.transposeData) {
            resultRS = TransposeRS.doTranspose(resultRS, this.transposeCol);
        }
        return resultRS;
    }

    public IResultSet makeBufferedResultSet(IResultSet resultRS) throws Exception {
        if (this.dataBuffer.nBuffer == 0) {
            return resultRS;
        }
        this.dataBuffer.addData(this.dbInfo.getQuery(), this.messageThread.inParamSet, resultRS, this.messageThread.filterData ? 4 : 1);
        return this.dataBuffer.getResultSet(this.dbInfo.getQuery(), this.messageThread.inParamSet, this.messageThread.startIndex, this.messageThread.displayRow);
    }

    IResultSet getResultFromService(String url, String username, String password, String query) throws Exception {
        this.directODBC = true;
        Socket client_socket2 = null;
        ServerSocket socket2 = new ServerSocket(0);
        int portno = socket2.getLocalPort();
        try {
            ByteArrayOutputStream bs3 = new ByteArrayOutputStream(100);
            DataOutputStream dout3 = new DataOutputStream(bs3);
            dout3.writeInt(portno);
            Server.writeString(dout3, url);
            Server.writeString(dout3, username);
            Server.writeString(dout3, password);
            Server.writeString(dout3, query);
            DataOutputStream dout2 = new DataOutputStream(System.out);
            dout2.writeByte(52);
            byte[] barray = bs3.toByteArray();
            dout2.writeShort(barray.length + 3);
            dout2.write(barray);
            dout2.flush();
            client_socket2 = socket2.accept();
            socket2.close();
            IResultSet resultRS = new ServiceResultSet(client_socket2);
            resultRS = this.makeBufferedResultSet(resultRS);
            if (this.messageThread.transposeData) {
                resultRS = TransposeRS.doTranspose(resultRS, this.transposeCol);
            }
            return resultRS;
        }
        catch (IOException ex) {
            try {
                if (client_socket2 != null) {
                    client_socket2.close();
                }
                socket2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }

    Object readObject(DataInputStream in, int dtype) throws IOException {
        if (in.readByte() == 48) {
            return null;
        }
        switch (dtype) {
            case -1: 
            case 1: 
            case 12: {
                return IOUtil.readString(in, false);
            }
            case -6: {
                return in.readByte();
            }
            case 5: {
                return in.readShort();
            }
            case 4: {
                return in.readInt();
            }
            case -5: {
                return Long.valueOf(IOUtil.readString(in, false));
            }
            case 7: {
                return Float.valueOf(in.readFloat());
            }
            case 6: 
            case 8: {
                return in.readDouble();
            }
            case 2: 
            case 3: {
                return new BigDecimal(IOUtil.readString(in, false));
            }
            case -7: {
                return in.readByte() == 49;
            }
            case 91: {
                return new Date(in.readShort() - 1900, in.readShort() - 1, in.readShort());
            }
            case 92: {
                return new Time(in.readShort(), in.readShort(), in.readShort());
            }
            case 93: {
                return new Timestamp(in.readShort() - 1900, in.readShort() - 1, in.readShort(), in.readShort(), in.readShort(), in.readShort(), in.readInt());
            }
        }
        in.readByte();
        return null;
    }

    class ServiceResultSet
    implements IResultSet,
    IRSMetaData {
        Socket sock;
        DataInputStream din;
        String[] colNames;
        String[] tblNames;
        String[] colTypeNames;
        int[] colTypes;
        Object[] data;

        public ServiceResultSet(Socket s) throws IOException {
            this.sock = s;
            this.din = new DataInputStream(this.sock.getInputStream());
            if (this.din.readByte() == 101) {
                byte[] b = new byte[1024];
                int len = this.din.read(b);
                throw new IOException(new String(b, 0, len - 2));
            }
            int nCol = this.din.readShort();
            this.colNames = new String[nCol];
            this.tblNames = new String[nCol];
            this.colTypeNames = new String[nCol];
            this.colTypes = new int[nCol];
            this.data = new Object[nCol];
            for (int i = 0; i < nCol; ++i) {
                this.colNames[i] = IOUtil.readString(this.din, false);
                this.tblNames[i] = IOUtil.readString(this.din, false);
                this.colTypes[i] = this.din.readShort();
            }
        }

        @Override
        public boolean next() throws IOException {
            if (this.din.readByte() == 49) {
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = SQLSlave.this.readObject(this.din, this.colTypes[i]);
                }
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            this.din.close();
            this.sock.close();
        }

        @Override
        public Object getObject(int colNo) {
            return this.data[colNo - 1];
        }

        @Override
        public IRSMetaData getMetaData() {
            return this;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col - 1];
        }

        @Override
        public String getTableName(int col) {
            return this.tblNames[col - 1];
        }

        @Override
        public int getColumnType(int col) {
            return this.colTypes[col - 1];
        }
    }
}

