/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.util.Date;
import quadbase.chart.DBAccess;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.util.IResultSet;
import quadbase.util.SalesForceResultSet;

public class SalesForceQuerySlave
extends DataSlave {
    public SalesForceQuerySlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    public byte[] readData() {
        try {
            IResultSet tmpRs;
            SalesForceResultSet rs;
            IResultSet trs = rs = new SalesForceResultSet(this.messageThread.sfQueryInfo);
            if ((this.messageThread.transposeData || this.messageThread.tsInfo != null) && (tmpRs = DBAccess.processResultSet(rs, false, this.messageThread.transposeData, this.messageThread.transposeCol, null, this.messageThread.tsInfo)) != null) {
                trs = tmpRs;
            }
            byte[] outBuf = this.writeToBuffer(trs);
            try {
                trs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return outBuf;
        }
        catch (Exception ex) {
            this.cleanup(1, "Failed to retrieve data.\n" + ex.toString() + "\n", true);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
        }
        return null;
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nSalesForce query = " + this.messageThread.sfQueryInfo.getQuery() + " -- ";
    }
}

