/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.HttpServerConnection;
import quadbase.common.network.IConnection;
import quadbase.common.network.SocketConnection;
import quadbase.common.server.CleanupPageFilesTableThread;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.DBRefresh;
import quadbase.common.server.DataSlave;
import quadbase.common.server.ExportThread;
import quadbase.common.server.MessageThread;
import quadbase.common.server.QbObjectPool;
import quadbase.common.server.ReleaseFileSlave;
import quadbase.common.server.RunScheduleThread;
import quadbase.common.server.ServerMonitor;
import quadbase.common.server.ServiceThread;
import quadbase.common.server.UserInfo;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.ext.ListenerManager;
import quadbase.queryproc.ChartDelegate;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.report.CSVReport;
import quadbase.reportdesigner.report.PageReport;
import quadbase.scheduler.ScheduleObject;

public class Server
extends Thread {
    public static final String SERVER_CFG = "espressmanager.cfg";
    static final int GETUSER = 0;
    static final int LOGIN = 1;
    static final int LOGOUT = 2;
    static final int VERIFY = 3;
    static final int GETSQL = 0;
    static final int ADDSQL = 1;
    public static final String CONFIG_BASE = "config.txt";
    static final String COMMAND_BASE = "ServerCommands.txt";
    static final int DEFAULT_PORTNO = 22071;
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private static final String ERES_HOME_PROPERTY = "eres.home";
    private static final String EDAB_HOME_PROPERTY = "edab.home";
    public static String configFile = "userdb/config.txt";
    public static String configDir = "userdb";
    public static String servletCfg = "servlet.cfg";
    public static String serverLog = "espressmanager.log";
    public static String scheduleLog = "schedule.log";
    public static String smtpHostName = "";
    public static boolean smtpSecure = false;
    public static boolean smtpSSL = false;
    public static int smtpPort = -1;
    public static String smtpUserName = "";
    public static String smtpPassword = "";
    public static int nBuffer = 5;
    public static DBRefresh dbr = null;
    static ServerMonitor sm = null;
    static boolean showMonitor = true;
    static boolean runInBackground = false;
    static String orgCommand = "WEB-INF/orguserdb/ServerCommands.txt";
    static String scheduleFile = "userdb/scheduleList.sch";
    static ConnectionBuffer connectionBuffer;
    private static long dhtmlViewerBufferCleanupTime;
    private static long pageViewerBufferCleanupTime;
    private static String menuRoot;
    long pageCleanupTime = 43200000L;
    int maxNoOfUser = 1;
    String mainPath;
    String urlPath;
    Vector<UserInfo> userInfo = new Vector();
    boolean service = false;
    Hashtable<String, String> lockedFiles = new Hashtable();
    Hashtable overrideFiles = new Hashtable();
    Hashtable overrideTimeTable = new Hashtable();
    Vector<ScheduleObject> scheduleList = new Vector();
    int requestNo = 0;
    boolean startFromOrganizer = false;
    Vector<String> serverCommands = new Vector();
    Hashtable<String, String> pageNameTbl = new Hashtable();
    DataOutputStream logstream = null;
    DataOutputStream schlogstream = null;
    ServiceThread serviceThread;
    RunScheduleThread runScheduleThread;
    CleanupPageFilesTableThread cleanupPageFilesTableThread;
    private String htmlDirectory = "html/";
    private String pageFileDirectory = "pages/";
    private String DHTMLViewerBufferDir = "DViewerBuffer/";
    private int portno;
    private ServerSocket socket;
    private int currUserNo = 0;
    private int currThreadNo = 0;
    private int requestIONo = 0;
    private int requestSQLNo = 0;
    private String ipaddress;
    private Vector<String> hostName = new Vector();
    private int pageNameCt = 0;
    private boolean qbLoginRequired = false;
    private String qbDesignerPassword = null;
    private String schedulerCallBackClass = null;
    private ListenerManager listenerManager = null;
    private int exportThreadLimit = -1;
    private boolean pleaseStop;

    public Server() {
        this(-1, null, null, false);
    }

    public Server(int preSetPort, Vector<String> hostNameVec, String ipaddr, boolean startFromOrganizer) {
        String host;
        ServerMessage.useServer = false;
        this.startFromOrganizer = startFromOrganizer;
        this.mainPath = ServerMessage.getWorkingDirectory();
        this.setPath();
        if (!startFromOrganizer) {
            this.getUsersInfo();
        }
        this.readServerCommands();
        if (preSetPort > 0) {
            this.portno = preSetPort;
        }
        if (hostNameVec != null) {
            this.hostName = hostNameVec;
        }
        if (ipaddr != null) {
            this.ipaddress = ipaddr;
        }
        try {
            this.socket = new ServerSocket(this.portno);
        }
        catch (Exception ex) {
            try {
                this.socket = new ServerSocket(0);
            }
            catch (IOException ex2) {
                this.do_exit("Can't creat server datagram socket \n !" + ex2.getMessage());
            }
        }
        this.portno = this.socket.getLocalPort();
        if (this.ipaddress == null) {
            try {
                this.ipaddress = InetAddress.getLocalHost().getHostAddress();
                host = InetAddress.getByName(this.ipaddress).getHostName();
                this.hostName.addElement(host);
            }
            catch (Exception ex) {
                Server.println("Unknown host, " + ex.toString() + " use localhost");
                this.ipaddress = "127.0.0.1";
            }
        }
        if (this.hostName == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
                this.hostName.addElement(host);
            }
            catch (Exception ex) {
                Server.println("Unknown host name, " + ex.toString() + " use ip address");
                this.hostName.addElement(this.ipaddress);
            }
        }
        if (ServerMessage.isReleaseVersion()) {
            LCKey.isValidServer();
            this.maxNoOfUser = LCKey.getMaxNoOfUser();
            if (this.maxNoOfUser <= 1) {
                this.maxNoOfUser = 1;
            }
            if (!startFromOrganizer) {
                Server.println("Max Number Of Concurrent Developers : " + this.maxNoOfUser);
                Server.println("Max Number Of CPU : " + LCKey.getMaxNoOfCPU());
            }
        }
        if (LCKey.getError() != null) {
            throw new IllegalArgumentException(LCKey.getError());
        }
        this.writeFiles(SERVER_CFG, this.ipaddress, this.portno + "", this.hostName);
        if (ServerMessage.isServlet()) {
            this.writeFiles(servletCfg, ServerMessage.getConnectServlet() + ServerMessage.getServletContext(), null, null);
        }
        if (startFromOrganizer) {
            try {
                this.writeFilesNoErrorCheck(menuRoot + SERVER_CFG, this.ipaddress, this.portno + "", this.hostName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataSlave.queryProcFactory = new ChartDelegate();
        try {
            this.readScheduleList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long getCleanupIntervalForDHTMLViewerBuffer() {
        return dhtmlViewerBufferCleanupTime;
    }

    public static void setCleanupIntervalForDHTMLViewerBuffer(long interval) {
        dhtmlViewerBufferCleanupTime = interval;
    }

    public static long getCleanupIntervalForPageViewerBuffer() {
        return pageViewerBufferCleanupTime;
    }

    public static void setCleanupIntervalForPageViewerBuffer(long interval) {
        pageViewerBufferCleanupTime = interval;
    }

    public static String getUserLanguage() {
        String language = System.getProperty("user.language");
        return language;
    }

    public static String getSystemProperty(String key) {
        String prop = System.getProperty(key);
        return prop;
    }

    static void println(Server server, String str) {
        if (!runInBackground) {
            System.out.println(str);
        }
        server.writeLog(str);
    }

    static void println(byte str) {
        if (!runInBackground) {
            System.out.println(str);
        }
    }

    static void println(int str) {
        if (!runInBackground) {
            System.out.println(str);
        }
    }

    static void println(String str) {
        if (!runInBackground) {
            System.out.println(str);
        }
    }

    static void print(Server server, String str) {
        if (!runInBackground) {
            System.out.print(str);
        }
        server.writeLog(str);
    }

    static void print(int str) {
        if (!runInBackground) {
            System.out.print(str);
        }
    }

    static void print(char str) {
        if (!runInBackground) {
            System.out.print(str);
        }
    }

    static void print(String str) {
        if (!runInBackground) {
            System.out.print(str);
        }
    }

    void printToLog(String str) {
        Server.println(str);
        try {
            this.writeScheduleLog(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        QbUtil.setWindowsLAF();
        Server sv = new Server();
        Server.startServer(sv, argv);
    }

    public static Server startServer(Server sv, String[] argv) {
        sv.prepare(sv, argv);
        if (showMonitor) {
            sm = new ServerMonitor(sv);
            sm.start();
            ++Server.sm.smui.vThread;
        }
        sv.start();
        if (showMonitor) {
            ++Server.sm.smui.vThread;
        }
        return sv;
    }

    private static void showSyntax() {
        Server.println("Syntax: quadbase.common.server.Server [-help] [-log] [-DBBuffer:nnn]");
        Server.println("            [-DBCleanAll:ddhhmm] [-monitor:ON/OFF] [-runInBackground:ON/OFF]");
        Server.println("            [-recordLimit:nnn] [-RequireLogin] [-QbDesignerPassword:password]");
        Server.println("            [-SchedulerCallBackClass:classname]");
        Server.println("            [-ListenerManagerClass:classname]");
        Server.println("            [-PageCleanUpTime:hhh]");
        Server.println("            [-PageViewerBufferCleanUpTime:hhh]");
        Server.println("            [-DHTMLViewerBufferCleanUpTime:hhh]");
        Server.println("            [-PagingThreshold:nnn] [-MaxFieldSize:nnn]");
        Server.println("            [-PageBufferSize:nnn]");
        Server.println("            [-TotalPageBufferSize:nnn]");
        Server.println("            [-globalFormat:filepath] [-fontMapping:filepath]");
        Server.println("            [-htmlDpi:integer] [-singleTableForDistinctParamValue]");
        Server.println("            [-schedulerThreadLimit:integer]");
        Server.println("            [-debug:debugMode]");
        Server.println("            [-schedulerBuffer:nnn]");
        Server.println("            [-xmlEncoding:Coder]");
        Server.println("            [-queryTimeout:integer]");
        Server.println("            [-disableDataViewInQuickDesigner]");
        Server.println("            [-disableSaveQueryInQuickDesigner]");
        Server.println("            [-ExcelExportFitCell]");
        Server.println("            [-ExcelExportNonNumericFitCell]");
        Server.println("            [-ExcelExportStreaming]");
        Server.println("            [-paperSize:Letter/A4]");
        Server.println("            [-ExportNewlineDelimiter:Windows/Others/System]");
    }

    static void syntaxError() {
        Server.showSyntax();
        if (!ServerMessage.isServlet()) {
            System.exit(1);
        }
    }

    static void help() {
        Server.showSyntax();
        Server.println("-help:       get this screen");
        Server.println("-log:        create log file for record");
        Server.println("-DBBuffer:   specify nnn unit buffer to speed up database access");
        Server.println("-DBCleanAll: specify buffer refresh interval:                                                ddhhmm means dd days, hh hours and mm minutes");
        Server.println("-monitor:    specify whether to launch server monitor");
        Server.println("-runInBackground:    specify whether to run in background");
        Server.println("-recordLimit:   specify maximum number of records that server can retrieve");
        Server.println("-PagingThreshold:   specify the threshold value (in MB) for enable paging feature (USE FOR PAGEVIEWER/SCHEDULING/ARCHIVE");
        Server.println("-PageBufferSize:   specify page buffer size in memory (in MB) at a time when using paging feature to generate the file (USE FOR PAGEVIEWER/SCHEDULING/ARCHIVE");
        Server.println("-TotalPageBufferSize:   specify total page buffer size in memory (in MB) at a time when using paging feature to generate the file (USE FOR PAGEVIEWER/SCHEDULING/ARCHIVE");
        Server.println("-MaxFieldSize:   specify maximum number of character for record in column when using paging feature to generate the file (USE FOR PAGEVIEWER/SCHEDULING/ARCHIVE");
        Server.println("-globalFormat:filepath: file path to the global format xml file to as default");
        Server.println("-fontMapping:filepath:  file path to the font mapping xml file to use as default");
        Server.println("-RequireLogin:       QbReportDesigner/QbChartDesigner users have to login first before using designer");
        Server.println("-QbDesignerPassword:nnn       QbReportDesigner/QbChartDesigner users have to pass in the preset password, nnn, in their programs before using designer");
        Server.println("-SchedulerCallBackClass:nnn       Server will call back class, nnn, once the scheduled task is done");
        Server.println("-PageCleanUpTime:hhh       change 'temp' directory clean up time hhh means hours");
        Server.println("-DHTMLViewerBufferCleanUpTime:hhh       change 'DViewerBuffer' directory clean up time hhh means hours");
        Server.println("-PageViewerBufferCleanUpTime:hhh       change 'pages' directory clean up time hhh means hours");
        Server.println("-ListenerManagerClass:       set the class for Listener Manager");
        Server.println("-singleTableForDistinctParamValue : whether to use single table to get distinct parameter values");
        Server.println("-schedulerThreadLimit : sets whether to limit number of concurrent running scheduler threads");
        Server.println("-debug:debugMode: sets debug mode to print out debug statements");
        Server.println("-schedulerBuffer:  specify nnn unit buffer to speed up schedule tasks");
        Server.println("-xmlEncoding:  specify xml encoding");
        Server.println("-queryTimeout:  sets the number of seconds the driver will wait for a SQL statement object to execute");
        Server.println("-ExcelExportFitCell: specify if numeric fields in a report exported to Excel format occupy 1 cell or not");
        Server.println("-ExcelExportNonNumericFitCell: specify if non numeric fields in a report exported to Excel format occupy 1 cell or not");
        Server.println("-ExcelExportStreaming: specify if use streaming when export Excel report xlsx");
        Server.println("-paperSize: letter or A4 paper");
        Server.println("-ExportNewlineDelimiter: specify whether the newline delimiter will follow Windows standard (\r\n), Other OS standard (\n), or use the standard set for the current OS.");
        if (!ServerMessage.isServlet()) {
            System.exit(1);
        }
    }

    public static void writeString(DataOutputStream out, String string) throws IOException {
        out.writeBytes(string);
        out.writeByte(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isXMLReport(String url) {
        boolean bl;
        BufferedReader buffer;
        InputStreamReader instream;
        block10: {
            boolean bl2;
            block9: {
                instream = null;
                buffer = null;
                try {
                    if (url.toLowerCase().startsWith("file:/") || url.toLowerCase().startsWith("http:/")) {
                        url = Server.fixUrlString(url);
                        instream = new InputStreamReader(new URL(url).openStream());
                    } else {
                        instream = new FileReader(url);
                    }
                    buffer = new BufferedReader(instream);
                    String tmp = null;
                    for (int i = 0; i < 5 && (tmp = buffer.readLine()) != null; ++i) {
                        if (tmp.toUpperCase().indexOf("<REPORT NAME") < 0) continue;
                        bl2 = true;
                        CloseUtils.close(buffer);
                        break block9;
                    }
                    bl = false;
                    CloseUtils.close(buffer);
                    break block10;
                }
                catch (Exception ex) {
                    bl = false;
                    return bl;
                }
            }
            CloseUtils.close(instream);
            return bl2;
        }
        CloseUtils.close(instream);
        return bl;
        finally {
            CloseUtils.close(buffer);
            CloseUtils.close(instream);
        }
    }

    public static String fixUrlString(String url) {
        if (!url.toLowerCase().startsWith("file:/") && url.indexOf("://") == -1) {
            return url;
        }
        char[] c = url.toCharArray();
        StringBuffer buf = new StringBuffer();
        block3: for (int n : c) {
            switch (n) {
                case 32: 
                case 34: 
                case 35: 
                case 37: 
                case 38: 
                case 39: 
                case 43: 
                case 60: 
                case 62: {
                    int integer = n;
                    buf.append("%").append(Integer.toHexString(integer &= 0xFF));
                    continue block3;
                }
                default: {
                    buf.append((char)n);
                }
            }
        }
        return buf.toString();
    }

    public static String readHomeProperty() {
        String configDirectoryKey = "quadbase.properties.url";
        String homeConfigDirName = System.getProperty(configDirectoryKey);
        String quadbaseProp = "quadbase.properties";
        InputStream is = null;
        if (homeConfigDirName != null) {
            String fullPath = null;
            fullPath = homeConfigDirName.endsWith(quadbaseProp) ? homeConfigDirName : (!homeConfigDirName.endsWith("\\") && !homeConfigDirName.endsWith("/") ? homeConfigDirName + System.getProperty("file.separator") + quadbaseProp : homeConfigDirName + quadbaseProp);
            File quadbaseProperties = new File(fullPath);
            if (quadbaseProperties.exists() && quadbaseProperties.isFile()) {
                try {
                    is = new FileInputStream(quadbaseProperties);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (is == null) {
            is = Server.class.getResourceAsStream("/quadbase.properties");
        }
        if (is == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (LCKey.isERES()) {
            return props.getProperty(ERES_HOME_PROPERTY);
        }
        return System.getProperty(EDAB_HOME_PROPERTY);
    }

    public String getSchedulerCallBackClass() {
        return this.schedulerCallBackClass;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public String getPageFileName() {
        ++this.pageNameCt;
        this.pageNameCt %= 1000;
        return this.pageFileDirectory + System.currentTimeMillis() + "_" + this.pageNameCt;
    }

    public String getPageFileName(String str) {
        String val = this.pageNameTbl.get(str);
        if (val != null) {
            return val;
        }
        String sval = this.getPageFileName();
        this.pageNameTbl.put(str, sval);
        return sval;
    }

    public byte[] toByteArray(String fileName) throws Exception {
        DataInputStream fstream = new ReadDataFile().getInputStream(fileName);
        int length = fstream.available();
        byte[] barray = new byte[length];
        fstream.read(barray, 0, length);
        return barray;
    }

    void cleanupdhtmlViewerBuffer() {
        File[] listFile;
        QbDebug.println(6, "Delete all the expired files in 'DViewerBuffer' directory");
        File dir = new File(this.getPath(this.DHTMLViewerBufferDir));
        long curtime = System.currentTimeMillis();
        for (File element : listFile = dir.listFiles()) {
            long time = element.lastModified();
            if (curtime - time < dhtmlViewerBufferCleanupTime) continue;
            try {
                element.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void cleanupPageFiles() {
        if (this.pageNameTbl == null) {
            this.cleanupTempFiles();
            return;
        }
        Enumeration<String> key = this.pageNameTbl.keys();
        long curtime = System.currentTimeMillis();
        while (key.hasMoreElements()) {
            String id = key.nextElement();
            String val = this.pageNameTbl.get(id);
            try {
                long time = this.getPageFileCreateTime(val);
                if (curtime - time < pageViewerBufferCleanupTime) continue;
                this.pageNameTbl.remove(id);
                PageReport.deleteAllPages(val);
            }
            catch (Exception ex) {
                this.pageNameTbl.remove(id);
                PageReport.deleteAllPages(val);
            }
        }
        this.cleanupTempFiles();
    }

    public long getPageCleanupTime() {
        return this.pageCleanupTime;
    }

    public void setPageCleanupTime(long l) {
        this.pageCleanupTime = l;
    }

    long getPageFileCreateTime(String val) throws Exception {
        try {
            return Long.parseLong(val.substring(this.pageFileDirectory.length(), val.indexOf(95)));
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    void cleanupTempFiles() {
        File[] listFile;
        QbDebug.println(6, "Delete all the expired files in 'TEMP' directory");
        File dir = new File(this.getPath(ServerMessage.getTempDirectory()));
        long curtime = System.currentTimeMillis();
        for (File element : listFile = dir.listFiles()) {
            long time = element.lastModified();
            if (curtime - time < this.pageCleanupTime) continue;
            try {
                element.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void deleteAllPageFiles() {
        try {
            File[] listFile;
            File dir = new File(this.pageFileDirectory);
            for (File element : listFile = dir.listFiles()) {
                element.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deleteAllTempFiles();
    }

    void deleteAllTempFiles() {
        try {
            File[] listFile;
            QbDebug.println(6, "Delete all the files in 'TEMP' directory");
            File dir = new File(this.getPath(ServerMessage.getTempDirectory()));
            for (File element : listFile = dir.listFiles()) {
                element.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void deleteAllDHTMLViewerFiles() {
        QbDebug.println(6, "Delete all the files in 'DViewerBuffer' directory");
        try {
            File[] listFile;
            File dir = new File(this.DHTMLViewerBufferDir);
            for (File element : listFile = dir.listFiles()) {
                element.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ConnectionBuffer getConnectionBuffer() {
        return connectionBuffer;
    }

    public void setConnectionBuffer(ConnectionBuffer cb) {
        connectionBuffer = cb;
    }

    public String getHTMLDirectory() {
        return this.htmlDirectory;
    }

    public String getPath(String path) {
        return ServerMessage.getPath(path);
    }

    String getDatabaseURL(String url) {
        String url2 = url.toLowerCase();
        if (url2.startsWith("jdbc:hsqldb:")) {
            url2 = this.getPath(url.substring(12));
            File file = new File(url2 + ".script");
            if ((file = new File(file.getAbsolutePath())).exists()) {
                return "jdbc:hsqldb:" + url2;
            }
            return url;
        }
        return url;
    }

    void setPath() {
        menuRoot = this.getPath(menuRoot) + "/";
        configFile = this.getPath(configFile);
        configDir = this.getPath(configDir);
        orgCommand = this.getPath(orgCommand);
        scheduleFile = this.getPath(scheduleFile);
        servletCfg = this.getPath(servletCfg);
        serverLog = this.getPath(serverLog);
        scheduleLog = this.getPath(scheduleLog);
        this.htmlDirectory = this.getPath(this.htmlDirectory) + "/";
        this.pageFileDirectory = this.getPath(this.pageFileDirectory) + "/";
        String tempDir = ServerMessage.getTempDirectory();
        tempDir = this.getPath(tempDir) + "/";
        ServerMessage.setTempDirectory(tempDir);
    }

    void writeFilesNoErrorCheck(String filename, String s, String s2, Vector<String> s3) throws Exception {
        FileOutputStream fstream = null;
        QbUtil.checkExtensionsBlacklist(filename);
        fstream = new FileOutputStream(this.getPath(filename));
        DataOutputStream dout = new DataOutputStream(fstream);
        if (s != null) {
            dout.writeBytes(s + "\n");
        }
        if (s2 != null) {
            dout.writeBytes(s2 + "\n");
        }
        if (s3 != null) {
            for (int i = 0; i < s3.size(); ++i) {
                dout.writeBytes(s3.elementAt(i) + "\n");
            }
        }
        fstream.close();
    }

    void writeFiles(String filename, String s, String s2, Vector<String> s3) {
        FileOutputStream fstream = null;
        try {
            QbUtil.checkExtensionsBlacklist(filename);
            fstream = new FileOutputStream(this.getPath(filename));
        }
        catch (IOException ex) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.do_exit("Failed to create file : " + this.getPath(filename) + ".\n" + ex.toString());
        }
        try {
            DataOutputStream dout = new DataOutputStream(fstream);
            if (s != null) {
                dout.writeBytes(s + "\n");
            }
            if (s2 != null) {
                dout.writeBytes(s2 + "\n");
            }
            if (s3 != null) {
                for (int i = 0; i < s3.size(); ++i) {
                    dout.writeBytes(s3.elementAt(i) + "\n");
                }
            }
        }
        catch (IOException ex) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.do_exit("Failed to write to configuration file.\n" + ex.getMessage());
        }
        if (fstream != null) {
            try {
                fstream.close();
            }
            catch (IOException ex) {
                this.do_exit("Failed to close configuration file.\n" + ex.getMessage());
            }
        }
    }

    synchronized boolean userCounter(boolean increase) {
        this.currThreadNo = increase ? ++this.currThreadNo : --this.currThreadNo;
        return true;
    }

    synchronized String userCheck(int action, String machine) {
        if (this.startFromOrganizer) {
            return null;
        }
        if (action == 1) {
            if (this.currUserNo >= this.maxNoOfUser) {
                return "This version of EspressManager supports " + this.maxNoOfUser + " concurrent users only ! \n Please restart the EspressManager\n if one or more client machine crashed before the user logged out.";
            }
            ++this.currUserNo;
            return null;
        }
        if (this.currUserNo > 0) {
            --this.currUserNo;
        }
        new ReleaseFileSlave(this, machine).start();
        return null;
    }

    synchronized String userCheck(int action, String user, String password, String machine, int slavetype) {
        return this.userCheck(action, user, password, false, machine, slavetype);
    }

    synchronized String userCheck(int action, String user, String password, boolean isFromQbDesigner, String machine, int slavetype) {
        if (action == 0) {
            String list = "";
            for (int i = 0; i < this.userInfo.size(); ++i) {
                UserInfo info = this.userInfo.elementAt(i);
                if (info.machine == null) continue;
                list = list + info.user + "\t" + info.machine + "\t" + info.time + "\n";
            }
            return list;
        }
        if (action == 3) {
            return "OK";
        }
        if (action == 1) {
            if (this.startFromOrganizer && !isFromQbDesigner) {
                return null;
            }
            if (isFromQbDesigner && !this.qbLoginRequired) {
                return null;
            }
            if (isFromQbDesigner && this.qbDesignerPassword != null) {
                if (this.qbDesignerPassword.equals(password)) {
                    return null;
                }
                return "Invalid QbDesigner password !\nAccess denied.";
            }
            for (int i = 0; i < this.userInfo.size(); ++i) {
                UserInfo info = this.userInfo.elementAt(i);
                if (!info.user.equals(user)) continue;
                if (info.password.equals(password) || (ServerMessage.isEvalVersion() || LCKey.isFree() || info.password.isEmpty()) && info.user.equals("guest")) {
                    if (info.machine == null) {
                        if (this.currUserNo >= this.maxNoOfUser) {
                            return "This version of EspressManager supports " + this.maxNoOfUser + " concurrent users only ! \n Please restart the EspressManager\n if one or more client machine crashed before the user logged out.";
                        }
                        info.machine = machine;
                        ++this.currUserNo;
                        info.time = new Date();
                        info.loggedin = true;
                        new ReleaseFileSlave(this, machine).start();
                        return null;
                    }
                    if (info.machine.equals(machine)) {
                        info.time = new Date();
                        info.loggedin = true;
                        new ReleaseFileSlave(this, machine).start();
                        return null;
                    }
                    if ((ServerMessage.isEvalVersion() || LCKey.isFree() || info.password.isEmpty()) && info.user.equals("guest")) {
                        info.machine = machine;
                        info.time = new Date();
                        info.loggedin = true;
                        new ReleaseFileSlave(this, machine).start();
                        return null;
                    }
                    Date newtime = new Date();
                    if (newtime.getTime() - info.time.getTime() > 3600000L) {
                        new ReleaseFileSlave(this, info.machine).start();
                        info.machine = machine;
                        info.time = newtime;
                        info.loggedin = true;
                        new ReleaseFileSlave(this, machine).start();
                        return null;
                    }
                    String machineName = info.machine;
                    int loc = machine.lastIndexOf("__");
                    if (loc > 0) {
                        machineName = machine.substring(0, loc);
                    }
                    return "The user is already logged on from " + machineName + "!\nIf this client machine crashed before the user had a chance to log out,\n please reset the server or try again after 60 minutes.";
                }
                return "Invalid user ID or password !\nAccess denied.";
            }
            return "Invalid user ID or password !\nAccess denied.";
        }
        for (int i = 0; i < this.userInfo.size(); ++i) {
            UserInfo info = this.userInfo.elementAt(i);
            if (info.machine == null || !info.machine.equals(machine)) continue;
            info.machine = null;
            info.loggedin = false;
            --this.currUserNo;
            new ReleaseFileSlave(this, machine).start();
            return null;
        }
        return null;
    }

    public void stopAllThread() {
        if (this.runScheduleThread != null) {
            this.runScheduleThread.pleaseStop();
        }
        if (this.cleanupPageFilesTableThread != null) {
            this.cleanupPageFilesTableThread.pleaseStop();
        }
        if (this.serviceThread != null) {
            this.serviceThread.threadExit();
        }
        if (dbr != null) {
            dbr.pleaseStop();
        }
        this.deleteAllPageFiles();
        this.deleteAllDHTMLViewerFiles();
    }

    public void scheduleFinished(ExportThread et) {
        this.runScheduleThread.scheduleFinished(et);
    }

    void do_exit(String s) {
        if (!this.service) {
            if (s != null) {
                Server.println(s);
            }
            if (this.getConnectionBuffer() != null) {
                this.getConnectionBuffer().close();
            }
            if (!ServerMessage.isServlet()) {
                System.exit(0);
            }
        } else {
            if (s != null) {
                Server.print('2');
                Server.println(s + '\u0000');
            } else {
                Server.println(51);
            }
            if (this.serviceThread != null) {
                this.serviceThread.threadExit();
            }
        }
    }

    @Override
    public void run() {
        this.requestNo = 0;
        if (!this.startFromOrganizer) {
            if (!runInBackground) {
                this.serviceThread = new ServiceThread(this);
                this.serviceThread.start();
            }
            this.runScheduleThread = new RunScheduleThread(this);
            this.runScheduleThread.start();
            this.cleanupPageFilesTableThread = new CleanupPageFilesTableThread(this);
            this.cleanupPageFilesTableThread.start();
        }
        if (showMonitor && sm != null) {
            ++Server.sm.smui.vThread;
        }
        this.writeLog("Open connection using IP " + this.ipaddress + " , port no " + this.portno + "\n");
        while (!this.pleaseStop) {
            ++this.requestNo;
            try {
                int b2;
                Socket client_socket;
                this.writeLog("[" + this.requestNo + "] Waiting for request...\n");
                try {
                    client_socket = this.socket.accept();
                }
                catch (IOException ex) {
                    this.writeLog("Failed to accept incoming request.\n" + ex.getMessage(), true);
                    continue;
                }
                BufferedInputStream bin = new BufferedInputStream(client_socket.getInputStream());
                boolean isHTTP = true;
                bin.mark(4);
                int b4 = 0;
                int b3 = 0;
                int b1 = bin.read();
                if (b1 == 80) {
                    b2 = bin.read();
                    if (b2 != 79) {
                        isHTTP = false;
                    } else {
                        b3 = bin.read();
                    }
                    if (b3 != 83) {
                        isHTTP = false;
                    } else {
                        b4 = bin.read();
                    }
                    if (b4 != 84) {
                        isHTTP = false;
                    }
                } else if (b1 == 71) {
                    b2 = bin.read();
                    if (b2 != 69) {
                        isHTTP = false;
                    } else {
                        b3 = bin.read();
                    }
                    if (b3 != 84) {
                        isHTTP = false;
                    }
                } else {
                    isHTTP = false;
                }
                bin.reset();
                if (isHTTP) {
                    this.writeLog("HTTP request received\n");
                    new MessageThread(this, new HttpServerConnection(client_socket, bin), this.requestNo).start();
                } else {
                    this.writeLog("Socket request received\n");
                    new MessageThread(this, new SocketConnection(client_socket, bin), this.requestNo).start();
                }
                if (!showMonitor || sm == null) continue;
                ++Server.sm.smui.vIO_request;
            }
            catch (Exception ex) {
                this.writeLog("[" + this.requestNo + "] " + ex.toString());
            }
            catch (Error err) {
                this.writeLog("[" + this.requestNo + "] " + err.toString());
            }
        }
    }

    public void processMessage(IConnection conn) {
        new MessageThread(this, conn, this.requestNo).processMessage();
    }

    public void getSectionHeading(BufferedReader in, String s) {
        try {
            String line;
            while ((line = in.readLine()) != null && ((line = line.trim()) == null || line.equals("") || line.equals(" ") || !line.equalsIgnoreCase(s))) {
            }
        }
        catch (Exception ex) {
            this.do_exit("Failed to get section heading " + s + " from the configuration file.\n");
        }
    }

    void readScheduleList() throws Exception {
        if (this.startFromOrganizer) {
            return;
        }
        File fFile = new File(scheduleFile);
        if (!fFile.exists()) {
            return;
        }
        FileInputStream fstream = new FileInputStream(fFile);
        DataInputStream din = new DataInputStream(fstream);
        VersioningDataInput in = new VersioningDataInput(din, 148);
        int readIn = in.readInt();
        int version = 0;
        int size = 0;
        if (readIn == -1) {
            version = in.readInt();
            size = in.readInt();
        } else {
            size = readIn;
            version = ServerMessage.getVersion();
        }
        Vector<ScheduleObject> vec = new Vector<ScheduleObject>();
        for (int i = 0; i < size; ++i) {
            vec.addElement(ScheduleObject.read(in, version));
        }
        din.close();
        fstream.close();
        this.scheduleList = vec;
    }

    void writeScheduleList() throws Exception {
        if (this.startFromOrganizer) {
            return;
        }
        File fFile = new File(scheduleFile);
        FileOutputStream fstream = new FileOutputStream(fFile);
        DataOutputStream dout = new DataOutputStream(fstream);
        VersioningDataOutput out = new VersioningDataOutput(dout);
        out.writeInt(-1);
        out.writeInt(148);
        out.writeInt(this.scheduleList.size());
        for (int i = 0; i < this.scheduleList.size(); ++i) {
            ScheduleObject schObj = this.scheduleList.elementAt(i);
            schObj.write(out);
        }
        dout.close();
        fstream.close();
    }

    void readServerCommands() {
        File fFile = new File(configDir, COMMAND_BASE);
        String line = this.readLineFromFile(fFile);
        if (line == null) {
            fFile = new File(orgCommand);
            line = this.readLineFromFile(fFile);
        }
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (this.orgCommandOnly(token)) continue;
                this.serverCommands.addElement(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    String readLineFromFile(File fFile) {
        String line = null;
        FileInputStream fstream = null;
        BufferedReader din = null;
        try {
            fstream = new FileInputStream(fFile);
            din = new BufferedReader(new InputStreamReader(fstream));
            line = din.readLine();
        }
        catch (IOException iOException) {
            CloseUtils.close(din);
            CloseUtils.close(fstream);
            catch (Throwable throwable) {
                CloseUtils.close(din);
                CloseUtils.close(fstream);
                throw throwable;
            }
        }
        CloseUtils.close(din);
        CloseUtils.close(fstream);
        return line;
    }

    private void updateConfigFile() throws Exception {
        File inFile = new File(configDir, CONFIG_BASE);
        if (ServerMessage.isServlet() && !LCKey.isERES() && !LCKey.isDashboard()) {
            try {
                URL url = Server.class.getResource("/userdb/config.txt");
                if (url != null) {
                    inFile = Paths.get(url.toURI()).toFile();
                }
            }
            catch (URISyntaxException e) {
                inFile = new File(configDir, CONFIG_BASE);
            }
        }
        File outFile = new File(ServerMessage.getWorkingDirectory(), "tempfile.txt");
        FileInputStream fis = new FileInputStream(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        FileOutputStream fos = new FileOutputStream(outFile);
        PrintWriter out = new PrintWriter(fos);
        String thisLine = "";
        String oldPassword = "";
        boolean encodePassword = false;
        int numOfUser = 0;
        while ((thisLine = in.readLine()) != null) {
            if ((thisLine = thisLine.trim()).equals("[smtp host]")) {
                encodePassword = false;
            }
            if (thisLine.equals("{user-name encoded-password}")) {
                out.close();
                in.close();
                return;
            }
            if (encodePassword) {
                if (numOfUser == 0) {
                    out.println("{user-name encoded-password}");
                }
                String name = "";
                int idx = thisLine.indexOf(32);
                if (idx > 0) {
                    name = thisLine.substring(0, idx);
                    oldPassword = thisLine.substring(idx + 1).trim();
                    out.println(name + " " + Coder.encode(oldPassword));
                } else {
                    out.println(thisLine);
                }
                ++numOfUser;
                continue;
            }
            if (thisLine.equals("[users]")) {
                encodePassword = true;
            }
            out.println(thisLine);
        }
        out.flush();
        out.close();
        in.close();
        ((InputStream)fis).close();
        inFile.delete();
        outFile.renameTo(inFile);
    }

    void getUsersInfo() {
        try {
            this.updateConfigFile();
        }
        catch (Exception ex) {
            this.do_exit("Failed to update the configuration file.\n");
        }
        FileInputStream fstream = null;
        try {
            String line;
            URL url;
            File fFile = new File(configDir, CONFIG_BASE);
            if (ServerMessage.isServlet() && !LCKey.isERES() && !LCKey.isDashboard() && (url = ServerMessage.class.getResource("/userdb/config.txt")) != null) {
                try {
                    fFile = Paths.get(url.toURI()).toFile();
                }
                catch (URISyntaxException e) {
                    fFile = new File(configDir, CONFIG_BASE);
                }
            }
            fstream = new FileInputStream(fFile);
            BufferedReader din = new BufferedReader(new InputStreamReader(fstream));
            this.getSectionHeading(din, "[port]");
            this.portno = 22071;
            while ((line = din.readLine()) != null) {
                if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                int idx = line.indexOf(44);
                int idx2 = line.lastIndexOf(44);
                this.hostName = new Vector();
                while (idx != idx2) {
                    this.hostName.addElement(line.substring(idx2 + 1).trim());
                    line = line.substring(0, idx2);
                    idx2 = line.lastIndexOf(44);
                }
                if (idx > 0) {
                    this.ipaddress = line.substring(idx + 1).trim();
                    if (this.ipaddress.equals("")) {
                        this.ipaddress = null;
                    }
                    line = line.substring(0, idx);
                }
                try {
                    this.portno = Integer.parseInt(line);
                    break;
                }
                catch (Exception ex) {
                    this.portno = 22071;
                    this.writeLog("Error in parsing port no, " + ex.toString() + "!\n Use default value " + this.portno + ".\n");
                    break;
                }
            }
            File f = null;
            try {
                this.getSectionHeading(din, "[webroot]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    if ((line.endsWith("/") || line.endsWith("\\")) && line.length() > 1) {
                        line = line.substring(0, line.length() - 1);
                    }
                    this.urlPath = line;
                    break;
                }
                f = new File(this.mainPath);
            }
            catch (Exception ex3) {
                this.do_exit("Fail to read information of web server root directory !");
            }
            if (!f.exists()) {
                this.do_exit("Directory " + this.mainPath + " does not exist !");
            }
            if (!f.isDirectory()) {
                this.do_exit(this.mainPath + " is not a valid directory !");
            }
            if (!f.canWrite()) {
                this.do_exit("Directory " + this.mainPath + " is not writable !");
            }
            this.userInfo = new Vector();
            try {
                this.getSectionHeading(din, "[users]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    int idx = line.indexOf(32);
                    if (!line.equals("[smtp host]")) {
                        if (idx <= 0) {
                            this.userInfo.addElement(new UserInfo(line, ""));
                            continue;
                        }
                        if (line.equals("{user-name encoded-password}")) continue;
                        this.userInfo.addElement(new UserInfo(line.substring(0, idx), line.substring(idx + 1).trim()));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception idx) {
                // empty catch block
            }
            if (this.userInfo.size() == 0) {
                throw new IOException("No users information in " + configFile);
            }
            smtpHostName = "";
            smtpSecure = false;
            smtpSSL = false;
            smtpPort = -1;
            smtpUserName = "";
            smtpPassword = "";
            try {
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    if (line.equals("[smtp secured]")) break;
                    smtpHostName = line;
                    break;
                }
                this.getSectionHeading(din, "[smtp secured]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    if (line.equals("[smtp ssl]")) break;
                    smtpSecure = line.equalsIgnoreCase("true");
                    break;
                }
                this.getSectionHeading(din, "[smtp ssl]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    if (line.equals("[smtp port]")) break;
                    smtpSSL = line.equalsIgnoreCase("true");
                    break;
                }
                this.getSectionHeading(din, "[smtp port]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    if (line.equals("[smtp username]")) break;
                    smtpPort = Integer.parseInt(line);
                    break;
                }
                this.getSectionHeading(din, "[smtp username]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    if (line.equals("[smtp password]")) break;
                    smtpUserName = line;
                    break;
                }
                this.getSectionHeading(din, "[smtp password]");
                while ((line = din.readLine()) != null) {
                    if ((line = line.trim()) == null || line.equals("") || line.equals(" ")) continue;
                    smtpPassword = line;
                    break;
                }
            }
            catch (Exception ex3) {
                System.out.println("Fail to read information of smtp information !");
            }
            din.close();
            fstream.close();
        }
        catch (Exception ex) {
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.do_exit("Failed to read user's database file " + configFile + " under the installation directory : " + ex.getMessage());
        }
    }

    void createLogFile() {
        try {
            this.logstream = new DataOutputStream(new FileOutputStream(serverLog));
        }
        catch (IOException ex) {
            this.do_exit("Failed to create log file !\n" + ex.getMessage());
        }
    }

    synchronized void writeLog(String s) {
        this.writeLog(s, false);
    }

    synchronized void writeLog(String s, boolean berror) {
        block5: {
            if (this.service && berror) {
                Server.print('1' + s + '\u0000');
            }
            if (showMonitor) {
                Server.sm.smui.ta.append(s);
            }
            if (this.logstream != null) {
                try {
                    this.logstream.writeBytes(s);
                }
                catch (IOException ex) {
                    if (this.service) break block5;
                    Server.println("Failed to write log !\n" + ex.getMessage());
                }
            }
        }
    }

    void createScheduleLogFile() {
        try {
            this.schlogstream = new DataOutputStream(new FileOutputStream(scheduleLog));
        }
        catch (IOException ex) {
            this.do_exit("Failed to create schedule log file !\n" + ex.getMessage());
        }
    }

    synchronized void writeScheduleLog(String s) {
        this.writeScheduleLog(s, false);
    }

    synchronized void writeScheduleLog(String s, boolean berror) {
        block5: {
            if (this.service && berror) {
                Server.print('1' + s + '\u0000');
            }
            if (showMonitor) {
                Server.sm.smui.ta.append(s);
            }
            if (this.schlogstream != null) {
                try {
                    this.schlogstream.writeBytes(s + "\n");
                }
                catch (IOException ex) {
                    if (this.service) break block5;
                    Server.println("Failed to write log !\n" + ex.getMessage());
                }
            }
        }
    }

    synchronized void incRequestIONo() {
        ++this.requestIONo;
    }

    synchronized void incRequestSQLNo() {
        ++this.requestSQLNo;
    }

    boolean removeFile(String filename) {
        File f = new File(this.getPath(filename));
        if (f.exists()) {
            f.delete();
            return true;
        }
        return false;
    }

    public void shutDownMonitor() {
        if (showMonitor && sm != null && Server.sm.smui != null) {
            --Server.sm.smui.vThread;
            Server.sm.smui.setVisible(false);
            Server.sm.smui.dispose();
        }
    }

    public void stopServer() {
        this.shutDownMonitor();
        try {
            this.writeScheduleList();
        }
        catch (Exception ex) {
            Server.print(this, "Fail to write schedule list!");
            ex.printStackTrace();
        }
        this.deleteAllPageFiles();
        this.deleteAllDHTMLViewerFiles();
        Server.println(this, "STOP SERVER");
        if (!ServerMessage.isServlet()) {
            System.exit(0);
        }
    }

    public void initServer(Server sv, String[] argv) {
        sv.prepare(sv, argv);
        sv.runScheduleThread = new RunScheduleThread(sv);
        sv.runScheduleThread.start();
        sv.cleanupPageFilesTableThread = new CleanupPageFilesTableThread(sv);
        sv.cleanupPageFilesTableThread.start();
    }

    private void prepare(Server sv, String[] argv) {
        if (argv == null || argv.length == 0) {
            argv = sv.mergeCommands(argv);
        }
        String Time2 = null;
        try {
            for (String element : argv) {
                if (element.equals("-help") || element.equals("-h") || element.equals("-?")) {
                    Server.help();
                } else {
                    if (element.equals("-log")) {
                        if (!sv.startFromOrganizer) {
                            sv.createScheduleLogFile();
                        }
                        sv.createLogFile();
                        continue;
                    }
                    if (element.equals("-NTservice")) {
                        sv.service = true;
                        continue;
                    }
                    if (element.equals("-RequireLogin")) {
                        sv.qbLoginRequired = true;
                        continue;
                    }
                    if (element.startsWith("-QbDesignerPassword:")) {
                        sv.qbDesignerPassword = element.substring(20);
                        sv.qbLoginRequired = true;
                        continue;
                    }
                    if (element.startsWith("-SchedulerCallBackClass:")) {
                        sv.schedulerCallBackClass = element.substring(24);
                        continue;
                    }
                    if (element.startsWith("-debug:")) {
                        QbDebug.setDebugMode(element.substring(7));
                        continue;
                    }
                    if (element.startsWith("-DBBuffer:")) {
                        int buffer = Integer.valueOf(element.substring(10));
                        if (buffer >= 0 && buffer < 1000) {
                            if (buffer == 0) {
                                buffer = 1;
                            }
                            nBuffer = buffer;
                            continue;
                        }
                        Server.println("-DBBuffer: argument incorrect or out of range");
                        Server.syntaxError();
                    } else {
                        if (element.startsWith("-DBCleanAll:")) {
                            Time2 = element.substring(12);
                            continue;
                        }
                        if (element.startsWith("-PageCleanUpTime:")) {
                            this.pageCleanupTime = (long)Integer.valueOf(element.substring(17)).intValue() * 3600000L;
                            continue;
                        }
                        if (element.startsWith("-DHTMLViewerBufferCleanUpTime:")) {
                            dhtmlViewerBufferCleanupTime = (long)Integer.valueOf(element.substring(30)).intValue() * 3600000L;
                            continue;
                        }
                        if (element.startsWith("-PageViewerBufferCleanUpTime:")) {
                            pageViewerBufferCleanupTime = (long)Integer.valueOf(element.substring(29)).intValue() * 3600000L;
                            continue;
                        }
                        if (element.startsWith("-monitor:")) {
                            String str = element.substring(9).trim();
                            if (str.equals("ON")) {
                                if (this.isUIAvailiable()) {
                                    showMonitor = true;
                                    continue;
                                }
                                System.out.println("Warning:  Cannot display monitor.  Server will run without monitor.");
                                showMonitor = false;
                                continue;
                            }
                            if (str.equals("OFF")) {
                                showMonitor = false;
                                continue;
                            }
                        } else {
                            if (element.startsWith("-recordLimit:")) {
                                int buffer = Integer.valueOf(element.substring(13));
                                ServerMessage.setRecordLimit(buffer);
                                continue;
                            }
                            if (element.startsWith("-MaxRecordInMemory:")) {
                                System.out.println("WARNING: MaxRecordInMemory has been replaced by PagingThreshold");
                                continue;
                            }
                            if (element.startsWith("-FileRecordBufferSize:")) {
                                System.out.println("WARNING: FileRecordBufferSize has been replaced by PageBufferSize");
                                continue;
                            }
                            if (element.startsWith("-MaxCharForRecordFile:")) {
                                System.out.println("WARNING: MaxCharForRecordFile has been replaced by MaxFieldSize");
                                continue;
                            }
                            if (element.startsWith("-PagingThreshold:")) {
                                int buffer = Integer.valueOf(element.substring(17));
                                ServerMessage.setPagingThreshold(buffer);
                                continue;
                            }
                            if (element.startsWith("-PageBufferSize:")) {
                                int buffer = Integer.valueOf(element.substring(16));
                                ServerMessage.setPageBufferSize(buffer);
                                continue;
                            }
                            if (element.startsWith("-MaxFieldSize:")) {
                                int buffer = Integer.valueOf(element.substring(14));
                                ServerMessage.setMaxFieldSize(buffer);
                                continue;
                            }
                            if (element.startsWith("-TotalPageBufferSize:")) {
                                int buffer = Integer.valueOf(element.substring(21));
                                ServerMessage.setTotalPageBufferSize(buffer);
                                continue;
                            }
                            if (element.startsWith("-runInBackground:")) {
                                String str = element.substring(17).trim();
                                if (str.equals("ON")) {
                                    runInBackground = true;
                                    continue;
                                }
                                if (str.equals("OFF")) {
                                    runInBackground = false;
                                    continue;
                                }
                            } else {
                                if (element.startsWith("-globalFormat:")) {
                                    ServerMessage.setDefaultGlobalFormat(element.substring(14, element.length()));
                                    continue;
                                }
                                if (element.startsWith("-defaultDateFormat:")) {
                                    QbDateFormat.setDefaultDateFormat(element.substring(19, element.length()).replaceAll("SPACE", " "));
                                    continue;
                                }
                                if (element.startsWith("-defaultTimeFormat:")) {
                                    QbDateFormat.setDefaultTimeFormat(element.substring(19, element.length()).replaceAll("SPACE", " "));
                                    continue;
                                }
                                if (element.startsWith("-defaultTimestampFormat:")) {
                                    QbDateFormat.setDefaultTimestampFormat(element.substring(24, element.length()).replaceAll("SPACE", " "));
                                    continue;
                                }
                                if (element.startsWith("-fontMapping:")) {
                                    ServerMessage.setDefaultFontMapping(element.substring(13, element.length()));
                                    continue;
                                }
                                if (element.startsWith("-exportEncoding:")) {
                                    ServerMessage.setExportEncoding(element.substring(16, element.length()));
                                    continue;
                                }
                                if (element.startsWith("-htmlDpi:")) {
                                    QbUtil.pixelPerInchExport = Integer.parseInt(element.substring(9, element.length()));
                                    continue;
                                }
                                if (element.startsWith("-ListenerManagerClass:")) {
                                    sv.listenerManager = this.loadListenerManager(element.substring(22));
                                    continue;
                                }
                                if (element.startsWith("-schedulerThreadLimit:")) {
                                    this.exportThreadLimit = Integer.parseInt(element.substring(22));
                                    continue;
                                }
                                if (element.startsWith("-schedulerBuffer:")) {
                                    QbObjectPool.setCapacity(Integer.parseInt(element.substring(17)));
                                    continue;
                                }
                                if (element.startsWith("-xmlEncoding:")) {
                                    String xmlEncoding = element.substring(13);
                                    if (xmlEncoding == null || xmlEncoding.trim().equals("")) continue;
                                    ServerMessage.setXMLEncoding(xmlEncoding);
                                    continue;
                                }
                                if (element.startsWith("-paperSize:")) {
                                    String paperSize = element.substring(11);
                                    ServerMessage.setPaperSize(paperSize);
                                    continue;
                                }
                                if (element.equals("-singleTableForDistinctParamValue")) {
                                    ServerMessage.setUseSingleTableForDistinctParamValue(true);
                                    continue;
                                }
                                if (element.startsWith("-queryTimeout:")) {
                                    QbConnection.setQueryTimeout(Integer.parseInt(element.substring(14)));
                                    continue;
                                }
                                if (element.equals("-disableDataViewInQuickDesigner")) {
                                    ServerMessage.setEnableDataViewInQuickDesigner(false);
                                    continue;
                                }
                                if (element.equals("-disableSaveQueryInQuickDesigner")) {
                                    ServerMessage.setEnableSaveQueryInQuickDesigner(false);
                                    continue;
                                }
                                if (element.startsWith("-ReplaceColumnInfoList:") || element.startsWith("-QuickDesignerSecuredParameters:") || element.startsWith("-runMissedScheduleJob:")) continue;
                                if (element.startsWith("-ExcelExportFitCell:")) {
                                    boolean fitCell = element.substring(20).equalsIgnoreCase("TRUE");
                                    QbReport.setExcelExportFitCell(fitCell);
                                    continue;
                                }
                                if (element.startsWith("-ExcelExportNonNumericFitCell:")) {
                                    boolean nonNumericFitCell = element.substring(30).equalsIgnoreCase("TRUE");
                                    QbReport.setExcelExportNonNumericFitCell(nonNumericFitCell);
                                    continue;
                                }
                                if (element.startsWith("-ExcelExportStreaming")) {
                                    boolean streaming = element.substring(22).equalsIgnoreCase("TRUE");
                                    QbReport.setExcelExportStreaming(streaming);
                                    continue;
                                }
                                if (element.startsWith("-ExportNewlineDelimiter:")) {
                                    String delim = element.substring(element.indexOf(58) + 1);
                                    CSVReport.setDefaultNewlineDelim(delim);
                                    continue;
                                }
                                if (element.startsWith("-writeLogToDatabase") || element.startsWith("-cleanupIntervalForLog:") || element.startsWith("-deploySOAPService") || element.startsWith("-showViewPrivilege:") || element.startsWith("-hideReportMenuItems:") || element.startsWith("-removeScheduleIcon:") || element.startsWith("-QDResizeToFitContentDefault:") || element.startsWith("-QDNullValueHandler:") || element.startsWith("-LoginListenerClass:")) continue;
                            }
                        }
                    }
                }
                System.out.println("Unrecognized Option: " + element);
                Server.syntaxError();
            }
            connectionBuffer = new ConnectionBuffer(nBuffer);
            if (Time2 != null && nBuffer > 0) {
                dbr = new DBRefresh(Time2, connectionBuffer);
                if (DBRefresh.getInterval() < 0) {
                    Server.syntaxError();
                }
                dbr.start();
            }
        }
        catch (Exception ex) {
            Server.syntaxError();
        }
    }

    private boolean isUIAvailiable() {
        try {
            new JFrame();
            new JPanel();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
        catch (Error err) {
            return false;
        }
    }

    private String[] mergeCommands(String[] argv) {
        String[] res = new String[this.serverCommands.size() + argv.length];
        int i = 0;
        for (i = 0; i < this.serverCommands.size(); ++i) {
            res[i] = this.serverCommands.elementAt(i);
        }
        String[] stringArray = argv;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String element;
            res[i] = element = stringArray[j];
            ++i;
        }
        return res;
    }

    synchronized String checkReadPermission(String filename, String machine) {
        try {
            String lcFilename = filename.toLowerCase();
            if (lcFilename.startsWith("http://") || lcFilename.startsWith("https://") || !lcFilename.endsWith(".rpt") && !lcFilename.endsWith(".pak") && !lcFilename.endsWith(".xml") || lcFilename.replace('\\', '/').indexOf("drilldown/") >= 0 || lcFilename.replace('\\', '/').indexOf("subreport/") >= 0) {
                return null;
            }
            if (lcFilename.endsWith(".xml") && !Server.isXMLReport(filename)) {
                return null;
            }
            String absPath = ServerMessage.getPath(filename).toUpperCase();
            String frommachine = this.lockedFiles.get(absPath);
            String candidate = null;
            if (frommachine != null) {
                if (!this.startFromOrganizer) {
                    String fromMachineName = frommachine;
                    String fromUserToken = "";
                    Hashtable<String, String> machineAttr = this.parseClientAddress(frommachine);
                    fromMachineName = machineAttr.get("IPAddress");
                    fromUserToken = machineAttr.get("OrgUserToken");
                    if (fromUserToken == null) {
                        fromUserToken = "";
                    }
                    for (int i = 0; i < this.userInfo.size(); ++i) {
                        UserInfo info = this.userInfo.elementAt(i);
                        if (!frommachine.equals(info.machine) || !info.isLoggedIn() || frommachine.equals(machine)) continue;
                        Hashtable<String, String> reqMachineAttr = this.parseClientAddress(machine);
                        String reqUserToken = reqMachineAttr.get("OrgUserToken");
                        if (reqUserToken == null) {
                            reqUserToken = "";
                        }
                        if (fromUserToken.equals("") || reqUserToken.equals("")) {
                            candidate = info.user;
                            break;
                        }
                        if (fromUserToken.equals(reqUserToken)) continue;
                        candidate = info.user;
                        break;
                    }
                    if (candidate == null) {
                        LOGGER.finest("LOCKING FILE - frommachine not null - absPath - " + absPath + " - machine - " + machine);
                        this.lockedFiles.put(absPath, machine);
                        return null;
                    }
                    String errMsg = "Access Denied!\nThis file (" + absPath + ") is already opened by '" + candidate + "' at '" + fromMachineName + "'.";
                    LOGGER.finest(errMsg);
                    return errMsg;
                }
                if (!frommachine.equals(machine)) {
                    Hashtable<String, String> fromMachineAttr = this.parseClientAddress(frommachine);
                    String fromMachineName = fromMachineAttr.get("IPAddress");
                    String fromUserToken = fromMachineAttr.get("OrgUserToken");
                    String fromUserName = fromMachineAttr.get("OrgUserName");
                    if (fromUserToken == null) {
                        fromUserToken = "";
                    }
                    Hashtable<String, String> reqMachineAttr = this.parseClientAddress(machine);
                    String machineUserToken = reqMachineAttr.get("OrgUserToken");
                    if (!fromUserToken.equals("") && fromUserToken.equals(machineUserToken)) {
                        return null;
                    }
                    String errMsg = "Access Denied!\nThis file (" + absPath + ") is already opened at '" + fromMachineName + (fromUserName != null ? "' by " + fromUserName : "") + ".";
                    LOGGER.finest(errMsg);
                    return errMsg;
                }
                return null;
            }
            if (absPath != null && machine != null) {
                LOGGER.finest("LOCKING FILE - absPath - " + absPath + " - machine - " + machine);
                this.lockedFiles.put(absPath, machine);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ListenerManager loadListenerManager(String className) {
        try {
            Class<?> objClass = Class.forName(className);
            Constructor<?> objCons = objClass.getConstructor(new Class[0]);
            Object lmClass = objCons.newInstance(new Object[0]);
            if (!(lmClass instanceof ListenerManager)) {
                return null;
            }
            return (ListenerManager)lmClass;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    boolean orgCommandOnly(String token) {
        return token.startsWith("-UserSecurityProviderClass:");
    }

    int getExportThreadLimit() {
        return this.exportThreadLimit;
    }

    private Hashtable<String, String> parseClientAddress(String clientAddress) {
        Hashtable<String, String> kvPair = new Hashtable<String, String>();
        int loc = clientAddress.indexOf(63);
        if (loc < 0) {
            kvPair.put("IPAddress", clientAddress);
            return kvPair;
        }
        kvPair.put("IPAddress", clientAddress.substring(0, loc));
        String kvStr = clientAddress.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(kvStr, "&");
        while (st.hasMoreTokens()) {
            String pairStr = st.nextToken();
            loc = pairStr.indexOf(61);
            String key = pairStr.substring(0, loc);
            String val = pairStr.substring(loc + 1);
            kvPair.put(key, val);
        }
        return kvPair;
    }

    public boolean isFileLocked(String fileName) {
        String obj = this.lockedFiles.get(fileName);
        return obj != null;
    }

    public List<String> getLockedFiles() {
        Enumeration<String> fileEnum = this.lockedFiles.keys();
        Vector<String> v = new Vector<String>();
        while (fileEnum.hasMoreElements()) {
            v.add(fileEnum.nextElement());
        }
        return v;
    }

    public List<String> getLockedHosts() {
        Enumeration<String> fileEnum = this.lockedFiles.keys();
        Hashtable<String, String> hostList = new Hashtable<String, String>();
        while (fileEnum.hasMoreElements()) {
            hostList.put(this.lockedFiles.get(fileEnum.nextElement()), "1");
        }
        Vector<String> v = new Vector<String>();
        Enumeration hostEnum = hostList.keys();
        while (hostEnum.hasMoreElements()) {
            v.add((String)hostEnum.nextElement());
        }
        return v;
    }

    public String getLockedHostName(String fileName) {
        String obj = this.lockedFiles.get(fileName);
        if (obj == null) {
            return null;
        }
        String hostInfoStr = obj;
        int loc = hostInfoStr.indexOf(63);
        String machine = hostInfoStr;
        if (loc > 0) {
            machine = hostInfoStr.substring(0, loc);
        }
        return machine;
    }

    public Hashtable<String, String> getLockedFilesTable() {
        return this.lockedFiles;
    }

    public Hashtable getOverrideTable() {
        return this.overrideFiles;
    }

    public void pleaseStop() {
        this.pleaseStop = true;
        this.interrupt();
    }

    static {
        dhtmlViewerBufferCleanupTime = 0x6DDD00L;
        pageViewerBufferCleanupTime = 0x6DDD00L;
        menuRoot = "menus/";
    }
}

