/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Date;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IOUtil;

public class ServerDirectorySlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public ServerDirectorySlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(30158)) {
            try {
                this.sendReply();
            }
            catch (Exception ex) {
                this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        IOUtil.writeString(dout, new File(ServerMessage.getWorkingDirectory()).getAbsolutePath());
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

