/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.server.AddUserDialog;
import quadbase.common.server.ChangePasswordDialog;
import quadbase.common.server.ConnectionBuffer;
import quadbase.common.server.DBRefresh;
import quadbase.common.server.DeleteUserDialog;
import quadbase.common.server.Server;
import quadbase.common.server.ServerMonitor;
import quadbase.common.server.UserInfo;
import quadbase.common.swing.BorderPanel;
import quadbase.common.util.internal.IOUtil;

class ServerMonitorUI
extends JFrame
implements ActionListener {
    ServerMonitor sm;
    JProgressBar prog;
    JProgressBar prog1;
    JPanel bup;
    JPanel bqp;
    JTextField bz;
    JMenuItem addUser;
    JMenuItem deleteUser;
    JMenuItem changePassword;
    JButton bzButton = new JButton("Change Buffer Number");
    JButton brButton = new JButton("Change");
    JButton nowButton = new JButton("Clean Now");
    JButton stopButton = new JButton("Shut Down");
    JList userlist = new JList();
    JTextArea ta;
    JTextField tDay;
    JTextField tHour;
    JTextField tMin;
    JTextField uptime;
    JTextField io_request;
    JTextField sql_request;
    JTextField nthread;
    JTextField mnuser;
    JTextField nuser;
    long vUptime = 0L;
    int vIO_request = 0;
    int vSQL_request = 0;
    int vThread = 0;
    int vMuser = 0;
    int vNuser = 0;
    private String QLOGO = ServerMessage.imagesPath + "QuadLogo.png";

    ServerMonitorUI(ServerMonitor sm) {
        this.setBackground(Color.lightGray);
        this.sm = sm;
        JPanel cop = (JPanel)this.getContentPane();
        this.setTitle("Espress Manager Monitor");
        this.setIconImage(IOUtil.getImage(this.QLOGO));
        JMenuBar menubar = new JMenuBar();
        JMenu updateMenu = new JMenu("Manage Users");
        menubar.add(updateMenu);
        this.addUser = new JMenuItem("Add New User");
        updateMenu.add(this.addUser);
        this.addUser.addActionListener(this);
        this.deleteUser = new JMenuItem("Delete Existing User");
        updateMenu.add(this.deleteUser);
        this.deleteUser.addActionListener(this);
        this.changePassword = new JMenuItem("Change Password");
        updateMenu.add(this.changePassword);
        this.changePassword.addActionListener(this);
        BorderPanel conn = new BorderPanel("Connection Information");
        JPanel server_uptime = new JPanel(new FlowLayout());
        server_uptime.add(new JLabel("Server Uptime:          "));
        this.uptime = new JTextField("", 15);
        server_uptime.add(this.uptime);
        JPanel No_of_IO = new JPanel(new FlowLayout());
        No_of_IO.add(new JLabel("No of IO requests:    "));
        this.io_request = new JTextField("", 15);
        No_of_IO.add(this.io_request);
        JPanel No_of_SQL = new JPanel(new FlowLayout());
        No_of_SQL.add(new JLabel("No of SQL requests:"));
        this.sql_request = new JTextField("", 15);
        No_of_SQL.add(this.sql_request);
        JPanel aux1 = new JPanel(new BorderLayout());
        aux1.add("Center", No_of_IO);
        aux1.add("North", server_uptime);
        aux1.add("South", No_of_SQL);
        JPanel pthread = new JPanel(new FlowLayout());
        pthread.add(new JLabel("No. of threads:    "));
        this.nthread = new JTextField("", 2);
        pthread.add(this.nthread);
        JPanel pmusers = new JPanel(new FlowLayout());
        pmusers.add(new JLabel("Max no. of users:"));
        this.mnuser = new JTextField("", 2);
        pmusers.add(this.mnuser);
        JPanel pnuser = new JPanel(new FlowLayout());
        pnuser.add(new JLabel("No. of users:       "));
        this.nuser = new JTextField("", 2);
        pnuser.add(this.nuser);
        JPanel aux2 = new JPanel(new BorderLayout());
        aux2.add("Center", pmusers);
        aux2.add("North", pthread);
        aux2.add("South", pnuser);
        conn.add("Center", aux1);
        conn.add("East", aux2);
        BorderPanel bufz = new BorderPanel("Buffer Number");
        this.bz = new JTextField("" + Server.nBuffer, 3);
        bufz.add("Center", this.bz);
        bufz.add("East", this.bzButton);
        this.bzButton.addActionListener(this);
        this.bup = new BorderPanel("Buffer Usage");
        this.prog = new JProgressBar();
        this.prog.setBounds(10, 10, 200, 20);
        this.prog.setMinimum(0);
        this.prog.setMaximum(100);
        this.bup.add(this.prog);
        this.prog.setValue((int)(sm.buffer_usage_percentage * 100.0));
        this.bqp = new BorderPanel("Buffer Hit Rate");
        this.prog1 = new JProgressBar();
        this.prog1.setMinimum(0);
        this.prog1.setMaximum(100);
        this.prog1.setBounds(10, 10, 200, 20);
        this.bqp.add(this.prog1);
        BorderPanel dbrefresh = new BorderPanel("Buffer Clean Up");
        JLabel l1 = new JLabel("Cleans every:");
        if (Server.dbr == null) {
            this.tDay = new JTextField("N/A", 3);
            this.tHour = new JTextField("N/A", 3);
            this.tMin = new JTextField("N/A", 3);
        } else {
            this.tDay = new JTextField(DBRefresh.day + "", 3);
            this.tHour = new JTextField(DBRefresh.hour + "", 3);
            this.tMin = new JTextField(DBRefresh.minute + "", 3);
        }
        JPanel p0 = new JPanel(new FlowLayout());
        p0.add(l1);
        p0.add(this.tDay);
        p0.add(new Label("day"));
        p0.add(this.tHour);
        p0.add(new Label("hour"));
        p0.add(this.tMin);
        p0.add(new Label("minute"));
        dbrefresh.add("North", p0);
        dbrefresh.add("Center", this.brButton);
        dbrefresh.add("South", this.nowButton);
        this.brButton.addActionListener(this);
        this.nowButton.addActionListener(this);
        this.prog1.setValue((int)(sm.buffer_query_percentage * 100.0));
        this.ta = new JTextArea("");
        JScrollPane log = new JScrollPane(this.ta);
        log.setBorder(new TitledBorder("Request Log"));
        JPanel p11 = new JPanel(new GridLayout(3, 1));
        p11.add(bufz);
        p11.add(this.bup);
        p11.add(this.bqp);
        JPanel p12 = new JPanel(new BorderLayout());
        p12.add("West", p11);
        p12.add("Center", log);
        this.stopButton.addActionListener(this);
        BorderPanel user = new BorderPanel("Current Users");
        this.setUserListPosition();
        Vector<String> userVec = new Vector<String>();
        for (int i = 0; i < sm.server.userInfo.size(); ++i) {
            String st = this.getUserInfo(sm.server.userInfo.elementAt(i));
            if (st == null) continue;
            userVec.addElement(st);
        }
        this.userlist.setListData(userVec);
        user.add("Center", this.userlist);
        JPanel central = new JPanel();
        central.setLayout(new BoxLayout(central, 1));
        central.add(conn);
        central.add(user);
        central.add(p12);
        central.add(dbrefresh);
        cop.add("North", menubar);
        cop.add("Center", central);
        cop.add("South", this.stopButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ServerMonitorUI.this.close();
                ((ServerMonitorUI)ServerMonitorUI.this).getSM().server.stopServer();
            }
        });
        this.pack();
        this.show();
    }

    private ServerMonitor getSM() {
        return this.sm;
    }

    private void close() {
        Server.showMonitor = false;
        Server.sm = null;
        this.dispose();
    }

    private void setUserListPosition() {
        Dimension oldSize = this.userlist.getSize();
        Point oldLocation = this.userlist.getLocation();
        this.userlist.setBounds(oldLocation.x - (360 - oldSize.width) / 2, oldLocation.y, 360, oldSize.height);
    }

    void refresh() {
        this.vMuser = this.sm.server.maxNoOfUser;
        this.vNuser = this.sm.server.userInfo.size();
        int tmphour = (int)(this.vUptime / 3600L);
        int tmpmin = (int)(this.vUptime % 3600L / 60L);
        int tmpsec = (int)(this.vUptime % 3600L % 60L);
        String utime = tmphour + " hr " + tmpmin + " min " + tmpsec + " sec";
        this.uptime.setText(utime);
        this.io_request.setText(this.vIO_request + "");
        this.sql_request.setText(this.sm.totalQuery + "");
        this.nthread.setText(this.vThread + "");
        this.mnuser.setText(this.vMuser + "");
        this.setUserListPosition();
        this.vNuser = 0;
        Vector<String> userVec = new Vector<String>();
        for (int i = 0; i < this.sm.server.userInfo.size(); ++i) {
            String st = this.getUserInfo(this.sm.server.userInfo.elementAt(i));
            if (st == null) continue;
            userVec.add(st);
            ++this.vNuser;
        }
        ListModel model = this.userlist.getModel();
        boolean setList = false;
        if (model.getSize() != userVec.size()) {
            setList = true;
        } else {
            for (int i = 0; i < userVec.size(); ++i) {
                if (model.getElementAt(i).toString().equals(((String)userVec.elementAt(i)).toString())) continue;
                setList = true;
                break;
            }
        }
        if (setList) {
            this.userlist.setListData(userVec);
        }
        this.nuser.setText(this.vNuser + "");
        this.prog.setValue((int)(this.sm.buffer_usage_percentage * 100.0));
        this.prog1.setValue((int)(this.sm.buffer_query_percentage * 100.0));
    }

    String getUserInfo(UserInfo userinfo) {
        String rS = "";
        if (userinfo.machine == null) {
            return null;
        }
        rS = userinfo.user;
        if (rS.length() >= 15) {
            rS = rS.substring(0, 14);
        } else {
            while (rS.length() < 15) {
                rS = rS + " ";
            }
        }
        rS = rS + userinfo.machine;
        if (rS.length() >= 40) {
            rS = rS.substring(0, 39);
        } else {
            while (rS.length() < 40) {
                rS = rS + " ";
            }
        }
        rS = rS + userinfo.time.toString();
        return rS;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (e.getSource() == this.addUser) {
            AddUserDialog addUserDlg = new AddUserDialog((Frame)this, this.sm.server.userInfo);
            addUserDlg.setVisible(true);
        } else if (e.getSource() == this.deleteUser) {
            DeleteUserDialog deleteUserDlg = new DeleteUserDialog((Frame)this, this.sm.server.userInfo);
            deleteUserDlg.setVisible(true);
        } else if (e.getSource() == this.changePassword) {
            ChangePasswordDialog changePwdDlg = new ChangePasswordDialog((Frame)this, this.sm.server.userInfo);
            changePwdDlg.setVisible(true);
        } else if (command.equals("Change Buffer Number")) {
            int nBuffer;
            try {
                nBuffer = Integer.valueOf(this.bz.getText());
            }
            catch (Exception ex) {
                nBuffer = Server.nBuffer;
                this.bz.setText(nBuffer + "");
            }
            if (nBuffer >= 0 && nBuffer < 1000 && nBuffer != Server.nBuffer) {
                if (nBuffer == 0) {
                    nBuffer = 1;
                }
                Server.nBuffer = nBuffer;
                this.sm.server.setConnectionBuffer(new ConnectionBuffer(nBuffer));
            }
        } else if (command.equals("Change")) {
            String d = this.tDay.getText().trim();
            String h = this.tHour.getText().trim();
            String m = this.tMin.getText().trim();
            if (Server.dbr == null) {
                int imin;
                int ihour;
                int iday;
                try {
                    iday = d.length() == 0 ? 0 : Integer.valueOf(d);
                    ihour = h.length() == 0 ? 0 : Integer.valueOf(h);
                    imin = m.length() == 0 ? 0 : Integer.valueOf(m);
                }
                catch (Exception exct) {
                    Server.dbr = null;
                    return;
                }
                if (iday + ihour + imin == 0) {
                    m = "1";
                }
                String time = d;
                time = time + (h.length() == 1 ? "0" + h : h);
                time = time + (m.length() == 1 ? "0" + m : m);
                Server.dbr = new DBRefresh(time, this.sm.server.getConnectionBuffer());
                if (DBRefresh.getInterval() >= 0) {
                    Server.dbr.start();
                } else {
                    Server.dbr = null;
                    this.tDay.setText("N/A");
                    this.tHour.setText("N/A");
                    this.tMin.setText("N/A");
                }
            } else {
                int imin;
                int ihour;
                int iday;
                try {
                    iday = d.length() == 0 ? 0 : Integer.valueOf(d);
                    ihour = h.length() == 0 ? 0 : Integer.valueOf(h);
                    imin = m.length() == 0 ? 0 : Integer.valueOf(m);
                }
                catch (Exception ext) {
                    Server.dbr = null;
                    this.tDay.setText("N/A");
                    this.tHour.setText("N/A");
                    this.tMin.setText("N/A");
                    return;
                }
                if (iday + ihour + imin == 0) {
                    ihour = 0;
                    iday = 0;
                    imin = 1;
                    this.tMin.setText("1");
                }
                DBRefresh.day = iday;
                DBRefresh.hour = ihour;
                DBRefresh.minute = imin;
                String out = "Clean up database buffer every ";
                if (DBRefresh.day > 0) {
                    out = out + DBRefresh.day + " day(s) ";
                }
                if (DBRefresh.hour > 0) {
                    out = out + DBRefresh.hour + " hour(s) ";
                }
                if (DBRefresh.minute > 0) {
                    out = out + DBRefresh.minute + " minute(s)";
                }
                Server.println(out);
            }
        } else if (command.equals("Clean Now")) {
            this.sm.server.getConnectionBuffer().refreshAll();
        } else if (command.equals("Shut Down")) {
            this.sm.server.stopServer();
        }
    }
}

