/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.OrgUtil;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.util.XMLResultSet;

public class StreamSlave
extends DataSlave {
    FileOutputStream fstream = null;
    String urlfile = null;
    boolean readOnly = false;

    public StreamSlave(MessageThread messageThread, Server server, IConnection socket) {
        this(messageThread, server, socket, false);
        this.urlfile = messageThread.infile;
    }

    public StreamSlave(MessageThread messageThread, Server server, IConnection socket, boolean readOnly) {
        super(messageThread, server, socket);
        this.readOnly = readOnly;
        this.urlfile = messageThread.infile;
    }

    InputStream getInputStream() throws Exception {
        InputStream conn = null;
        this.server.writeLog(this.getHeader() + "start...\n");
        if (OrgUtil.isReportData(this.urlfile)) {
            return new ByteArrayInputStream(OrgUtil.getReportData(this.urlfile));
        }
        if (OrgUtil.isChartData(this.urlfile)) {
            return new ByteArrayInputStream(OrgUtil.getChartData(this.urlfile));
        }
        if (OrgUtil.isDashboardData(this.urlfile)) {
            return new ByteArrayInputStream(OrgUtil.getDashboardData(this.urlfile));
        }
        if (OrgUtil.isMapData(this.urlfile)) {
            return new ByteArrayInputStream(OrgUtil.getMapData(this.urlfile));
        }
        this.urlfile = IOUtil.nameToURL(this.server.mainPath, this.messageThread.infile);
        if (this.urlfile.startsWith("http://")) {
            conn = new URL(this.urlfile).openStream();
        } else if (this.urlfile.startsWith("https://")) {
            conn = HttpsIO.getHttpsInputStream(this.urlfile);
        } else if (this.messageThread.infile.startsWith("/") || this.messageThread.infile.indexOf(":/") >= 0) {
            if (this.messageThread.infile.startsWith("file:/")) {
                this.messageThread.infile = this.messageThread.infile.substring(6);
                if (!this.messageThread.infile.startsWith("/") && this.messageThread.infile.indexOf(":") < 0) {
                    this.messageThread.infile = "/" + this.messageThread.infile;
                }
            }
            conn = new FileInputStream(this.messageThread.infile);
        } else {
            File connFile = new File(this.server.mainPath, this.messageThread.infile);
            if (!connFile.exists() && connFile.getCanonicalPath().endsWith(".cfg")) {
                connFile.createNewFile();
            }
            conn = new FileInputStream(connFile);
        }
        return conn;
    }

    quadbase.util.IResultSet createXMLResultSet() throws Exception {
        this.urlfile = IOUtil.nameToURL(this.server.mainPath, this.messageThread.infile);
        if (this.urlfile.startsWith("http://") || this.urlfile.startsWith("https://")) {
            return new XMLResultSet(this.urlfile);
        }
        if (this.messageThread.infile.startsWith("/") || this.messageThread.infile.indexOf(":/") >= 0) {
            return new XMLResultSet(new File(this.messageThread.infile));
        }
        return new XMLResultSet(new File(this.server.mainPath, this.messageThread.infile));
    }

    quadbase.util.IResultSet createClassResultSet() throws Exception {
        Class<?> objClass = Class.forName(this.messageThread.infile);
        Constructor<?> objCons = objClass.getConstructor(new Class[0]);
        Object resultSetClass = objCons.newInstance(new Object[0]);
        Method objMethod = objClass.getMethod("getResultSet", new Class[0]);
        Object obj = objMethod.invoke(resultSetClass, new Object[0]);
        if (obj instanceof IResultSet) {
            return CastUtil.cast((IResultSet)obj);
        }
        return (quadbase.util.IResultSet)obj;
    }

    @Override
    byte[] readData() {
        byte[] indata;
        if (this.urlfile == null || this.urlfile.equals("")) {
            this.cleanup(3, "Server failed to process empty file\n");
            return null;
        }
        DataInputStream instream = null;
        try {
            int nread;
            InputStream conn = this.getInputStream();
            instream = new DataInputStream(conn);
            ByteArrayOutputStream boutput = new ByteArrayOutputStream(100);
            DataOutputStream dout = new DataOutputStream(boutput);
            byte[] buf = new byte[100];
            while ((nread = instream.read(buf, 0, 100)) >= 0) {
                dout.write(buf, 0, nread);
            }
            indata = boutput.toByteArray();
        }
        catch (IOException ex) {
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
            return null;
        }
        catch (Exception ex) {
            this.cleanup(-2, ex.toString() + "\n");
            return null;
        }
        catch (OutOfMemoryError err) {
            this.cleanup(2, err.toString() + "\n");
            return null;
        }
        catch (Error err) {
            this.cleanup(-1, err.toString() + "\n");
            return null;
        }
        try {
            instream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return indata;
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.urlfile + " -- ";
    }

    @Override
    boolean authenticate(int messageType) {
        boolean passed = super.authenticate(messageType);
        if (this.readOnly) {
            return true;
        }
        if (passed) {
            String errmsg = this.server.checkReadPermission(this.urlfile, this.messageThread.remoteAddr);
            if (errmsg == null) {
                return true;
            }
            this.cleanup(5, errmsg);
            return false;
        }
        return false;
    }
}

